import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNotebooksLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_location#id GoogleNotebooksLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the Location resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_location#name GoogleNotebooksLocation#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_location#project GoogleNotebooksLocation#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_location#timeouts GoogleNotebooksLocation#timeouts}
    */
    readonly timeouts?: GoogleNotebooksLocationTimeouts;
}
export interface GoogleNotebooksLocationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_location#create GoogleNotebooksLocation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_location#delete GoogleNotebooksLocation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_location#update GoogleNotebooksLocation#update}
    */
    readonly update?: string;
}
export declare function googleNotebooksLocationTimeoutsToTerraform(struct?: GoogleNotebooksLocationTimeoutsOutputReference | GoogleNotebooksLocationTimeouts | cdktf.IResolvable): any;
export declare class GoogleNotebooksLocationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksLocationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNotebooksLocationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_location google_notebooks_location}
*/
export declare class GoogleNotebooksLocation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_notebooks_location";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_location google_notebooks_location} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNotebooksLocationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleNotebooksLocationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): GoogleNotebooksLocationTimeoutsOutputReference;
    putTimeouts(value: GoogleNotebooksLocationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNotebooksLocationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
