import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNotebooksRuntimeIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#id GoogleNotebooksRuntimeIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#location GoogleNotebooksRuntimeIamMember#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#member GoogleNotebooksRuntimeIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#project GoogleNotebooksRuntimeIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#role GoogleNotebooksRuntimeIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#runtime_name GoogleNotebooksRuntimeIamMember#runtime_name}
    */
    readonly runtimeName: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#condition GoogleNotebooksRuntimeIamMember#condition}
    */
    readonly condition?: GoogleNotebooksRuntimeIamMemberCondition;
}
export interface GoogleNotebooksRuntimeIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#description GoogleNotebooksRuntimeIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#expression GoogleNotebooksRuntimeIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member#title GoogleNotebooksRuntimeIamMember#title}
    */
    readonly title: string;
}
export declare function googleNotebooksRuntimeIamMemberConditionToTerraform(struct?: GoogleNotebooksRuntimeIamMemberConditionOutputReference | GoogleNotebooksRuntimeIamMemberCondition): any;
export declare class GoogleNotebooksRuntimeIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNotebooksRuntimeIamMemberCondition | undefined;
    set internalValue(value: GoogleNotebooksRuntimeIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member google_notebooks_runtime_iam_member}
*/
export declare class GoogleNotebooksRuntimeIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_notebooks_runtime_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_notebooks_runtime_iam_member google_notebooks_runtime_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNotebooksRuntimeIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNotebooksRuntimeIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _runtimeName?;
    get runtimeName(): string;
    set runtimeName(value: string);
    get runtimeNameInput(): string | undefined;
    private _condition;
    get condition(): GoogleNotebooksRuntimeIamMemberConditionOutputReference;
    putCondition(value: GoogleNotebooksRuntimeIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleNotebooksRuntimeIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
