import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleOrganizationIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member#id GoogleOrganizationIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member#member GoogleOrganizationIamMember#member}
    */
    readonly member: string;
    /**
    * The numeric ID of the organization in which you want to manage the audit logging config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member#org_id GoogleOrganizationIamMember#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member#role GoogleOrganizationIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member#condition GoogleOrganizationIamMember#condition}
    */
    readonly condition?: GoogleOrganizationIamMemberCondition;
}
export interface GoogleOrganizationIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member#description GoogleOrganizationIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member#expression GoogleOrganizationIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member#title GoogleOrganizationIamMember#title}
    */
    readonly title: string;
}
export declare function googleOrganizationIamMemberConditionToTerraform(struct?: GoogleOrganizationIamMemberConditionOutputReference | GoogleOrganizationIamMemberCondition): any;
export declare class GoogleOrganizationIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOrganizationIamMemberCondition | undefined;
    set internalValue(value: GoogleOrganizationIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member google_organization_iam_member}
*/
export declare class GoogleOrganizationIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_organization_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_organization_iam_member google_organization_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleOrganizationIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleOrganizationIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleOrganizationIamMemberConditionOutputReference;
    putCondition(value: GoogleOrganizationIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleOrganizationIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
