import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleOsConfigGuestPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the guest policy. Length of the description is limited to 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#description GoogleOsConfigGuestPolicies#description}
    */
    readonly description?: string;
    /**
    * The etag for this guest policy. If this is provided on update, it must match the server's etag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#etag GoogleOsConfigGuestPolicies#etag}
    */
    readonly etag?: string;
    /**
    * The logical name of the guest policy in the project with the following restrictions:
  * Must contain only lowercase letters, numbers, and hyphens.
  * Must start with a letter.
  * Must be between 1-63 characters.
  * Must end with a number or a letter.
  * Must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#guest_policy_id GoogleOsConfigGuestPolicies#guest_policy_id}
    */
    readonly guestPolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#id GoogleOsConfigGuestPolicies#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#project GoogleOsConfigGuestPolicies#project}
    */
    readonly project?: string;
    /**
    * assignment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#assignment GoogleOsConfigGuestPolicies#assignment}
    */
    readonly assignment: GoogleOsConfigGuestPoliciesAssignment;
    /**
    * package_repositories block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#package_repositories GoogleOsConfigGuestPolicies#package_repositories}
    */
    readonly packageRepositories?: GoogleOsConfigGuestPoliciesPackageRepositories[] | cdktf.IResolvable;
    /**
    * packages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#packages GoogleOsConfigGuestPolicies#packages}
    */
    readonly packages?: GoogleOsConfigGuestPoliciesPackages[] | cdktf.IResolvable;
    /**
    * recipes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#recipes GoogleOsConfigGuestPolicies#recipes}
    */
    readonly recipes?: GoogleOsConfigGuestPoliciesRecipes[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#timeouts GoogleOsConfigGuestPolicies#timeouts}
    */
    readonly timeouts?: GoogleOsConfigGuestPoliciesTimeouts;
}
export interface GoogleOsConfigGuestPoliciesAssignmentGroupLabels {
    /**
    * Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#labels GoogleOsConfigGuestPolicies#labels}
    */
    readonly labels: {
        [key: string]: string;
    };
}
export declare function googleOsConfigGuestPoliciesAssignmentGroupLabelsToTerraform(struct?: GoogleOsConfigGuestPoliciesAssignmentGroupLabels | cdktf.IResolvable): any;
export declare class GoogleOsConfigGuestPoliciesAssignmentGroupLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOsConfigGuestPoliciesAssignmentGroupLabels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesAssignmentGroupLabels | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class GoogleOsConfigGuestPoliciesAssignmentGroupLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOsConfigGuestPoliciesAssignmentGroupLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOsConfigGuestPoliciesAssignmentGroupLabelsOutputReference;
}
export interface GoogleOsConfigGuestPoliciesAssignmentOsTypes {
    /**
    * Targets VM instances with OS Inventory enabled and having the following OS architecture.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#os_architecture GoogleOsConfigGuestPolicies#os_architecture}
    */
    readonly osArchitecture?: string;
    /**
    * Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#os_short_name GoogleOsConfigGuestPolicies#os_short_name}
    */
    readonly osShortName?: string;
    /**
    * Targets VM instances with OS Inventory enabled and having the following following OS version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#os_version GoogleOsConfigGuestPolicies#os_version}
    */
    readonly osVersion?: string;
}
export declare function googleOsConfigGuestPoliciesAssignmentOsTypesToTerraform(struct?: GoogleOsConfigGuestPoliciesAssignmentOsTypes | cdktf.IResolvable): any;
export declare class GoogleOsConfigGuestPoliciesAssignmentOsTypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOsConfigGuestPoliciesAssignmentOsTypes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesAssignmentOsTypes | cdktf.IResolvable | undefined);
    private _osArchitecture?;
    get osArchitecture(): string;
    set osArchitecture(value: string);
    resetOsArchitecture(): void;
    get osArchitectureInput(): string | undefined;
    private _osShortName?;
    get osShortName(): string;
    set osShortName(value: string);
    resetOsShortName(): void;
    get osShortNameInput(): string | undefined;
    private _osVersion?;
    get osVersion(): string;
    set osVersion(value: string);
    resetOsVersion(): void;
    get osVersionInput(): string | undefined;
}
export declare class GoogleOsConfigGuestPoliciesAssignmentOsTypesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOsConfigGuestPoliciesAssignmentOsTypes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOsConfigGuestPoliciesAssignmentOsTypesOutputReference;
}
export interface GoogleOsConfigGuestPoliciesAssignment {
    /**
    * Targets VM instances whose name starts with one of these prefixes.
  Like labels, this is another way to group VM instances when targeting configs,
  for example prefix="prod-".
  Only supported for project-level policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#instance_name_prefixes GoogleOsConfigGuestPolicies#instance_name_prefixes}
    */
    readonly instanceNamePrefixes?: string[];
    /**
    * Targets any of the instances specified. Instances are specified by their URI in the form
  zones/[ZONE]/instances/[INSTANCE_NAME].
  Instance targeting is uncommon and is supported to facilitate the management of changes
  by the instance or to target specific VM instances for development and testing.
  Only supported for project-level policies and must reference instances within this project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#instances GoogleOsConfigGuestPolicies#instances}
    */
    readonly instances?: string[];
    /**
    * Targets instances in any of these zones. Leave empty to target instances in any zone.
  Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#zones GoogleOsConfigGuestPolicies#zones}
    */
    readonly zones?: string[];
    /**
    * group_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#group_labels GoogleOsConfigGuestPolicies#group_labels}
    */
    readonly groupLabels?: GoogleOsConfigGuestPoliciesAssignmentGroupLabels[] | cdktf.IResolvable;
    /**
    * os_types block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#os_types GoogleOsConfigGuestPolicies#os_types}
    */
    readonly osTypes?: GoogleOsConfigGuestPoliciesAssignmentOsTypes[] | cdktf.IResolvable;
}
export declare function googleOsConfigGuestPoliciesAssignmentToTerraform(struct?: GoogleOsConfigGuestPoliciesAssignmentOutputReference | GoogleOsConfigGuestPoliciesAssignment): any;
export declare class GoogleOsConfigGuestPoliciesAssignmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesAssignment | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesAssignment | undefined);
    private _instanceNamePrefixes?;
    get instanceNamePrefixes(): string[];
    set instanceNamePrefixes(value: string[]);
    resetInstanceNamePrefixes(): void;
    get instanceNamePrefixesInput(): string[] | undefined;
    private _instances?;
    get instances(): string[];
    set instances(value: string[]);
    resetInstances(): void;
    get instancesInput(): string[] | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _groupLabels;
    get groupLabels(): GoogleOsConfigGuestPoliciesAssignmentGroupLabelsList;
    putGroupLabels(value: GoogleOsConfigGuestPoliciesAssignmentGroupLabels[] | cdktf.IResolvable): void;
    resetGroupLabels(): void;
    get groupLabelsInput(): cdktf.IResolvable | GoogleOsConfigGuestPoliciesAssignmentGroupLabels[] | undefined;
    private _osTypes;
    get osTypes(): GoogleOsConfigGuestPoliciesAssignmentOsTypesList;
    putOsTypes(value: GoogleOsConfigGuestPoliciesAssignmentOsTypes[] | cdktf.IResolvable): void;
    resetOsTypes(): void;
    get osTypesInput(): cdktf.IResolvable | GoogleOsConfigGuestPoliciesAssignmentOsTypes[] | undefined;
}
export interface GoogleOsConfigGuestPoliciesPackageRepositoriesApt {
    /**
    * Type of archive files in this repository. The default behavior is DEB. Default value: "DEB" Possible values: ["DEB", "DEB_SRC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#archive_type GoogleOsConfigGuestPolicies#archive_type}
    */
    readonly archiveType?: string;
    /**
    * List of components for this repository. Must contain at least one item.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#components GoogleOsConfigGuestPolicies#components}
    */
    readonly components: string[];
    /**
    * Distribution of this repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#distribution GoogleOsConfigGuestPolicies#distribution}
    */
    readonly distribution: string;
    /**
    * URI of the key file for this repository. The agent maintains a keyring at
  /etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg containing all the keys in any applied guest policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#gpg_key GoogleOsConfigGuestPolicies#gpg_key}
    */
    readonly gpgKey?: string;
    /**
    * URI for this repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#uri GoogleOsConfigGuestPolicies#uri}
    */
    readonly uri: string;
}
export declare function googleOsConfigGuestPoliciesPackageRepositoriesAptToTerraform(struct?: GoogleOsConfigGuestPoliciesPackageRepositoriesAptOutputReference | GoogleOsConfigGuestPoliciesPackageRepositoriesApt): any;
export declare class GoogleOsConfigGuestPoliciesPackageRepositoriesAptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesPackageRepositoriesApt | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesPackageRepositoriesApt | undefined);
    private _archiveType?;
    get archiveType(): string;
    set archiveType(value: string);
    resetArchiveType(): void;
    get archiveTypeInput(): string | undefined;
    private _components?;
    get components(): string[];
    set components(value: string[]);
    get componentsInput(): string[] | undefined;
    private _distribution?;
    get distribution(): string;
    set distribution(value: string);
    get distributionInput(): string | undefined;
    private _gpgKey?;
    get gpgKey(): string;
    set gpgKey(value: string);
    resetGpgKey(): void;
    get gpgKeyInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesPackageRepositoriesGoo {
    /**
    * The name of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#name GoogleOsConfigGuestPolicies#name}
    */
    readonly name: string;
    /**
    * The url of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#url GoogleOsConfigGuestPolicies#url}
    */
    readonly url: string;
}
export declare function googleOsConfigGuestPoliciesPackageRepositoriesGooToTerraform(struct?: GoogleOsConfigGuestPoliciesPackageRepositoriesGooOutputReference | GoogleOsConfigGuestPoliciesPackageRepositoriesGoo): any;
export declare class GoogleOsConfigGuestPoliciesPackageRepositoriesGooOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesPackageRepositoriesGoo | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesPackageRepositoriesGoo | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesPackageRepositoriesYum {
    /**
    * The location of the repository directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#base_url GoogleOsConfigGuestPolicies#base_url}
    */
    readonly baseUrl: string;
    /**
    * The display name of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#display_name GoogleOsConfigGuestPolicies#display_name}
    */
    readonly displayName?: string;
    /**
    * URIs of GPG keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#gpg_keys GoogleOsConfigGuestPolicies#gpg_keys}
    */
    readonly gpgKeys?: string[];
    /**
    * A one word, unique name for this repository. This is the repo id in the Yum config file and also the displayName
  if displayName is omitted. This id is also used as the unique identifier when checking for guest policy conflicts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#id GoogleOsConfigGuestPolicies#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function googleOsConfigGuestPoliciesPackageRepositoriesYumToTerraform(struct?: GoogleOsConfigGuestPoliciesPackageRepositoriesYumOutputReference | GoogleOsConfigGuestPoliciesPackageRepositoriesYum): any;
export declare class GoogleOsConfigGuestPoliciesPackageRepositoriesYumOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesPackageRepositoriesYum | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesPackageRepositoriesYum | undefined);
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    get baseUrlInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _gpgKeys?;
    get gpgKeys(): string[];
    set gpgKeys(value: string[]);
    resetGpgKeys(): void;
    get gpgKeysInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesPackageRepositoriesZypper {
    /**
    * The location of the repository directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#base_url GoogleOsConfigGuestPolicies#base_url}
    */
    readonly baseUrl: string;
    /**
    * The display name of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#display_name GoogleOsConfigGuestPolicies#display_name}
    */
    readonly displayName?: string;
    /**
    * URIs of GPG keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#gpg_keys GoogleOsConfigGuestPolicies#gpg_keys}
    */
    readonly gpgKeys?: string[];
    /**
    * A one word, unique name for this repository. This is the repo id in the zypper config file and also the displayName
  if displayName is omitted. This id is also used as the unique identifier when checking for guest policy conflicts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#id GoogleOsConfigGuestPolicies#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function googleOsConfigGuestPoliciesPackageRepositoriesZypperToTerraform(struct?: GoogleOsConfigGuestPoliciesPackageRepositoriesZypperOutputReference | GoogleOsConfigGuestPoliciesPackageRepositoriesZypper): any;
export declare class GoogleOsConfigGuestPoliciesPackageRepositoriesZypperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesPackageRepositoriesZypper | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesPackageRepositoriesZypper | undefined);
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    get baseUrlInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _gpgKeys?;
    get gpgKeys(): string[];
    set gpgKeys(value: string[]);
    resetGpgKeys(): void;
    get gpgKeysInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesPackageRepositories {
    /**
    * apt block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#apt GoogleOsConfigGuestPolicies#apt}
    */
    readonly apt?: GoogleOsConfigGuestPoliciesPackageRepositoriesApt;
    /**
    * goo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#goo GoogleOsConfigGuestPolicies#goo}
    */
    readonly goo?: GoogleOsConfigGuestPoliciesPackageRepositoriesGoo;
    /**
    * yum block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#yum GoogleOsConfigGuestPolicies#yum}
    */
    readonly yum?: GoogleOsConfigGuestPoliciesPackageRepositoriesYum;
    /**
    * zypper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#zypper GoogleOsConfigGuestPolicies#zypper}
    */
    readonly zypper?: GoogleOsConfigGuestPoliciesPackageRepositoriesZypper;
}
export declare function googleOsConfigGuestPoliciesPackageRepositoriesToTerraform(struct?: GoogleOsConfigGuestPoliciesPackageRepositories | cdktf.IResolvable): any;
export declare class GoogleOsConfigGuestPoliciesPackageRepositoriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOsConfigGuestPoliciesPackageRepositories | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesPackageRepositories | cdktf.IResolvable | undefined);
    private _apt;
    get apt(): GoogleOsConfigGuestPoliciesPackageRepositoriesAptOutputReference;
    putApt(value: GoogleOsConfigGuestPoliciesPackageRepositoriesApt): void;
    resetApt(): void;
    get aptInput(): GoogleOsConfigGuestPoliciesPackageRepositoriesApt | undefined;
    private _goo;
    get goo(): GoogleOsConfigGuestPoliciesPackageRepositoriesGooOutputReference;
    putGoo(value: GoogleOsConfigGuestPoliciesPackageRepositoriesGoo): void;
    resetGoo(): void;
    get gooInput(): GoogleOsConfigGuestPoliciesPackageRepositoriesGoo | undefined;
    private _yum;
    get yum(): GoogleOsConfigGuestPoliciesPackageRepositoriesYumOutputReference;
    putYum(value: GoogleOsConfigGuestPoliciesPackageRepositoriesYum): void;
    resetYum(): void;
    get yumInput(): GoogleOsConfigGuestPoliciesPackageRepositoriesYum | undefined;
    private _zypper;
    get zypper(): GoogleOsConfigGuestPoliciesPackageRepositoriesZypperOutputReference;
    putZypper(value: GoogleOsConfigGuestPoliciesPackageRepositoriesZypper): void;
    resetZypper(): void;
    get zypperInput(): GoogleOsConfigGuestPoliciesPackageRepositoriesZypper | undefined;
}
export declare class GoogleOsConfigGuestPoliciesPackageRepositoriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOsConfigGuestPoliciesPackageRepositories[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOsConfigGuestPoliciesPackageRepositoriesOutputReference;
}
export interface GoogleOsConfigGuestPoliciesPackages {
    /**
    * The desiredState the agent should maintain for this package. The default is to ensure the package is installed. Possible values: ["INSTALLED", "UPDATED", "REMOVED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#desired_state GoogleOsConfigGuestPolicies#desired_state}
    */
    readonly desiredState?: string;
    /**
    * Type of package manager that can be used to install this package. If a system does not have the package manager,
  the package is not installed or removed no error message is returned. By default, or if you specify ANY,
  the agent attempts to install and remove this package using the default package manager.
  This is useful when creating a policy that applies to different types of systems.
  The default behavior is ANY. Default value: "ANY" Possible values: ["ANY", "APT", "YUM", "ZYPPER", "GOO"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#manager GoogleOsConfigGuestPolicies#manager}
    */
    readonly manager?: string;
    /**
    * The name of the package. A package is uniquely identified for conflict validation
  by checking the package name and the manager(s) that the package targets.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#name GoogleOsConfigGuestPolicies#name}
    */
    readonly name: string;
}
export declare function googleOsConfigGuestPoliciesPackagesToTerraform(struct?: GoogleOsConfigGuestPoliciesPackages | cdktf.IResolvable): any;
export declare class GoogleOsConfigGuestPoliciesPackagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOsConfigGuestPoliciesPackages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesPackages | cdktf.IResolvable | undefined);
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    resetDesiredState(): void;
    get desiredStateInput(): string | undefined;
    private _manager?;
    get manager(): string;
    set manager(value: string);
    resetManager(): void;
    get managerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class GoogleOsConfigGuestPoliciesPackagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOsConfigGuestPoliciesPackages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOsConfigGuestPoliciesPackagesOutputReference;
}
export interface GoogleOsConfigGuestPoliciesRecipesArtifactsGcs {
    /**
    * Bucket of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
  this value would be my-bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#bucket GoogleOsConfigGuestPolicies#bucket}
    */
    readonly bucket?: string;
    /**
    * Must be provided if allowInsecure is false. Generation number of the Google Cloud Storage object.
  https://storage.googleapis.com/my-bucket/foo/bar#1234567 this value would be 1234567.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#generation GoogleOsConfigGuestPolicies#generation}
    */
    readonly generation?: number;
    /**
    * Name of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
  this value would be foo/bar.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#object GoogleOsConfigGuestPolicies#object}
    */
    readonly object?: string;
}
export declare function googleOsConfigGuestPoliciesRecipesArtifactsGcsToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesArtifactsGcsOutputReference | GoogleOsConfigGuestPoliciesRecipesArtifactsGcs): any;
export declare class GoogleOsConfigGuestPoliciesRecipesArtifactsGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesArtifactsGcs | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesArtifactsGcs | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    resetBucket(): void;
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): number;
    set generation(value: number);
    resetGeneration(): void;
    get generationInput(): number | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    resetObject(): void;
    get objectInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesArtifactsRemote {
    /**
    * Must be provided if allowInsecure is false. SHA256 checksum in hex format, to compare to the checksum of the artifact.
  If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any
  of the steps.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#check_sum GoogleOsConfigGuestPolicies#check_sum}
    */
    readonly checkSum?: string;
    /**
    * URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#uri GoogleOsConfigGuestPolicies#uri}
    */
    readonly uri?: string;
}
export declare function googleOsConfigGuestPoliciesRecipesArtifactsRemoteToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesArtifactsRemoteOutputReference | GoogleOsConfigGuestPoliciesRecipesArtifactsRemote): any;
export declare class GoogleOsConfigGuestPoliciesRecipesArtifactsRemoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesArtifactsRemote | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesArtifactsRemote | undefined);
    private _checkSum?;
    get checkSum(): string;
    set checkSum(value: string);
    resetCheckSum(): void;
    get checkSumInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    resetUri(): void;
    get uriInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesArtifacts {
    /**
    * Defaults to false. When false, recipes are subject to validations based on the artifact type:
  Remote: A checksum must be specified, and only protocols with transport-layer security are permitted.
  GCS: An object generation number must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#allow_insecure GoogleOsConfigGuestPolicies#allow_insecure}
    */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
    * Id of the artifact, which the installation and update steps of this recipe can reference.
  Artifacts in a recipe cannot have the same id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#id GoogleOsConfigGuestPolicies#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#gcs GoogleOsConfigGuestPolicies#gcs}
    */
    readonly gcs?: GoogleOsConfigGuestPoliciesRecipesArtifactsGcs;
    /**
    * remote block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#remote GoogleOsConfigGuestPolicies#remote}
    */
    readonly remote?: GoogleOsConfigGuestPoliciesRecipesArtifactsRemote;
}
export declare function googleOsConfigGuestPoliciesRecipesArtifactsToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesArtifacts | cdktf.IResolvable): any;
export declare class GoogleOsConfigGuestPoliciesRecipesArtifactsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesArtifacts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesArtifacts | cdktf.IResolvable | undefined);
    private _allowInsecure?;
    get allowInsecure(): boolean | cdktf.IResolvable;
    set allowInsecure(value: boolean | cdktf.IResolvable);
    resetAllowInsecure(): void;
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _gcs;
    get gcs(): GoogleOsConfigGuestPoliciesRecipesArtifactsGcsOutputReference;
    putGcs(value: GoogleOsConfigGuestPoliciesRecipesArtifactsGcs): void;
    resetGcs(): void;
    get gcsInput(): GoogleOsConfigGuestPoliciesRecipesArtifactsGcs | undefined;
    private _remote;
    get remote(): GoogleOsConfigGuestPoliciesRecipesArtifactsRemoteOutputReference;
    putRemote(value: GoogleOsConfigGuestPoliciesRecipesArtifactsRemote): void;
    resetRemote(): void;
    get remoteInput(): GoogleOsConfigGuestPoliciesRecipesArtifactsRemote | undefined;
}
export declare class GoogleOsConfigGuestPoliciesRecipesArtifactsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOsConfigGuestPoliciesRecipesArtifacts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOsConfigGuestPoliciesRecipesArtifactsOutputReference;
}
export interface GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtraction {
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
    /**
    * Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#destination GoogleOsConfigGuestPolicies#destination}
    */
    readonly destination?: string;
    /**
    * The type of the archive to extract. Possible values: ["TAR", "TAR_GZIP", "TAR_BZIP", "TAR_LZMA", "TAR_XZ", "ZIP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#type GoogleOsConfigGuestPolicies#type}
    */
    readonly type: string;
}
export declare function googleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtractionToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtractionOutputReference | GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtraction): any;
export declare class GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtractionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtraction | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtraction | undefined);
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallation {
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
}
export declare function googleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallationToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallationOutputReference | GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallation): any;
export declare class GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallation | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallation | undefined);
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopy {
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
    /**
    * The absolute path on the instance to put the file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#destination GoogleOsConfigGuestPolicies#destination}
    */
    readonly destination: string;
    /**
    * Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
  is not overwritten and the step is considered a success. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#overwrite GoogleOsConfigGuestPolicies#overwrite}
    */
    readonly overwrite?: boolean | cdktf.IResolvable;
    /**
    * Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
  for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
  number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
  bit corresponds to the execute permission. Default behavior is 755.
  
  Below are some examples of permissions and their associated values:
  read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#permissions GoogleOsConfigGuestPolicies#permissions}
    */
    readonly permissions?: string;
}
export declare function googleOsConfigGuestPoliciesRecipesInstallStepsFileCopyToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopyOutputReference | GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopy): any;
export declare class GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopy | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopy | undefined);
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _overwrite?;
    get overwrite(): boolean | cdktf.IResolvable;
    set overwrite(value: boolean | cdktf.IResolvable);
    resetOverwrite(): void;
    get overwriteInput(): boolean | cdktf.IResolvable | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExec {
    /**
    * A list of possible return values that the program can return to indicate a success. Defaults to [0].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#allowed_exit_codes GoogleOsConfigGuestPolicies#allowed_exit_codes}
    */
    readonly allowedExitCodes?: string;
    /**
    * Arguments to be passed to the provided executable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#args GoogleOsConfigGuestPolicies#args}
    */
    readonly args?: string[];
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId?: string;
    /**
    * The absolute path of the file on the local filesystem.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#local_path GoogleOsConfigGuestPolicies#local_path}
    */
    readonly localPath?: string;
}
export declare function googleOsConfigGuestPoliciesRecipesInstallStepsFileExecToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExecOutputReference | GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExec): any;
export declare class GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExec | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExec | undefined);
    private _allowedExitCodes?;
    get allowedExitCodes(): string;
    set allowedExitCodes(value: string);
    resetAllowedExitCodes(): void;
    get allowedExitCodesInput(): string | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    resetArtifactId(): void;
    get artifactIdInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallation {
    /**
    * Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#allowed_exit_codes GoogleOsConfigGuestPolicies#allowed_exit_codes}
    */
    readonly allowedExitCodes?: number[];
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
    /**
    * The flags to use when installing the MSI. Defaults to the install flag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#flags GoogleOsConfigGuestPolicies#flags}
    */
    readonly flags?: string[];
}
export declare function googleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallationToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallationOutputReference | GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallation): any;
export declare class GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallation | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallation | undefined);
    private _allowedExitCodes?;
    get allowedExitCodes(): number[];
    set allowedExitCodes(value: number[]);
    resetAllowedExitCodes(): void;
    get allowedExitCodesInput(): number[] | undefined;
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
    private _flags?;
    get flags(): string[];
    set flags(value: string[]);
    resetFlags(): void;
    get flagsInput(): string[] | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallation {
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
}
export declare function googleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallationToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallationOutputReference | GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallation): any;
export declare class GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallation | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallation | undefined);
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRun {
    /**
    * Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#allowed_exit_codes GoogleOsConfigGuestPolicies#allowed_exit_codes}
    */
    readonly allowedExitCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
  which likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#interpreter GoogleOsConfigGuestPolicies#interpreter}
    */
    readonly interpreter?: string;
    /**
    * The shell script to be executed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#script GoogleOsConfigGuestPolicies#script}
    */
    readonly script: string;
}
export declare function googleOsConfigGuestPoliciesRecipesInstallStepsScriptRunToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRunOutputReference | GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRun): any;
export declare class GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRunOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRun | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRun | undefined);
    private _allowedExitCodes?;
    get allowedExitCodes(): number[];
    set allowedExitCodes(value: number[]);
    resetAllowedExitCodes(): void;
    get allowedExitCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    get scriptInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesInstallSteps {
    /**
    * archive_extraction block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#archive_extraction GoogleOsConfigGuestPolicies#archive_extraction}
    */
    readonly archiveExtraction?: GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtraction;
    /**
    * dpkg_installation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#dpkg_installation GoogleOsConfigGuestPolicies#dpkg_installation}
    */
    readonly dpkgInstallation?: GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallation;
    /**
    * file_copy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#file_copy GoogleOsConfigGuestPolicies#file_copy}
    */
    readonly fileCopy?: GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopy;
    /**
    * file_exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#file_exec GoogleOsConfigGuestPolicies#file_exec}
    */
    readonly fileExec?: GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExec;
    /**
    * msi_installation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#msi_installation GoogleOsConfigGuestPolicies#msi_installation}
    */
    readonly msiInstallation?: GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallation;
    /**
    * rpm_installation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#rpm_installation GoogleOsConfigGuestPolicies#rpm_installation}
    */
    readonly rpmInstallation?: GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallation;
    /**
    * script_run block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#script_run GoogleOsConfigGuestPolicies#script_run}
    */
    readonly scriptRun?: GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRun;
}
export declare function googleOsConfigGuestPoliciesRecipesInstallStepsToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesInstallSteps | cdktf.IResolvable): any;
export declare class GoogleOsConfigGuestPoliciesRecipesInstallStepsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesInstallSteps | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesInstallSteps | cdktf.IResolvable | undefined);
    private _archiveExtraction;
    get archiveExtraction(): GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtractionOutputReference;
    putArchiveExtraction(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtraction): void;
    resetArchiveExtraction(): void;
    get archiveExtractionInput(): GoogleOsConfigGuestPoliciesRecipesInstallStepsArchiveExtraction | undefined;
    private _dpkgInstallation;
    get dpkgInstallation(): GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallationOutputReference;
    putDpkgInstallation(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallation): void;
    resetDpkgInstallation(): void;
    get dpkgInstallationInput(): GoogleOsConfigGuestPoliciesRecipesInstallStepsDpkgInstallation | undefined;
    private _fileCopy;
    get fileCopy(): GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopyOutputReference;
    putFileCopy(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopy): void;
    resetFileCopy(): void;
    get fileCopyInput(): GoogleOsConfigGuestPoliciesRecipesInstallStepsFileCopy | undefined;
    private _fileExec;
    get fileExec(): GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExecOutputReference;
    putFileExec(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExec): void;
    resetFileExec(): void;
    get fileExecInput(): GoogleOsConfigGuestPoliciesRecipesInstallStepsFileExec | undefined;
    private _msiInstallation;
    get msiInstallation(): GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallationOutputReference;
    putMsiInstallation(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallation): void;
    resetMsiInstallation(): void;
    get msiInstallationInput(): GoogleOsConfigGuestPoliciesRecipesInstallStepsMsiInstallation | undefined;
    private _rpmInstallation;
    get rpmInstallation(): GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallationOutputReference;
    putRpmInstallation(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallation): void;
    resetRpmInstallation(): void;
    get rpmInstallationInput(): GoogleOsConfigGuestPoliciesRecipesInstallStepsRpmInstallation | undefined;
    private _scriptRun;
    get scriptRun(): GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRunOutputReference;
    putScriptRun(value: GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRun): void;
    resetScriptRun(): void;
    get scriptRunInput(): GoogleOsConfigGuestPoliciesRecipesInstallStepsScriptRun | undefined;
}
export declare class GoogleOsConfigGuestPoliciesRecipesInstallStepsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOsConfigGuestPoliciesRecipesInstallSteps[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOsConfigGuestPoliciesRecipesInstallStepsOutputReference;
}
export interface GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction {
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
    /**
    * Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#destination GoogleOsConfigGuestPolicies#destination}
    */
    readonly destination?: string;
    /**
    * The type of the archive to extract. Possible values: ["TAR", "TAR_GZIP", "TAR_BZIP", "TAR_LZMA", "TAR_XZ", "ZIP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#type GoogleOsConfigGuestPolicies#type}
    */
    readonly type: string;
}
export declare function googleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionOutputReference | GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction): any;
export declare class GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction | undefined);
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation {
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
}
export declare function googleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallationToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallationOutputReference | GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation): any;
export declare class GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation | undefined);
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopy {
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
    /**
    * The absolute path on the instance to put the file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#destination GoogleOsConfigGuestPolicies#destination}
    */
    readonly destination: string;
    /**
    * Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
  is not overwritten and the step is considered a success. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#overwrite GoogleOsConfigGuestPolicies#overwrite}
    */
    readonly overwrite?: boolean | cdktf.IResolvable;
    /**
    * Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
  for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
  number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
  bit corresponds to the execute permission. Default behavior is 755.
  
  Below are some examples of permissions and their associated values:
  read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#permissions GoogleOsConfigGuestPolicies#permissions}
    */
    readonly permissions?: string;
}
export declare function googleOsConfigGuestPoliciesRecipesUpdateStepsFileCopyToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopyOutputReference | GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopy): any;
export declare class GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopy | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopy | undefined);
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _overwrite?;
    get overwrite(): boolean | cdktf.IResolvable;
    set overwrite(value: boolean | cdktf.IResolvable);
    resetOverwrite(): void;
    get overwriteInput(): boolean | cdktf.IResolvable | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExec {
    /**
    * A list of possible return values that the program can return to indicate a success. Defaults to [0].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#allowed_exit_codes GoogleOsConfigGuestPolicies#allowed_exit_codes}
    */
    readonly allowedExitCodes?: number[];
    /**
    * Arguments to be passed to the provided executable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#args GoogleOsConfigGuestPolicies#args}
    */
    readonly args?: string[];
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId?: string;
    /**
    * The absolute path of the file on the local filesystem.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#local_path GoogleOsConfigGuestPolicies#local_path}
    */
    readonly localPath?: string;
}
export declare function googleOsConfigGuestPoliciesRecipesUpdateStepsFileExecToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExecOutputReference | GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExec): any;
export declare class GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExec | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExec | undefined);
    private _allowedExitCodes?;
    get allowedExitCodes(): number[];
    set allowedExitCodes(value: number[]);
    resetAllowedExitCodes(): void;
    get allowedExitCodesInput(): number[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    resetArtifactId(): void;
    get artifactIdInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallation {
    /**
    * Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#allowed_exit_codes GoogleOsConfigGuestPolicies#allowed_exit_codes}
    */
    readonly allowedExitCodes?: number[];
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
    /**
    * The flags to use when installing the MSI. Defaults to the install flag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#flags GoogleOsConfigGuestPolicies#flags}
    */
    readonly flags?: string[];
}
export declare function googleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallationToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallationOutputReference | GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallation): any;
export declare class GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallation | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallation | undefined);
    private _allowedExitCodes?;
    get allowedExitCodes(): number[];
    set allowedExitCodes(value: number[]);
    resetAllowedExitCodes(): void;
    get allowedExitCodesInput(): number[] | undefined;
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
    private _flags?;
    get flags(): string[];
    set flags(value: string[]);
    resetFlags(): void;
    get flagsInput(): string[] | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallation {
    /**
    * The id of the relevant artifact in the recipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifact_id GoogleOsConfigGuestPolicies#artifact_id}
    */
    readonly artifactId: string;
}
export declare function googleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallationToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallationOutputReference | GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallation): any;
export declare class GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallation | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallation | undefined);
    private _artifactId?;
    get artifactId(): string;
    set artifactId(value: string);
    get artifactIdInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRun {
    /**
    * Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#allowed_exit_codes GoogleOsConfigGuestPolicies#allowed_exit_codes}
    */
    readonly allowedExitCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
  which likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#interpreter GoogleOsConfigGuestPolicies#interpreter}
    */
    readonly interpreter?: string;
    /**
    * The shell script to be executed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#script GoogleOsConfigGuestPolicies#script}
    */
    readonly script: string;
}
export declare function googleOsConfigGuestPoliciesRecipesUpdateStepsScriptRunToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRunOutputReference | GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRun): any;
export declare class GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRunOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRun | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRun | undefined);
    private _allowedExitCodes?;
    get allowedExitCodes(): number[];
    set allowedExitCodes(value: number[]);
    resetAllowedExitCodes(): void;
    get allowedExitCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    get scriptInput(): string | undefined;
}
export interface GoogleOsConfigGuestPoliciesRecipesUpdateSteps {
    /**
    * archive_extraction block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#archive_extraction GoogleOsConfigGuestPolicies#archive_extraction}
    */
    readonly archiveExtraction?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction;
    /**
    * dpkg_installation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#dpkg_installation GoogleOsConfigGuestPolicies#dpkg_installation}
    */
    readonly dpkgInstallation?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation;
    /**
    * file_copy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#file_copy GoogleOsConfigGuestPolicies#file_copy}
    */
    readonly fileCopy?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopy;
    /**
    * file_exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#file_exec GoogleOsConfigGuestPolicies#file_exec}
    */
    readonly fileExec?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExec;
    /**
    * msi_installation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#msi_installation GoogleOsConfigGuestPolicies#msi_installation}
    */
    readonly msiInstallation?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallation;
    /**
    * rpm_installation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#rpm_installation GoogleOsConfigGuestPolicies#rpm_installation}
    */
    readonly rpmInstallation?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallation;
    /**
    * script_run block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#script_run GoogleOsConfigGuestPolicies#script_run}
    */
    readonly scriptRun?: GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRun;
}
export declare function googleOsConfigGuestPoliciesRecipesUpdateStepsToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipesUpdateSteps | cdktf.IResolvable): any;
export declare class GoogleOsConfigGuestPoliciesRecipesUpdateStepsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipesUpdateSteps | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipesUpdateSteps | cdktf.IResolvable | undefined);
    private _archiveExtraction;
    get archiveExtraction(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionOutputReference;
    putArchiveExtraction(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction): void;
    resetArchiveExtraction(): void;
    get archiveExtractionInput(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction | undefined;
    private _dpkgInstallation;
    get dpkgInstallation(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallationOutputReference;
    putDpkgInstallation(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation): void;
    resetDpkgInstallation(): void;
    get dpkgInstallationInput(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation | undefined;
    private _fileCopy;
    get fileCopy(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopyOutputReference;
    putFileCopy(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopy): void;
    resetFileCopy(): void;
    get fileCopyInput(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileCopy | undefined;
    private _fileExec;
    get fileExec(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExecOutputReference;
    putFileExec(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExec): void;
    resetFileExec(): void;
    get fileExecInput(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsFileExec | undefined;
    private _msiInstallation;
    get msiInstallation(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallationOutputReference;
    putMsiInstallation(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallation): void;
    resetMsiInstallation(): void;
    get msiInstallationInput(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsMsiInstallation | undefined;
    private _rpmInstallation;
    get rpmInstallation(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallationOutputReference;
    putRpmInstallation(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallation): void;
    resetRpmInstallation(): void;
    get rpmInstallationInput(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsRpmInstallation | undefined;
    private _scriptRun;
    get scriptRun(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRunOutputReference;
    putScriptRun(value: GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRun): void;
    resetScriptRun(): void;
    get scriptRunInput(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsScriptRun | undefined;
}
export declare class GoogleOsConfigGuestPoliciesRecipesUpdateStepsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOsConfigGuestPoliciesRecipesUpdateSteps[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOsConfigGuestPoliciesRecipesUpdateStepsOutputReference;
}
export interface GoogleOsConfigGuestPoliciesRecipes {
    /**
    * Default is INSTALLED. The desired state the agent should maintain for this recipe.
  
  INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
  INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
  if a higher version of the recipe is assigned to this instance.
  REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected. Default value: "INSTALLED" Possible values: ["INSTALLED", "UPDATED", "REMOVED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#desired_state GoogleOsConfigGuestPolicies#desired_state}
    */
    readonly desiredState?: string;
    /**
    * Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
  Names are also used to identify resources which helps to determine whether guest policies have conflicts.
  This means that requests to create multiple recipes with the same name and version are rejected since they
  could potentially have conflicting assignments.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#name GoogleOsConfigGuestPolicies#name}
    */
    readonly name: string;
    /**
    * The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#version GoogleOsConfigGuestPolicies#version}
    */
    readonly version?: string;
    /**
    * artifacts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#artifacts GoogleOsConfigGuestPolicies#artifacts}
    */
    readonly artifacts?: GoogleOsConfigGuestPoliciesRecipesArtifacts[] | cdktf.IResolvable;
    /**
    * install_steps block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#install_steps GoogleOsConfigGuestPolicies#install_steps}
    */
    readonly installSteps?: GoogleOsConfigGuestPoliciesRecipesInstallSteps[] | cdktf.IResolvable;
    /**
    * update_steps block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#update_steps GoogleOsConfigGuestPolicies#update_steps}
    */
    readonly updateSteps?: GoogleOsConfigGuestPoliciesRecipesUpdateSteps[] | cdktf.IResolvable;
}
export declare function googleOsConfigGuestPoliciesRecipesToTerraform(struct?: GoogleOsConfigGuestPoliciesRecipes | cdktf.IResolvable): any;
export declare class GoogleOsConfigGuestPoliciesRecipesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleOsConfigGuestPoliciesRecipes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesRecipes | cdktf.IResolvable | undefined);
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    resetDesiredState(): void;
    get desiredStateInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _artifacts;
    get artifacts(): GoogleOsConfigGuestPoliciesRecipesArtifactsList;
    putArtifacts(value: GoogleOsConfigGuestPoliciesRecipesArtifacts[] | cdktf.IResolvable): void;
    resetArtifacts(): void;
    get artifactsInput(): cdktf.IResolvable | GoogleOsConfigGuestPoliciesRecipesArtifacts[] | undefined;
    private _installSteps;
    get installSteps(): GoogleOsConfigGuestPoliciesRecipesInstallStepsList;
    putInstallSteps(value: GoogleOsConfigGuestPoliciesRecipesInstallSteps[] | cdktf.IResolvable): void;
    resetInstallSteps(): void;
    get installStepsInput(): cdktf.IResolvable | GoogleOsConfigGuestPoliciesRecipesInstallSteps[] | undefined;
    private _updateSteps;
    get updateSteps(): GoogleOsConfigGuestPoliciesRecipesUpdateStepsList;
    putUpdateSteps(value: GoogleOsConfigGuestPoliciesRecipesUpdateSteps[] | cdktf.IResolvable): void;
    resetUpdateSteps(): void;
    get updateStepsInput(): cdktf.IResolvable | GoogleOsConfigGuestPoliciesRecipesUpdateSteps[] | undefined;
}
export declare class GoogleOsConfigGuestPoliciesRecipesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleOsConfigGuestPoliciesRecipes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleOsConfigGuestPoliciesRecipesOutputReference;
}
export interface GoogleOsConfigGuestPoliciesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#create GoogleOsConfigGuestPolicies#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#delete GoogleOsConfigGuestPolicies#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies#update GoogleOsConfigGuestPolicies#update}
    */
    readonly update?: string;
}
export declare function googleOsConfigGuestPoliciesTimeoutsToTerraform(struct?: GoogleOsConfigGuestPoliciesTimeoutsOutputReference | GoogleOsConfigGuestPoliciesTimeouts | cdktf.IResolvable): any;
export declare class GoogleOsConfigGuestPoliciesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsConfigGuestPoliciesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsConfigGuestPoliciesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies google_os_config_guest_policies}
*/
export declare class GoogleOsConfigGuestPolicies extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_os_config_guest_policies";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_os_config_guest_policies google_os_config_guest_policies} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleOsConfigGuestPoliciesConfig
    */
    constructor(scope: Construct, id: string, config: GoogleOsConfigGuestPoliciesConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    private _guestPolicyId?;
    get guestPolicyId(): string;
    set guestPolicyId(value: string);
    get guestPolicyIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _assignment;
    get assignment(): GoogleOsConfigGuestPoliciesAssignmentOutputReference;
    putAssignment(value: GoogleOsConfigGuestPoliciesAssignment): void;
    get assignmentInput(): GoogleOsConfigGuestPoliciesAssignment | undefined;
    private _packageRepositories;
    get packageRepositories(): GoogleOsConfigGuestPoliciesPackageRepositoriesList;
    putPackageRepositories(value: GoogleOsConfigGuestPoliciesPackageRepositories[] | cdktf.IResolvable): void;
    resetPackageRepositories(): void;
    get packageRepositoriesInput(): cdktf.IResolvable | GoogleOsConfigGuestPoliciesPackageRepositories[] | undefined;
    private _packages;
    get packages(): GoogleOsConfigGuestPoliciesPackagesList;
    putPackages(value: GoogleOsConfigGuestPoliciesPackages[] | cdktf.IResolvable): void;
    resetPackages(): void;
    get packagesInput(): cdktf.IResolvable | GoogleOsConfigGuestPoliciesPackages[] | undefined;
    private _recipes;
    get recipes(): GoogleOsConfigGuestPoliciesRecipesList;
    putRecipes(value: GoogleOsConfigGuestPoliciesRecipes[] | cdktf.IResolvable): void;
    resetRecipes(): void;
    get recipesInput(): cdktf.IResolvable | GoogleOsConfigGuestPoliciesRecipes[] | undefined;
    private _timeouts;
    get timeouts(): GoogleOsConfigGuestPoliciesTimeoutsOutputReference;
    putTimeouts(value: GoogleOsConfigGuestPoliciesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleOsConfigGuestPoliciesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
