import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleProjectIamCustomRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description for the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_iam_custom_role#description GoogleProjectIamCustomRole#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_iam_custom_role#id GoogleProjectIamCustomRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The names of the permissions this role grants when bound in an IAM policy. At least one permission must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_iam_custom_role#permissions GoogleProjectIamCustomRole#permissions}
    */
    readonly permissions: string[];
    /**
    * The project that the service account will be created in. Defaults to the provider project configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_iam_custom_role#project GoogleProjectIamCustomRole#project}
    */
    readonly project?: string;
    /**
    * The camel case role id to use for this role. Cannot contain - characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_iam_custom_role#role_id GoogleProjectIamCustomRole#role_id}
    */
    readonly roleId: string;
    /**
    * The current launch stage of the role. Defaults to GA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_iam_custom_role#stage GoogleProjectIamCustomRole#stage}
    */
    readonly stage?: string;
    /**
    * A human-readable title for the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_iam_custom_role#title GoogleProjectIamCustomRole#title}
    */
    readonly title: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_iam_custom_role google_project_iam_custom_role}
*/
export declare class GoogleProjectIamCustomRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_iam_custom_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_iam_custom_role google_project_iam_custom_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProjectIamCustomRoleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleProjectIamCustomRoleConfig);
    get deleted(): cdktf.IResolvable;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _permissions?;
    get permissions(): string[];
    set permissions(value: string[]);
    get permissionsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    private _stage?;
    get stage(): string;
    set stage(value: string);
    resetStage(): void;
    get stageInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
