import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleProjectOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#constraint GoogleProjectOrganizationPolicy#constraint}
    */
    readonly constraint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#id GoogleProjectOrganizationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#project GoogleProjectOrganizationPolicy#project}
    */
    readonly project: string;
    /**
    * Version of the Policy. Default version is 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#version GoogleProjectOrganizationPolicy#version}
    */
    readonly version?: number;
    /**
    * boolean_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#boolean_policy GoogleProjectOrganizationPolicy#boolean_policy}
    */
    readonly booleanPolicy?: GoogleProjectOrganizationPolicyBooleanPolicy;
    /**
    * list_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#list_policy GoogleProjectOrganizationPolicy#list_policy}
    */
    readonly listPolicy?: GoogleProjectOrganizationPolicyListPolicy;
    /**
    * restore_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#restore_policy GoogleProjectOrganizationPolicy#restore_policy}
    */
    readonly restorePolicy?: GoogleProjectOrganizationPolicyRestorePolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#timeouts GoogleProjectOrganizationPolicy#timeouts}
    */
    readonly timeouts?: GoogleProjectOrganizationPolicyTimeouts;
}
export interface GoogleProjectOrganizationPolicyBooleanPolicy {
    /**
    * If true, then the Policy is enforced. If false, then any configuration is acceptable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#enforced GoogleProjectOrganizationPolicy#enforced}
    */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare function googleProjectOrganizationPolicyBooleanPolicyToTerraform(struct?: GoogleProjectOrganizationPolicyBooleanPolicyOutputReference | GoogleProjectOrganizationPolicyBooleanPolicy): any;
export declare class GoogleProjectOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectOrganizationPolicyBooleanPolicy | undefined;
    set internalValue(value: GoogleProjectOrganizationPolicyBooleanPolicy | undefined);
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleProjectOrganizationPolicyListPolicyAllow {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#all GoogleProjectOrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#values GoogleProjectOrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function googleProjectOrganizationPolicyListPolicyAllowToTerraform(struct?: GoogleProjectOrganizationPolicyListPolicyAllowOutputReference | GoogleProjectOrganizationPolicyListPolicyAllow): any;
export declare class GoogleProjectOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectOrganizationPolicyListPolicyAllow | undefined;
    set internalValue(value: GoogleProjectOrganizationPolicyListPolicyAllow | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleProjectOrganizationPolicyListPolicyDeny {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#all GoogleProjectOrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#values GoogleProjectOrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function googleProjectOrganizationPolicyListPolicyDenyToTerraform(struct?: GoogleProjectOrganizationPolicyListPolicyDenyOutputReference | GoogleProjectOrganizationPolicyListPolicyDeny): any;
export declare class GoogleProjectOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectOrganizationPolicyListPolicyDeny | undefined;
    set internalValue(value: GoogleProjectOrganizationPolicyListPolicyDeny | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleProjectOrganizationPolicyListPolicy {
    /**
    * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#inherit_from_parent GoogleProjectOrganizationPolicy#inherit_from_parent}
    */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#suggested_value GoogleProjectOrganizationPolicy#suggested_value}
    */
    readonly suggestedValue?: string;
    /**
    * allow block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#allow GoogleProjectOrganizationPolicy#allow}
    */
    readonly allow?: GoogleProjectOrganizationPolicyListPolicyAllow;
    /**
    * deny block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#deny GoogleProjectOrganizationPolicy#deny}
    */
    readonly deny?: GoogleProjectOrganizationPolicyListPolicyDeny;
}
export declare function googleProjectOrganizationPolicyListPolicyToTerraform(struct?: GoogleProjectOrganizationPolicyListPolicyOutputReference | GoogleProjectOrganizationPolicyListPolicy): any;
export declare class GoogleProjectOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectOrganizationPolicyListPolicy | undefined;
    set internalValue(value: GoogleProjectOrganizationPolicyListPolicy | undefined);
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable;
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    get suggestedValue(): string;
    set suggestedValue(value: string);
    resetSuggestedValue(): void;
    get suggestedValueInput(): string | undefined;
    private _allow;
    get allow(): GoogleProjectOrganizationPolicyListPolicyAllowOutputReference;
    putAllow(value: GoogleProjectOrganizationPolicyListPolicyAllow): void;
    resetAllow(): void;
    get allowInput(): GoogleProjectOrganizationPolicyListPolicyAllow | undefined;
    private _deny;
    get deny(): GoogleProjectOrganizationPolicyListPolicyDenyOutputReference;
    putDeny(value: GoogleProjectOrganizationPolicyListPolicyDeny): void;
    resetDeny(): void;
    get denyInput(): GoogleProjectOrganizationPolicyListPolicyDeny | undefined;
}
export interface GoogleProjectOrganizationPolicyRestorePolicy {
    /**
    * May only be set to true. If set, then the default Policy is restored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#default GoogleProjectOrganizationPolicy#default}
    */
    readonly default: boolean | cdktf.IResolvable;
}
export declare function googleProjectOrganizationPolicyRestorePolicyToTerraform(struct?: GoogleProjectOrganizationPolicyRestorePolicyOutputReference | GoogleProjectOrganizationPolicyRestorePolicy): any;
export declare class GoogleProjectOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectOrganizationPolicyRestorePolicy | undefined;
    set internalValue(value: GoogleProjectOrganizationPolicyRestorePolicy | undefined);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleProjectOrganizationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#create GoogleProjectOrganizationPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#delete GoogleProjectOrganizationPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#read GoogleProjectOrganizationPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy#update GoogleProjectOrganizationPolicy#update}
    */
    readonly update?: string;
}
export declare function googleProjectOrganizationPolicyTimeoutsToTerraform(struct?: GoogleProjectOrganizationPolicyTimeoutsOutputReference | GoogleProjectOrganizationPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleProjectOrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectOrganizationPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleProjectOrganizationPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy google_project_organization_policy}
*/
export declare class GoogleProjectOrganizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_organization_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_organization_policy google_project_organization_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProjectOrganizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleProjectOrganizationPolicyConfig);
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _booleanPolicy;
    get booleanPolicy(): GoogleProjectOrganizationPolicyBooleanPolicyOutputReference;
    putBooleanPolicy(value: GoogleProjectOrganizationPolicyBooleanPolicy): void;
    resetBooleanPolicy(): void;
    get booleanPolicyInput(): GoogleProjectOrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy;
    get listPolicy(): GoogleProjectOrganizationPolicyListPolicyOutputReference;
    putListPolicy(value: GoogleProjectOrganizationPolicyListPolicy): void;
    resetListPolicy(): void;
    get listPolicyInput(): GoogleProjectOrganizationPolicyListPolicy | undefined;
    private _restorePolicy;
    get restorePolicy(): GoogleProjectOrganizationPolicyRestorePolicyOutputReference;
    putRestorePolicy(value: GoogleProjectOrganizationPolicyRestorePolicy): void;
    resetRestorePolicy(): void;
    get restorePolicyInput(): GoogleProjectOrganizationPolicyRestorePolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleProjectOrganizationPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleProjectOrganizationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleProjectOrganizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
