import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleProjectServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#disable_dependent_services GoogleProjectService#disable_dependent_services}
    */
    readonly disableDependentServices?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#disable_on_destroy GoogleProjectService#disable_on_destroy}
    */
    readonly disableOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#id GoogleProjectService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#project GoogleProjectService#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#service GoogleProjectService#service}
    */
    readonly service: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#timeouts GoogleProjectService#timeouts}
    */
    readonly timeouts?: GoogleProjectServiceTimeouts;
}
export interface GoogleProjectServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#create GoogleProjectService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#delete GoogleProjectService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#read GoogleProjectService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service#update GoogleProjectService#update}
    */
    readonly update?: string;
}
export declare function googleProjectServiceTimeoutsToTerraform(struct?: GoogleProjectServiceTimeoutsOutputReference | GoogleProjectServiceTimeouts | cdktf.IResolvable): any;
export declare class GoogleProjectServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleProjectServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service google_project_service}
*/
export declare class GoogleProjectService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_project_service google_project_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProjectServiceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleProjectServiceConfig);
    private _disableDependentServices?;
    get disableDependentServices(): boolean | cdktf.IResolvable;
    set disableDependentServices(value: boolean | cdktf.IResolvable);
    resetDisableDependentServices(): void;
    get disableDependentServicesInput(): boolean | cdktf.IResolvable | undefined;
    private _disableOnDestroy?;
    get disableOnDestroy(): boolean | cdktf.IResolvable;
    set disableOnDestroy(value: boolean | cdktf.IResolvable);
    resetDisableOnDestroy(): void;
    get disableOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleProjectServiceTimeoutsOutputReference;
    putTimeouts(value: GoogleProjectServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleProjectServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
