import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePubsubLiteReservationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation#id GooglePubsubLiteReservation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the reservation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation#name GooglePubsubLiteReservation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation#project GooglePubsubLiteReservation#project}
    */
    readonly project?: string;
    /**
    * The region of the pubsub lite reservation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation#region GooglePubsubLiteReservation#region}
    */
    readonly region?: string;
    /**
    * The reserved throughput capacity. Every unit of throughput capacity is
  equivalent to 1 MiB/s of published messages or 2 MiB/s of subscribed
  messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation#throughput_capacity GooglePubsubLiteReservation#throughput_capacity}
    */
    readonly throughputCapacity: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation#timeouts GooglePubsubLiteReservation#timeouts}
    */
    readonly timeouts?: GooglePubsubLiteReservationTimeouts;
}
export interface GooglePubsubLiteReservationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation#create GooglePubsubLiteReservation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation#delete GooglePubsubLiteReservation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation#update GooglePubsubLiteReservation#update}
    */
    readonly update?: string;
}
export declare function googlePubsubLiteReservationTimeoutsToTerraform(struct?: GooglePubsubLiteReservationTimeoutsOutputReference | GooglePubsubLiteReservationTimeouts | cdktf.IResolvable): any;
export declare class GooglePubsubLiteReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubLiteReservationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePubsubLiteReservationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation google_pubsub_lite_reservation}
*/
export declare class GooglePubsubLiteReservation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_lite_reservation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_lite_reservation google_pubsub_lite_reservation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePubsubLiteReservationConfig
    */
    constructor(scope: Construct, id: string, config: GooglePubsubLiteReservationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _throughputCapacity?;
    get throughputCapacity(): number;
    set throughputCapacity(value: number);
    get throughputCapacityInput(): number | undefined;
    private _timeouts;
    get timeouts(): GooglePubsubLiteReservationTimeoutsOutputReference;
    putTimeouts(value: GooglePubsubLiteReservationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePubsubLiteReservationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
