import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePubsubSubscriptionIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_subscription_iam_policy#id GooglePubsubSubscriptionIamPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_subscription_iam_policy#policy_data GooglePubsubSubscriptionIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_subscription_iam_policy#project GooglePubsubSubscriptionIamPolicy#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_subscription_iam_policy#subscription GooglePubsubSubscriptionIamPolicy#subscription}
    */
    readonly subscription: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_subscription_iam_policy google_pubsub_subscription_iam_policy}
*/
export declare class GooglePubsubSubscriptionIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_subscription_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_subscription_iam_policy google_pubsub_subscription_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePubsubSubscriptionIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GooglePubsubSubscriptionIamPolicyConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _subscription?;
    get subscription(): string;
    set subscription(value: string);
    get subscriptionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
