"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GooglePubsubSubscription = exports.GooglePubsubSubscriptionTimeoutsOutputReference = exports.googlePubsubSubscriptionTimeoutsToTerraform = exports.GooglePubsubSubscriptionRetryPolicyOutputReference = exports.googlePubsubSubscriptionRetryPolicyToTerraform = exports.GooglePubsubSubscriptionPushConfigOutputReference = exports.googlePubsubSubscriptionPushConfigToTerraform = exports.GooglePubsubSubscriptionPushConfigOidcTokenOutputReference = exports.googlePubsubSubscriptionPushConfigOidcTokenToTerraform = exports.GooglePubsubSubscriptionExpirationPolicyOutputReference = exports.googlePubsubSubscriptionExpirationPolicyToTerraform = exports.GooglePubsubSubscriptionDeadLetterPolicyOutputReference = exports.googlePubsubSubscriptionDeadLetterPolicyToTerraform = exports.GooglePubsubSubscriptionBigqueryConfigOutputReference = exports.googlePubsubSubscriptionBigqueryConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function googlePubsubSubscriptionBigqueryConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        drop_unknown_fields: cdktf.booleanToTerraform(struct.dropUnknownFields),
        table: cdktf.stringToTerraform(struct.table),
        use_topic_schema: cdktf.booleanToTerraform(struct.useTopicSchema),
        write_metadata: cdktf.booleanToTerraform(struct.writeMetadata),
    };
}
exports.googlePubsubSubscriptionBigqueryConfigToTerraform = googlePubsubSubscriptionBigqueryConfigToTerraform;
class GooglePubsubSubscriptionBigqueryConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._dropUnknownFields !== undefined) {
            hasAnyValues = true;
            internalValueResult.dropUnknownFields = this._dropUnknownFields;
        }
        if (this._table !== undefined) {
            hasAnyValues = true;
            internalValueResult.table = this._table;
        }
        if (this._useTopicSchema !== undefined) {
            hasAnyValues = true;
            internalValueResult.useTopicSchema = this._useTopicSchema;
        }
        if (this._writeMetadata !== undefined) {
            hasAnyValues = true;
            internalValueResult.writeMetadata = this._writeMetadata;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._dropUnknownFields = undefined;
            this._table = undefined;
            this._useTopicSchema = undefined;
            this._writeMetadata = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._dropUnknownFields = value.dropUnknownFields;
            this._table = value.table;
            this._useTopicSchema = value.useTopicSchema;
            this._writeMetadata = value.writeMetadata;
        }
    }
    get dropUnknownFields() {
        return this.getBooleanAttribute('drop_unknown_fields');
    }
    set dropUnknownFields(value) {
        this._dropUnknownFields = value;
    }
    resetDropUnknownFields() {
        this._dropUnknownFields = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dropUnknownFieldsInput() {
        return this._dropUnknownFields;
    }
    get table() {
        return this.getStringAttribute('table');
    }
    set table(value) {
        this._table = value;
    }
    // Temporarily expose input value. Use with caution.
    get tableInput() {
        return this._table;
    }
    get useTopicSchema() {
        return this.getBooleanAttribute('use_topic_schema');
    }
    set useTopicSchema(value) {
        this._useTopicSchema = value;
    }
    resetUseTopicSchema() {
        this._useTopicSchema = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useTopicSchemaInput() {
        return this._useTopicSchema;
    }
    get writeMetadata() {
        return this.getBooleanAttribute('write_metadata');
    }
    set writeMetadata(value) {
        this._writeMetadata = value;
    }
    resetWriteMetadata() {
        this._writeMetadata = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get writeMetadataInput() {
        return this._writeMetadata;
    }
}
exports.GooglePubsubSubscriptionBigqueryConfigOutputReference = GooglePubsubSubscriptionBigqueryConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GooglePubsubSubscriptionBigqueryConfigOutputReference[_a] = { fqn: "@cdktf/provider-google-beta.googlePubsubSubscription.GooglePubsubSubscriptionBigqueryConfigOutputReference", version: "3.0.1" };
function googlePubsubSubscriptionDeadLetterPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        dead_letter_topic: cdktf.stringToTerraform(struct.deadLetterTopic),
        max_delivery_attempts: cdktf.numberToTerraform(struct.maxDeliveryAttempts),
    };
}
exports.googlePubsubSubscriptionDeadLetterPolicyToTerraform = googlePubsubSubscriptionDeadLetterPolicyToTerraform;
class GooglePubsubSubscriptionDeadLetterPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._deadLetterTopic !== undefined) {
            hasAnyValues = true;
            internalValueResult.deadLetterTopic = this._deadLetterTopic;
        }
        if (this._maxDeliveryAttempts !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxDeliveryAttempts = this._maxDeliveryAttempts;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._deadLetterTopic = undefined;
            this._maxDeliveryAttempts = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._deadLetterTopic = value.deadLetterTopic;
            this._maxDeliveryAttempts = value.maxDeliveryAttempts;
        }
    }
    get deadLetterTopic() {
        return this.getStringAttribute('dead_letter_topic');
    }
    set deadLetterTopic(value) {
        this._deadLetterTopic = value;
    }
    resetDeadLetterTopic() {
        this._deadLetterTopic = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deadLetterTopicInput() {
        return this._deadLetterTopic;
    }
    get maxDeliveryAttempts() {
        return this.getNumberAttribute('max_delivery_attempts');
    }
    set maxDeliveryAttempts(value) {
        this._maxDeliveryAttempts = value;
    }
    resetMaxDeliveryAttempts() {
        this._maxDeliveryAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxDeliveryAttemptsInput() {
        return this._maxDeliveryAttempts;
    }
}
exports.GooglePubsubSubscriptionDeadLetterPolicyOutputReference = GooglePubsubSubscriptionDeadLetterPolicyOutputReference;
_b = JSII_RTTI_SYMBOL_1;
GooglePubsubSubscriptionDeadLetterPolicyOutputReference[_b] = { fqn: "@cdktf/provider-google-beta.googlePubsubSubscription.GooglePubsubSubscriptionDeadLetterPolicyOutputReference", version: "3.0.1" };
function googlePubsubSubscriptionExpirationPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        ttl: cdktf.stringToTerraform(struct.ttl),
    };
}
exports.googlePubsubSubscriptionExpirationPolicyToTerraform = googlePubsubSubscriptionExpirationPolicyToTerraform;
class GooglePubsubSubscriptionExpirationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._ttl !== undefined) {
            hasAnyValues = true;
            internalValueResult.ttl = this._ttl;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._ttl = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._ttl = value.ttl;
        }
    }
    get ttl() {
        return this.getStringAttribute('ttl');
    }
    set ttl(value) {
        this._ttl = value;
    }
    // Temporarily expose input value. Use with caution.
    get ttlInput() {
        return this._ttl;
    }
}
exports.GooglePubsubSubscriptionExpirationPolicyOutputReference = GooglePubsubSubscriptionExpirationPolicyOutputReference;
_c = JSII_RTTI_SYMBOL_1;
GooglePubsubSubscriptionExpirationPolicyOutputReference[_c] = { fqn: "@cdktf/provider-google-beta.googlePubsubSubscription.GooglePubsubSubscriptionExpirationPolicyOutputReference", version: "3.0.1" };
function googlePubsubSubscriptionPushConfigOidcTokenToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        audience: cdktf.stringToTerraform(struct.audience),
        service_account_email: cdktf.stringToTerraform(struct.serviceAccountEmail),
    };
}
exports.googlePubsubSubscriptionPushConfigOidcTokenToTerraform = googlePubsubSubscriptionPushConfigOidcTokenToTerraform;
class GooglePubsubSubscriptionPushConfigOidcTokenOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._audience !== undefined) {
            hasAnyValues = true;
            internalValueResult.audience = this._audience;
        }
        if (this._serviceAccountEmail !== undefined) {
            hasAnyValues = true;
            internalValueResult.serviceAccountEmail = this._serviceAccountEmail;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._audience = undefined;
            this._serviceAccountEmail = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._audience = value.audience;
            this._serviceAccountEmail = value.serviceAccountEmail;
        }
    }
    get audience() {
        return this.getStringAttribute('audience');
    }
    set audience(value) {
        this._audience = value;
    }
    resetAudience() {
        this._audience = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get audienceInput() {
        return this._audience;
    }
    get serviceAccountEmail() {
        return this.getStringAttribute('service_account_email');
    }
    set serviceAccountEmail(value) {
        this._serviceAccountEmail = value;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccountEmailInput() {
        return this._serviceAccountEmail;
    }
}
exports.GooglePubsubSubscriptionPushConfigOidcTokenOutputReference = GooglePubsubSubscriptionPushConfigOidcTokenOutputReference;
_d = JSII_RTTI_SYMBOL_1;
GooglePubsubSubscriptionPushConfigOidcTokenOutputReference[_d] = { fqn: "@cdktf/provider-google-beta.googlePubsubSubscription.GooglePubsubSubscriptionPushConfigOidcTokenOutputReference", version: "3.0.1" };
function googlePubsubSubscriptionPushConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        attributes: cdktf.hashMapper(cdktf.stringToTerraform)(struct.attributes),
        push_endpoint: cdktf.stringToTerraform(struct.pushEndpoint),
        oidc_token: googlePubsubSubscriptionPushConfigOidcTokenToTerraform(struct.oidcToken),
    };
}
exports.googlePubsubSubscriptionPushConfigToTerraform = googlePubsubSubscriptionPushConfigToTerraform;
class GooglePubsubSubscriptionPushConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // oidc_token - computed: false, optional: true, required: false
        this._oidcToken = new GooglePubsubSubscriptionPushConfigOidcTokenOutputReference(this, "oidc_token");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._attributes !== undefined) {
            hasAnyValues = true;
            internalValueResult.attributes = this._attributes;
        }
        if (this._pushEndpoint !== undefined) {
            hasAnyValues = true;
            internalValueResult.pushEndpoint = this._pushEndpoint;
        }
        if (this._oidcToken?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.oidcToken = this._oidcToken?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._attributes = undefined;
            this._pushEndpoint = undefined;
            this._oidcToken.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._attributes = value.attributes;
            this._pushEndpoint = value.pushEndpoint;
            this._oidcToken.internalValue = value.oidcToken;
        }
    }
    get attributes() {
        return this.getStringMapAttribute('attributes');
    }
    set attributes(value) {
        this._attributes = value;
    }
    resetAttributes() {
        this._attributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get attributesInput() {
        return this._attributes;
    }
    get pushEndpoint() {
        return this.getStringAttribute('push_endpoint');
    }
    set pushEndpoint(value) {
        this._pushEndpoint = value;
    }
    // Temporarily expose input value. Use with caution.
    get pushEndpointInput() {
        return this._pushEndpoint;
    }
    get oidcToken() {
        return this._oidcToken;
    }
    putOidcToken(value) {
        this._oidcToken.internalValue = value;
    }
    resetOidcToken() {
        this._oidcToken.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcTokenInput() {
        return this._oidcToken.internalValue;
    }
}
exports.GooglePubsubSubscriptionPushConfigOutputReference = GooglePubsubSubscriptionPushConfigOutputReference;
_e = JSII_RTTI_SYMBOL_1;
GooglePubsubSubscriptionPushConfigOutputReference[_e] = { fqn: "@cdktf/provider-google-beta.googlePubsubSubscription.GooglePubsubSubscriptionPushConfigOutputReference", version: "3.0.1" };
function googlePubsubSubscriptionRetryPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        maximum_backoff: cdktf.stringToTerraform(struct.maximumBackoff),
        minimum_backoff: cdktf.stringToTerraform(struct.minimumBackoff),
    };
}
exports.googlePubsubSubscriptionRetryPolicyToTerraform = googlePubsubSubscriptionRetryPolicyToTerraform;
class GooglePubsubSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maximumBackoff !== undefined) {
            hasAnyValues = true;
            internalValueResult.maximumBackoff = this._maximumBackoff;
        }
        if (this._minimumBackoff !== undefined) {
            hasAnyValues = true;
            internalValueResult.minimumBackoff = this._minimumBackoff;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maximumBackoff = undefined;
            this._minimumBackoff = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maximumBackoff = value.maximumBackoff;
            this._minimumBackoff = value.minimumBackoff;
        }
    }
    get maximumBackoff() {
        return this.getStringAttribute('maximum_backoff');
    }
    set maximumBackoff(value) {
        this._maximumBackoff = value;
    }
    resetMaximumBackoff() {
        this._maximumBackoff = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maximumBackoffInput() {
        return this._maximumBackoff;
    }
    get minimumBackoff() {
        return this.getStringAttribute('minimum_backoff');
    }
    set minimumBackoff(value) {
        this._minimumBackoff = value;
    }
    resetMinimumBackoff() {
        this._minimumBackoff = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minimumBackoffInput() {
        return this._minimumBackoff;
    }
}
exports.GooglePubsubSubscriptionRetryPolicyOutputReference = GooglePubsubSubscriptionRetryPolicyOutputReference;
_f = JSII_RTTI_SYMBOL_1;
GooglePubsubSubscriptionRetryPolicyOutputReference[_f] = { fqn: "@cdktf/provider-google-beta.googlePubsubSubscription.GooglePubsubSubscriptionRetryPolicyOutputReference", version: "3.0.1" };
function googlePubsubSubscriptionTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.googlePubsubSubscriptionTimeoutsToTerraform = googlePubsubSubscriptionTimeoutsToTerraform;
class GooglePubsubSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.GooglePubsubSubscriptionTimeoutsOutputReference = GooglePubsubSubscriptionTimeoutsOutputReference;
_g = JSII_RTTI_SYMBOL_1;
GooglePubsubSubscriptionTimeoutsOutputReference[_g] = { fqn: "@cdktf/provider-google-beta.googlePubsubSubscription.GooglePubsubSubscriptionTimeoutsOutputReference", version: "3.0.1" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_subscription google_pubsub_subscription}
*/
class GooglePubsubSubscription extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_pubsub_subscription google_pubsub_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePubsubSubscriptionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_pubsub_subscription',
            terraformGeneratorMetadata: {
                providerName: 'google-beta',
                providerVersion: '4.38.0',
                providerVersionConstraint: '~> 4.17'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // bigquery_config - computed: false, optional: true, required: false
        this._bigqueryConfig = new GooglePubsubSubscriptionBigqueryConfigOutputReference(this, "bigquery_config");
        // dead_letter_policy - computed: false, optional: true, required: false
        this._deadLetterPolicy = new GooglePubsubSubscriptionDeadLetterPolicyOutputReference(this, "dead_letter_policy");
        // expiration_policy - computed: false, optional: true, required: false
        this._expirationPolicy = new GooglePubsubSubscriptionExpirationPolicyOutputReference(this, "expiration_policy");
        // push_config - computed: false, optional: true, required: false
        this._pushConfig = new GooglePubsubSubscriptionPushConfigOutputReference(this, "push_config");
        // retry_policy - computed: false, optional: true, required: false
        this._retryPolicy = new GooglePubsubSubscriptionRetryPolicyOutputReference(this, "retry_policy");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new GooglePubsubSubscriptionTimeoutsOutputReference(this, "timeouts");
        this._ackDeadlineSeconds = config.ackDeadlineSeconds;
        this._enableExactlyOnceDelivery = config.enableExactlyOnceDelivery;
        this._enableMessageOrdering = config.enableMessageOrdering;
        this._filter = config.filter;
        this._id = config.id;
        this._labels = config.labels;
        this._messageRetentionDuration = config.messageRetentionDuration;
        this._name = config.name;
        this._project = config.project;
        this._retainAckedMessages = config.retainAckedMessages;
        this._topic = config.topic;
        this._bigqueryConfig.internalValue = config.bigqueryConfig;
        this._deadLetterPolicy.internalValue = config.deadLetterPolicy;
        this._expirationPolicy.internalValue = config.expirationPolicy;
        this._pushConfig.internalValue = config.pushConfig;
        this._retryPolicy.internalValue = config.retryPolicy;
        this._timeouts.internalValue = config.timeouts;
    }
    get ackDeadlineSeconds() {
        return this.getNumberAttribute('ack_deadline_seconds');
    }
    set ackDeadlineSeconds(value) {
        this._ackDeadlineSeconds = value;
    }
    resetAckDeadlineSeconds() {
        this._ackDeadlineSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ackDeadlineSecondsInput() {
        return this._ackDeadlineSeconds;
    }
    get enableExactlyOnceDelivery() {
        return this.getBooleanAttribute('enable_exactly_once_delivery');
    }
    set enableExactlyOnceDelivery(value) {
        this._enableExactlyOnceDelivery = value;
    }
    resetEnableExactlyOnceDelivery() {
        this._enableExactlyOnceDelivery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableExactlyOnceDeliveryInput() {
        return this._enableExactlyOnceDelivery;
    }
    get enableMessageOrdering() {
        return this.getBooleanAttribute('enable_message_ordering');
    }
    set enableMessageOrdering(value) {
        this._enableMessageOrdering = value;
    }
    resetEnableMessageOrdering() {
        this._enableMessageOrdering = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableMessageOrderingInput() {
        return this._enableMessageOrdering;
    }
    get filter() {
        return this.getStringAttribute('filter');
    }
    set filter(value) {
        this._filter = value;
    }
    resetFilter() {
        this._filter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filterInput() {
        return this._filter;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get messageRetentionDuration() {
        return this.getStringAttribute('message_retention_duration');
    }
    set messageRetentionDuration(value) {
        this._messageRetentionDuration = value;
    }
    resetMessageRetentionDuration() {
        this._messageRetentionDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get messageRetentionDurationInput() {
        return this._messageRetentionDuration;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get retainAckedMessages() {
        return this.getBooleanAttribute('retain_acked_messages');
    }
    set retainAckedMessages(value) {
        this._retainAckedMessages = value;
    }
    resetRetainAckedMessages() {
        this._retainAckedMessages = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retainAckedMessagesInput() {
        return this._retainAckedMessages;
    }
    get topic() {
        return this.getStringAttribute('topic');
    }
    set topic(value) {
        this._topic = value;
    }
    // Temporarily expose input value. Use with caution.
    get topicInput() {
        return this._topic;
    }
    get bigqueryConfig() {
        return this._bigqueryConfig;
    }
    putBigqueryConfig(value) {
        this._bigqueryConfig.internalValue = value;
    }
    resetBigqueryConfig() {
        this._bigqueryConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryConfigInput() {
        return this._bigqueryConfig.internalValue;
    }
    get deadLetterPolicy() {
        return this._deadLetterPolicy;
    }
    putDeadLetterPolicy(value) {
        this._deadLetterPolicy.internalValue = value;
    }
    resetDeadLetterPolicy() {
        this._deadLetterPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deadLetterPolicyInput() {
        return this._deadLetterPolicy.internalValue;
    }
    get expirationPolicy() {
        return this._expirationPolicy;
    }
    putExpirationPolicy(value) {
        this._expirationPolicy.internalValue = value;
    }
    resetExpirationPolicy() {
        this._expirationPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expirationPolicyInput() {
        return this._expirationPolicy.internalValue;
    }
    get pushConfig() {
        return this._pushConfig;
    }
    putPushConfig(value) {
        this._pushConfig.internalValue = value;
    }
    resetPushConfig() {
        this._pushConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushConfigInput() {
        return this._pushConfig.internalValue;
    }
    get retryPolicy() {
        return this._retryPolicy;
    }
    putRetryPolicy(value) {
        this._retryPolicy.internalValue = value;
    }
    resetRetryPolicy() {
        this._retryPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retryPolicyInput() {
        return this._retryPolicy.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            ack_deadline_seconds: cdktf.numberToTerraform(this._ackDeadlineSeconds),
            enable_exactly_once_delivery: cdktf.booleanToTerraform(this._enableExactlyOnceDelivery),
            enable_message_ordering: cdktf.booleanToTerraform(this._enableMessageOrdering),
            filter: cdktf.stringToTerraform(this._filter),
            id: cdktf.stringToTerraform(this._id),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            message_retention_duration: cdktf.stringToTerraform(this._messageRetentionDuration),
            name: cdktf.stringToTerraform(this._name),
            project: cdktf.stringToTerraform(this._project),
            retain_acked_messages: cdktf.booleanToTerraform(this._retainAckedMessages),
            topic: cdktf.stringToTerraform(this._topic),
            bigquery_config: googlePubsubSubscriptionBigqueryConfigToTerraform(this._bigqueryConfig.internalValue),
            dead_letter_policy: googlePubsubSubscriptionDeadLetterPolicyToTerraform(this._deadLetterPolicy.internalValue),
            expiration_policy: googlePubsubSubscriptionExpirationPolicyToTerraform(this._expirationPolicy.internalValue),
            push_config: googlePubsubSubscriptionPushConfigToTerraform(this._pushConfig.internalValue),
            retry_policy: googlePubsubSubscriptionRetryPolicyToTerraform(this._retryPolicy.internalValue),
            timeouts: googlePubsubSubscriptionTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.GooglePubsubSubscription = GooglePubsubSubscription;
_h = JSII_RTTI_SYMBOL_1;
GooglePubsubSubscription[_h] = { fqn: "@cdktf/provider-google-beta.googlePubsubSubscription.GooglePubsubSubscription", version: "3.0.1" };
// =================
// STATIC PROPERTIES
// =================
GooglePubsubSubscription.tfResourceType = "google_pubsub_subscription";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZ29vZ2xlLXB1YnN1Yi1zdWJzY3JpcHRpb24vaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFJQSwrQkFBK0I7QUFpTC9CLFNBQWdCLGlEQUFpRCxDQUFDLE1BQXVHO0lBQ3ZLLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxpQkFBaUIsQ0FBQztRQUN4RSxLQUFLLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxLQUFLLENBQUM7UUFDN0MsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxjQUFjLENBQUM7UUFDbEUsY0FBYyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsYUFBYSxDQUFDO0tBQ2hFLENBQUE7QUFDSCxDQUFDO0FBWEQsOEdBV0M7QUFFRCxNQUFhLHFEQUFzRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBRzVGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxTQUFTLEVBQUU7WUFDekMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7U0FDakU7UUFDRCxJQUFJLElBQUksQ0FBQyxNQUFNLEtBQUssU0FBUyxFQUFFO1lBQzdCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUM7U0FDekM7UUFDRCxJQUFJLElBQUksQ0FBQyxlQUFlLEtBQUssU0FBUyxFQUFFO1lBQ3RDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDM0Q7UUFDRCxJQUFJLElBQUksQ0FBQyxjQUFjLEtBQUssU0FBUyxFQUFFO1lBQ3JDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUM7U0FDekQ7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBeUQ7UUFDaEYsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7WUFDcEMsSUFBSSxDQUFDLE1BQU0sR0FBRyxTQUFTLENBQUM7WUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7WUFDakMsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7U0FDakM7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7WUFDbEQsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1lBQzFCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztZQUM1QyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7U0FDM0M7SUFDSCxDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFrQztRQUM3RCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO0lBQ2xDLENBQUM7SUFDTSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztJQUN0QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7SUFJRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBQ0QsSUFBVyxLQUFLLENBQUMsS0FBYTtRQUM1QixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztJQUN0QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUlELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3RELENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUFrQztRQUMxRCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztJQUMvQixDQUFDO0lBQ00sbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO0lBQ25DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBa0M7UUFDekQsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUNNLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztJQUNsQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDOztBQTdHSCxzSEE4R0M7OztBQXFDRCxTQUFnQixtREFBbUQsQ0FBQyxNQUEyRztJQUM3SyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsZUFBZSxDQUFDO1FBQ25FLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsbUJBQW1CLENBQUM7S0FDNUUsQ0FBQTtBQUNILENBQUM7QUFURCxrSEFTQztBQUVELE1BQWEsdURBQXdELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHOUY7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLGdCQUFnQixLQUFLLFNBQVMsRUFBRTtZQUN2QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7U0FDN0Q7UUFDRCxJQUFJLElBQUksQ0FBQyxvQkFBb0IsS0FBSyxTQUFTLEVBQUU7WUFDM0MsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUM7U0FDckU7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBMkQ7UUFDbEYsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUM7WUFDbEMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFNBQVMsQ0FBQztTQUN2QzthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7WUFDOUMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztTQUN2RDtJQUNILENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBQ0QsSUFBVyxlQUFlLENBQUMsS0FBYTtRQUN0QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQWE7UUFDMUMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBQ00sd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxTQUFTLENBQUM7SUFDeEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDOztBQXBFSCwwSEFxRUM7OztBQWNELFNBQWdCLG1EQUFtRCxDQUFDLE1BQTJHO0lBQzdLLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsR0FBRyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsR0FBRyxDQUFDO0tBQzFDLENBQUE7QUFDSCxDQUFDO0FBUkQsa0hBUUM7QUFFRCxNQUFhLHVEQUF3RCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBRzlGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssU0FBUyxFQUFFO1lBQzNCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUM7U0FDckM7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBMkQ7UUFDbEYsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxJQUFJLEdBQUcsU0FBUyxDQUFDO1NBQ3ZCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxHQUFHLENBQUM7U0FDdkI7SUFDSCxDQUFDO0lBSUQsSUFBVyxHQUFHO1FBQ1osT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUNELElBQVcsR0FBRyxDQUFDLEtBQWE7UUFDMUIsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDO0lBQ25CLENBQUM7O0FBM0NILDBIQTRDQzs7O0FBd0JELFNBQWdCLHNEQUFzRCxDQUFDLE1BQWlIO0lBQ3RMLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsUUFBUSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ25ELHFCQUFxQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsbUJBQW1CLENBQUM7S0FDNUUsQ0FBQTtBQUNILENBQUM7QUFURCx3SEFTQztBQUVELE1BQWEsMERBQTJELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHakc7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUMvQztRQUNELElBQUksSUFBSSxDQUFDLG9CQUFvQixLQUFLLFNBQVMsRUFBRTtZQUMzQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLG1CQUFtQixHQUFHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztTQUNyRTtRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUE4RDtRQUNyRixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7WUFDM0IsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFNBQVMsQ0FBQztTQUN2QzthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1lBQ2hDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUM7U0FDdkQ7SUFDSCxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBQ0QsSUFBVyxtQkFBbUIsQ0FBQyxLQUFhO1FBQzFDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUM7SUFDcEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDOztBQWpFSCxnSUFrRUM7OztBQThDRCxTQUFnQiw2Q0FBNkMsQ0FBQyxNQUErRjtJQUMzSixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLE1BQU8sQ0FBQyxVQUFVLENBQUM7UUFDekUsYUFBYSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsWUFBWSxDQUFDO1FBQzVELFVBQVUsRUFBRSxzREFBc0QsQ0FBQyxNQUFPLENBQUMsU0FBUyxDQUFDO0tBQ3RGLENBQUE7QUFDSCxDQUFDO0FBVkQsc0dBVUM7QUFFRCxNQUFhLGlEQUFrRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR3hGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO1FBd0U5QixnRUFBZ0U7UUFDeEQsZUFBVSxHQUFHLElBQUksMERBQTBELENBQUMsSUFBSSxFQUFFLFlBQVksQ0FBQyxDQUFDO0lBakV4RyxDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsV0FBVyxLQUFLLFNBQVMsRUFBRTtZQUNsQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1NBQ25EO1FBQ0QsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLFNBQVMsRUFBRTtZQUNwQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1NBQ3ZEO1FBQ0QsSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFLGFBQWEsS0FBSyxTQUFTLEVBQUU7WUFDaEQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFVBQVUsRUFBRSxhQUFhLENBQUM7U0FDaEU7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBcUQ7UUFDNUUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO1lBQzdCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO1lBQy9CLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztTQUMzQzthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1lBQ3BDLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztZQUN4QyxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1NBQ2pEO0lBQ0gsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBZ0M7UUFDcEQsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUNNLGVBQWU7UUFDcEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxTQUFTLENBQUM7SUFDL0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQWE7UUFDbkMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUNNLFlBQVksQ0FBQyxLQUFrRDtRQUNwRSxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDeEMsQ0FBQztJQUNNLGNBQWM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQzVDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7SUFDdkMsQ0FBQzs7QUF2RkgsOEdBd0ZDOzs7QUFrQkQsU0FBZ0IsOENBQThDLENBQUMsTUFBaUc7SUFDOUosSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxlQUFlLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxjQUFjLENBQUM7UUFDaEUsZUFBZSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsY0FBYyxDQUFDO0tBQ2pFLENBQUE7QUFDSCxDQUFDO0FBVEQsd0dBU0M7QUFFRCxNQUFhLGtEQUFtRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR3pGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxlQUFlLEtBQUssU0FBUyxFQUFFO1lBQ3RDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDM0Q7UUFDRCxJQUFJLElBQUksQ0FBQyxlQUFlLEtBQUssU0FBUyxFQUFFO1lBQ3RDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDM0Q7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBc0Q7UUFDN0UsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO1lBQ2pDLElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO1NBQ2xDO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7WUFDNUMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1NBQzdDO0lBQ0gsQ0FBQztJQUlELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUFhO1FBQ3JDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFDTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7SUFDbkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUlELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUFhO1FBQ3JDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFDTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7SUFDbkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQzs7QUFwRUgsZ0hBcUVDOzs7QUFnQkQsU0FBZ0IsMkNBQTJDLENBQUMsTUFBK0c7SUFDekssSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxNQUFNLENBQUM7UUFDL0MsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO1FBQy9DLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztLQUNoRCxDQUFBO0FBQ0gsQ0FBQztBQVZELGtHQVVDO0FBRUQsTUFBYSwrQ0FBZ0QsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUl0Rjs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVJqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVM5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksSUFBSSxDQUFDLGVBQWUsRUFBRTtZQUN4QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDN0I7UUFDRCxJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUF1RTtRQUM5RixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7WUFDakMsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7U0FDMUI7YUFDSSxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1NBQzlCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztZQUNqQyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7WUFDNUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzVCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztTQUM3QjtJQUNILENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7O0FBcEdILDBHQXFHQzs7O0FBRUQ7O0VBRUU7QUFDRixNQUFhLHdCQUF5QixTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPbkUsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQ7Ozs7OztNQU1FO0lBQ0YsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBc0M7UUFDckYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSw0QkFBNEI7WUFDbkQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxhQUFhO2dCQUMzQixlQUFlLEVBQUUsUUFBUTtnQkFDekIseUJBQXlCLEVBQUUsU0FBUzthQUNyQztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVk7WUFDakMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVO1lBQzdCLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTztTQUN4QixDQUFDLENBQUM7UUFrTUwscUVBQXFFO1FBQzdELG9CQUFlLEdBQUcsSUFBSSxxREFBcUQsQ0FBQyxJQUFJLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztRQWU3Ryx3RUFBd0U7UUFDaEUsc0JBQWlCLEdBQUcsSUFBSSx1REFBdUQsQ0FBQyxJQUFJLEVBQUUsb0JBQW9CLENBQUMsQ0FBQztRQWVwSCx1RUFBdUU7UUFDL0Qsc0JBQWlCLEdBQUcsSUFBSSx1REFBdUQsQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztRQWVuSCxpRUFBaUU7UUFDekQsZ0JBQVcsR0FBRyxJQUFJLGlEQUFpRCxDQUFDLElBQUksRUFBRSxhQUFhLENBQUMsQ0FBQztRQWVqRyxrRUFBa0U7UUFDMUQsaUJBQVksR0FBRyxJQUFJLGtEQUFrRCxDQUFDLElBQUksRUFBRSxjQUFjLENBQUMsQ0FBQztRQWVwRyw4REFBOEQ7UUFDdEQsY0FBUyxHQUFHLElBQUksK0NBQStDLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBbFJ4RixJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQywwQkFBMEIsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7UUFDbkUsSUFBSSxDQUFDLHNCQUFzQixHQUFHLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQztRQUMzRCxJQUFJLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUM7UUFDN0IsSUFBSSxDQUFDLEdBQUcsR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMseUJBQXlCLEdBQUcsTUFBTSxDQUFDLHdCQUF3QixDQUFDO1FBQ2pFLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDL0IsSUFBSSxDQUFDLG9CQUFvQixHQUFHLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQztRQUN2RCxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDM0IsSUFBSSxDQUFDLGVBQWUsQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUMzRCxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvRCxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvRCxJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ25ELElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDckQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQztJQUNqRCxDQUFDO0lBUUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFhO1FBQ3pDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFDbkMsQ0FBQztJQUNNLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsbUJBQW1CLEdBQUcsU0FBUyxDQUFDO0lBQ3ZDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx1QkFBdUI7UUFDaEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUlELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUNELElBQVcseUJBQXlCLENBQUMsS0FBa0M7UUFDckUsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQztJQUMxQyxDQUFDO0lBQ00sOEJBQThCO1FBQ25DLElBQUksQ0FBQywwQkFBMEIsR0FBRyxTQUFTLENBQUM7SUFDOUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDhCQUE4QjtRQUN2QyxPQUFPLElBQUksQ0FBQywwQkFBMEIsQ0FBQztJQUN6QyxDQUFDO0lBSUQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBQ0QsSUFBVyxxQkFBcUIsQ0FBQyxLQUFrQztRQUNqRSxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDO0lBQ3RDLENBQUM7SUFDTSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFNBQVMsQ0FBQztJQUMxQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsMEJBQTBCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDO0lBQ3JDLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsRUFBRTtRQUNYLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFDRCxJQUFXLEVBQUUsQ0FBQyxLQUFhO1FBQ3pCLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFDTSxPQUFPO1FBQ1osSUFBSSxDQUFDLEdBQUcsR0FBRyxTQUFTLENBQUM7SUFDdkIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDO0lBQ2xCLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBZ0M7UUFDaEQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFJRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQy9ELENBQUM7SUFDRCxJQUFXLHdCQUF3QixDQUFDLEtBQWE7UUFDL0MsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQztJQUN6QyxDQUFDO0lBQ00sNkJBQTZCO1FBQ2xDLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxTQUFTLENBQUM7SUFDN0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDZCQUE2QjtRQUN0QyxPQUFPLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztJQUN4QyxDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQWE7UUFDOUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzNELENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQWtDO1FBQy9ELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUM7SUFDcEMsQ0FBQztJQUNNLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsb0JBQW9CLEdBQUcsU0FBUyxDQUFDO0lBQ3hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx3QkFBd0I7UUFDakMsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUlELElBQVcsS0FBSztRQUNkLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFDRCxJQUFXLEtBQUssQ0FBQyxLQUFhO1FBQzVCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO0lBQ3RCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBQ00saUJBQWlCLENBQUMsS0FBNkM7UUFDcEUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdDLENBQUM7SUFDTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2pELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsQ0FBQztJQUM1QyxDQUFDO0lBSUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDaEMsQ0FBQztJQUNNLG1CQUFtQixDQUFDLEtBQStDO1FBQ3hFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQy9DLENBQUM7SUFDTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDbkQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLENBQUM7SUFDOUMsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFDTSxtQkFBbUIsQ0FBQyxLQUErQztRQUN4RSxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUMvQyxDQUFDO0lBQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ25ELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxDQUFDO0lBQzlDLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFDTSxhQUFhLENBQUMsS0FBeUM7UUFDNUQsSUFBSSxDQUFDLFdBQVcsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3pDLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUM3QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxDQUFDO0lBQ3hDLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFDTSxjQUFjLENBQUMsS0FBMEM7UUFDOUQsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQzlDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQztJQUN6QyxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ00sV0FBVyxDQUFDLEtBQXVDO1FBQ3hELElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztJQUN0QyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxvQkFBb0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1lBQ3ZFLDRCQUE0QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7WUFDdkYsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztZQUM5RSxNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7WUFDN0MsRUFBRSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO1lBQ3JDLE1BQU0sRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7WUFDL0QsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztZQUNuRixJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDekMsT0FBTyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQy9DLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7WUFDMUUsS0FBSyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDO1lBQzNDLGVBQWUsRUFBRSxpREFBaUQsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsQ0FBQztZQUN0RyxrQkFBa0IsRUFBRSxtREFBbUQsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxDQUFDO1lBQzdHLGlCQUFpQixFQUFFLG1EQUFtRCxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLENBQUM7WUFDNUcsV0FBVyxFQUFFLDZDQUE2QyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxDQUFDO1lBQzFGLFlBQVksRUFBRSw4Q0FBOEMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQztZQUM3RixRQUFRLEVBQUUsMkNBQTJDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUM7U0FDcEYsQ0FBQztJQUNKLENBQUM7O0FBM1ZILDREQTRWQzs7O0FBMVZDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ0csdUNBQWMsR0FBRyw0QkFBNEIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uQ29uZmlnIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIC8qKlxuICAqIFRoaXMgdmFsdWUgaXMgdGhlIG1heGltdW0gdGltZSBhZnRlciBhIHN1YnNjcmliZXIgcmVjZWl2ZXMgYSBtZXNzYWdlXG5iZWZvcmUgdGhlIHN1YnNjcmliZXIgc2hvdWxkIGFja25vd2xlZGdlIHRoZSBtZXNzYWdlLiBBZnRlciBtZXNzYWdlXG5kZWxpdmVyeSBidXQgYmVmb3JlIHRoZSBhY2sgZGVhZGxpbmUgZXhwaXJlcyBhbmQgYmVmb3JlIHRoZSBtZXNzYWdlIGlzXG5hY2tub3dsZWRnZWQsIGl0IGlzIGFuIG91dHN0YW5kaW5nIG1lc3NhZ2UgYW5kIHdpbGwgbm90IGJlIGRlbGl2ZXJlZFxuYWdhaW4gZHVyaW5nIHRoYXQgdGltZSAob24gYSBiZXN0LWVmZm9ydCBiYXNpcykuXG5cbkZvciBwdWxsIHN1YnNjcmlwdGlvbnMsIHRoaXMgdmFsdWUgaXMgdXNlZCBhcyB0aGUgaW5pdGlhbCB2YWx1ZSBmb3JcbnRoZSBhY2sgZGVhZGxpbmUuIFRvIG92ZXJyaWRlIHRoaXMgdmFsdWUgZm9yIGEgZ2l2ZW4gbWVzc2FnZSwgY2FsbFxuc3Vic2NyaXB0aW9ucy5tb2RpZnlBY2tEZWFkbGluZSB3aXRoIHRoZSBjb3JyZXNwb25kaW5nIGFja0lkIGlmIHVzaW5nXG5wdWxsLiBUaGUgbWluaW11bSBjdXN0b20gZGVhZGxpbmUgeW91IGNhbiBzcGVjaWZ5IGlzIDEwIHNlY29uZHMuIFRoZVxubWF4aW11bSBjdXN0b20gZGVhZGxpbmUgeW91IGNhbiBzcGVjaWZ5IGlzIDYwMCBzZWNvbmRzICgxMCBtaW51dGVzKS5cbklmIHRoaXMgcGFyYW1ldGVyIGlzIDAsIGEgZGVmYXVsdCB2YWx1ZSBvZiAxMCBzZWNvbmRzIGlzIHVzZWQuXG5cbkZvciBwdXNoIGRlbGl2ZXJ5LCB0aGlzIHZhbHVlIGlzIGFsc28gdXNlZCB0byBzZXQgdGhlIHJlcXVlc3QgdGltZW91dFxuZm9yIHRoZSBjYWxsIHRvIHRoZSBwdXNoIGVuZHBvaW50LlxuXG5JZiB0aGUgc3Vic2NyaWJlciBuZXZlciBhY2tub3dsZWRnZXMgdGhlIG1lc3NhZ2UsIHRoZSBQdWIvU3ViIHN5c3RlbVxud2lsbCBldmVudHVhbGx5IHJlZGVsaXZlciB0aGUgbWVzc2FnZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uI2Fja19kZWFkbGluZV9zZWNvbmRzIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNhY2tfZGVhZGxpbmVfc2Vjb25kc31cbiAgKi9cbiAgcmVhZG9ubHkgYWNrRGVhZGxpbmVTZWNvbmRzPzogbnVtYmVyO1xuICAvKipcbiAgKiBJZiAndHJ1ZScsIFB1Yi9TdWIgcHJvdmlkZXMgdGhlIGZvbGxvd2luZyBndWFyYW50ZWVzIGZvciB0aGUgZGVsaXZlcnlcbm9mIGEgbWVzc2FnZSB3aXRoIGEgZ2l2ZW4gdmFsdWUgb2YgbWVzc2FnZUlkIG9uIHRoaXMgU3Vic2NyaXB0aW9ucyc6XG5cbi0gVGhlIG1lc3NhZ2Ugc2VudCB0byBhIHN1YnNjcmliZXIgaXMgZ3VhcmFudGVlZCBub3QgdG8gYmUgcmVzZW50IGJlZm9yZSB0aGUgbWVzc2FnZSdzIGFja25vd2xlZGdlbWVudCBkZWFkbGluZSBleHBpcmVzLlxuXG4tIEFuIGFja25vd2xlZGdlZCBtZXNzYWdlIHdpbGwgbm90IGJlIHJlc2VudCB0byBhIHN1YnNjcmliZXIuXG5cbk5vdGUgdGhhdCBzdWJzY3JpYmVycyBtYXkgc3RpbGwgcmVjZWl2ZSBtdWx0aXBsZSBjb3BpZXMgb2YgYSBtZXNzYWdlIHdoZW4gJ2VuYWJsZV9leGFjdGx5X29uY2VfZGVsaXZlcnknXG5pcyB0cnVlIGlmIHRoZSBtZXNzYWdlIHdhcyBwdWJsaXNoZWQgbXVsdGlwbGUgdGltZXMgYnkgYSBwdWJsaXNoZXIgY2xpZW50LiBUaGVzZSBjb3BpZXMgYXJlIGNvbnNpZGVyZWQgZGlzdGluY3QgYnkgUHViL1N1YiBhbmQgaGF2ZSBkaXN0aW5jdCBtZXNzYWdlSWQgdmFsdWVzXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNlbmFibGVfZXhhY3RseV9vbmNlX2RlbGl2ZXJ5IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNlbmFibGVfZXhhY3RseV9vbmNlX2RlbGl2ZXJ5fVxuICAqL1xuICByZWFkb25seSBlbmFibGVFeGFjdGx5T25jZURlbGl2ZXJ5PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBJZiAndHJ1ZScsIG1lc3NhZ2VzIHB1Ymxpc2hlZCB3aXRoIHRoZSBzYW1lIG9yZGVyaW5nS2V5IGluIFB1YnN1Yk1lc3NhZ2Ugd2lsbCBiZSBkZWxpdmVyZWQgdG9cbnRoZSBzdWJzY3JpYmVycyBpbiB0aGUgb3JkZXIgaW4gd2hpY2ggdGhleSBhcmUgcmVjZWl2ZWQgYnkgdGhlIFB1Yi9TdWIgc3lzdGVtLiBPdGhlcndpc2UsIHRoZXlcbm1heSBiZSBkZWxpdmVyZWQgaW4gYW55IG9yZGVyLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jZW5hYmxlX21lc3NhZ2Vfb3JkZXJpbmcgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI2VuYWJsZV9tZXNzYWdlX29yZGVyaW5nfVxuICAqL1xuICByZWFkb25seSBlbmFibGVNZXNzYWdlT3JkZXJpbmc/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoZSBzdWJzY3JpcHRpb24gb25seSBkZWxpdmVycyB0aGUgbWVzc2FnZXMgdGhhdCBtYXRjaCB0aGUgZmlsdGVyLiBcblB1Yi9TdWIgYXV0b21hdGljYWxseSBhY2tub3dsZWRnZXMgdGhlIG1lc3NhZ2VzIHRoYXQgZG9uJ3QgbWF0Y2ggdGhlIGZpbHRlci4gWW91IGNhbiBmaWx0ZXIgbWVzc2FnZXNcbmJ5IHRoZWlyIGF0dHJpYnV0ZXMuIFRoZSBtYXhpbXVtIGxlbmd0aCBvZiBhIGZpbHRlciBpcyAyNTYgYnl0ZXMuIEFmdGVyIGNyZWF0aW5nIHRoZSBzdWJzY3JpcHRpb24sIFxueW91IGNhbid0IG1vZGlmeSB0aGUgZmlsdGVyLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jZmlsdGVyIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNmaWx0ZXJ9XG4gICovXG4gIHJlYWRvbmx5IGZpbHRlcj86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNpZCBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb24jaWR9XG4gICpcbiAgKiBQbGVhc2UgYmUgYXdhcmUgdGhhdCB0aGUgaWQgZmllbGQgaXMgYXV0b21hdGljYWxseSBhZGRlZCB0byBhbGwgcmVzb3VyY2VzIGluIFRlcnJhZm9ybSBwcm92aWRlcnMgdXNpbmcgYSBUZXJyYWZvcm0gcHJvdmlkZXIgU0RLIHZlcnNpb24gYmVsb3cgMi5cbiAgKiBJZiB5b3UgZXhwZXJpZW5jZSBwcm9ibGVtcyBzZXR0aW5nIHRoaXMgdmFsdWUgaXQgbWlnaHQgbm90IGJlIHNldHRhYmxlLiBQbGVhc2UgdGFrZSBhIGxvb2sgYXQgdGhlIHByb3ZpZGVyIGRvY3VtZW50YXRpb24gdG8gZW5zdXJlIGl0IHNob3VsZCBiZSBzZXR0YWJsZS5cbiAgKi9cbiAgcmVhZG9ubHkgaWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEEgc2V0IG9mIGtleS92YWx1ZSBsYWJlbCBwYWlycyB0byBhc3NpZ24gdG8gdGhpcyBTdWJzY3JpcHRpb24uXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNsYWJlbHMgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI2xhYmVsc31cbiAgKi9cbiAgcmVhZG9ubHkgbGFiZWxzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbiAgLyoqXG4gICogSG93IGxvbmcgdG8gcmV0YWluIHVuYWNrbm93bGVkZ2VkIG1lc3NhZ2VzIGluIHRoZSBzdWJzY3JpcHRpb24nc1xuYmFja2xvZywgZnJvbSB0aGUgbW9tZW50IGEgbWVzc2FnZSBpcyBwdWJsaXNoZWQuIElmXG5yZXRhaW5fYWNrZWRfbWVzc2FnZXMgaXMgdHJ1ZSwgdGhlbiB0aGlzIGFsc28gY29uZmlndXJlcyB0aGUgcmV0ZW50aW9uXG5vZiBhY2tub3dsZWRnZWQgbWVzc2FnZXMsIGFuZCB0aHVzIGNvbmZpZ3VyZXMgaG93IGZhciBiYWNrIGluIHRpbWUgYVxuc3Vic2NyaXB0aW9ucy5zZWVrIGNhbiBiZSBkb25lLiBEZWZhdWx0cyB0byA3IGRheXMuIENhbm5vdCBiZSBtb3JlXG50aGFuIDcgZGF5cyAoJ1wiNjA0ODAwc1wiJykgb3IgbGVzcyB0aGFuIDEwIG1pbnV0ZXMgKCdcIjYwMHNcIicpLlxuXG5BIGR1cmF0aW9uIGluIHNlY29uZHMgd2l0aCB1cCB0byBuaW5lIGZyYWN0aW9uYWwgZGlnaXRzLCB0ZXJtaW5hdGVkXG5ieSAncycuIEV4YW1wbGU6ICdcIjYwMC41c1wiJy5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uI21lc3NhZ2VfcmV0ZW50aW9uX2R1cmF0aW9uIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNtZXNzYWdlX3JldGVudGlvbl9kdXJhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgbWVzc2FnZVJldGVudGlvbkR1cmF0aW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBOYW1lIG9mIHRoZSBzdWJzY3JpcHRpb24uXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNuYW1lIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNuYW1lfVxuICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jcHJvamVjdCBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb24jcHJvamVjdH1cbiAgKi9cbiAgcmVhZG9ubHkgcHJvamVjdD86IHN0cmluZztcbiAgLyoqXG4gICogSW5kaWNhdGVzIHdoZXRoZXIgdG8gcmV0YWluIGFja25vd2xlZGdlZCBtZXNzYWdlcy4gSWYgJ3RydWUnLCB0aGVuXG5tZXNzYWdlcyBhcmUgbm90IGV4cHVuZ2VkIGZyb20gdGhlIHN1YnNjcmlwdGlvbidzIGJhY2tsb2csIGV2ZW4gaWZcbnRoZXkgYXJlIGFja25vd2xlZGdlZCwgdW50aWwgdGhleSBmYWxsIG91dCBvZiB0aGVcbm1lc3NhZ2VSZXRlbnRpb25EdXJhdGlvbiB3aW5kb3cuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNyZXRhaW5fYWNrZWRfbWVzc2FnZXMgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI3JldGFpbl9hY2tlZF9tZXNzYWdlc31cbiAgKi9cbiAgcmVhZG9ubHkgcmV0YWluQWNrZWRNZXNzYWdlcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogQSByZWZlcmVuY2UgdG8gYSBUb3BpYyByZXNvdXJjZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uI3RvcGljIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiN0b3BpY31cbiAgKi9cbiAgcmVhZG9ubHkgdG9waWM6IHN0cmluZztcbiAgLyoqXG4gICogYmlncXVlcnlfY29uZmlnIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNiaWdxdWVyeV9jb25maWcgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI2JpZ3F1ZXJ5X2NvbmZpZ31cbiAgKi9cbiAgcmVhZG9ubHkgYmlncXVlcnlDb25maWc/OiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25CaWdxdWVyeUNvbmZpZztcbiAgLyoqXG4gICogZGVhZF9sZXR0ZXJfcG9saWN5IGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNkZWFkX2xldHRlcl9wb2xpY3kgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI2RlYWRfbGV0dGVyX3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgZGVhZExldHRlclBvbGljeT86IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkRlYWRMZXR0ZXJQb2xpY3k7XG4gIC8qKlxuICAqIGV4cGlyYXRpb25fcG9saWN5IGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNleHBpcmF0aW9uX3BvbGljeSBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb24jZXhwaXJhdGlvbl9wb2xpY3l9XG4gICovXG4gIHJlYWRvbmx5IGV4cGlyYXRpb25Qb2xpY3k/OiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25FeHBpcmF0aW9uUG9saWN5O1xuICAvKipcbiAgKiBwdXNoX2NvbmZpZyBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jcHVzaF9jb25maWcgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI3B1c2hfY29uZmlnfVxuICAqL1xuICByZWFkb25seSBwdXNoQ29uZmlnPzogR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uUHVzaENvbmZpZztcbiAgLyoqXG4gICogcmV0cnlfcG9saWN5IGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNyZXRyeV9wb2xpY3kgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI3JldHJ5X3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgcmV0cnlQb2xpY3k/OiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25SZXRyeVBvbGljeTtcbiAgLyoqXG4gICogdGltZW91dHMgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uI3RpbWVvdXRzIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiN0aW1lb3V0c31cbiAgKi9cbiAgcmVhZG9ubHkgdGltZW91dHM/OiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25UaW1lb3V0cztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uQmlncXVlcnlDb25maWcge1xuICAvKipcbiAgKiBXaGVuIHRydWUgYW5kIHVzZVRvcGljU2NoZW1hIGlzIHRydWUsIGFueSBmaWVsZHMgdGhhdCBhcmUgYSBwYXJ0IG9mIHRoZSB0b3BpYyBzY2hlbWEgdGhhdCBhcmUgbm90IHBhcnQgb2YgdGhlIEJpZ1F1ZXJ5IHRhYmxlIHNjaGVtYSBhcmUgZHJvcHBlZCB3aGVuIHdyaXRpbmcgdG8gQmlnUXVlcnkuXG5PdGhlcndpc2UsIHRoZSBzY2hlbWFzIG11c3QgYmUga2VwdCBpbiBzeW5jIGFuZCBhbnkgbWVzc2FnZXMgd2l0aCBleHRyYSBmaWVsZHMgYXJlIG5vdCB3cml0dGVuIGFuZCByZW1haW4gaW4gdGhlIHN1YnNjcmlwdGlvbidzIGJhY2tsb2cuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNkcm9wX3Vua25vd25fZmllbGRzIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNkcm9wX3Vua25vd25fZmllbGRzfVxuICAqL1xuICByZWFkb25seSBkcm9wVW5rbm93bkZpZWxkcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogVGhlIG5hbWUgb2YgdGhlIHRhYmxlIHRvIHdoaWNoIHRvIHdyaXRlIGRhdGEsIG9mIHRoZSBmb3JtIHtwcm9qZWN0SWR9OntkYXRhc2V0SWR9Lnt0YWJsZUlkfVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jdGFibGUgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI3RhYmxlfVxuICAqL1xuICByZWFkb25seSB0YWJsZTogc3RyaW5nO1xuICAvKipcbiAgKiBXaGVuIHRydWUsIHVzZSB0aGUgdG9waWMncyBzY2hlbWEgYXMgdGhlIGNvbHVtbnMgdG8gd3JpdGUgdG8gaW4gQmlnUXVlcnksIGlmIGl0IGV4aXN0cy5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uI3VzZV90b3BpY19zY2hlbWEgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI3VzZV90b3BpY19zY2hlbWF9XG4gICovXG4gIHJlYWRvbmx5IHVzZVRvcGljU2NoZW1hPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBXaGVuIHRydWUsIHdyaXRlIHRoZSBzdWJzY3JpcHRpb24gbmFtZSwgbWVzc2FnZUlkLCBwdWJsaXNoVGltZSwgYXR0cmlidXRlcywgYW5kIG9yZGVyaW5nS2V5IHRvIGFkZGl0aW9uYWwgY29sdW1ucyBpbiB0aGUgdGFibGUuXG5UaGUgc3Vic2NyaXB0aW9uIG5hbWUsIG1lc3NhZ2VJZCwgYW5kIHB1Ymxpc2hUaW1lIGZpZWxkcyBhcmUgcHV0IGluIHRoZWlyIG93biBjb2x1bW5zIHdoaWxlIGFsbCBvdGhlciBtZXNzYWdlIHByb3BlcnRpZXMgKG90aGVyIHRoYW4gZGF0YSkgYXJlIHdyaXR0ZW4gdG8gYSBKU09OIG9iamVjdCBpbiB0aGUgYXR0cmlidXRlcyBjb2x1bW4uXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiN3cml0ZV9tZXRhZGF0YSBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb24jd3JpdGVfbWV0YWRhdGF9XG4gICovXG4gIHJlYWRvbmx5IHdyaXRlTWV0YWRhdGE/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnb29nbGVQdWJzdWJTdWJzY3JpcHRpb25CaWdxdWVyeUNvbmZpZ1RvVGVycmFmb3JtKHN0cnVjdD86IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkJpZ3F1ZXJ5Q29uZmlnT3V0cHV0UmVmZXJlbmNlIHwgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uQmlncXVlcnlDb25maWcpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgZHJvcF91bmtub3duX2ZpZWxkczogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuZHJvcFVua25vd25GaWVsZHMpLFxuICAgIHRhYmxlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnRhYmxlKSxcbiAgICB1c2VfdG9waWNfc2NoZW1hOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS51c2VUb3BpY1NjaGVtYSksXG4gICAgd3JpdGVfbWV0YWRhdGE6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLndyaXRlTWV0YWRhdGEpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25CaWdxdWVyeUNvbmZpZ091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uQmlncXVlcnlDb25maWcgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2Ryb3BVbmtub3duRmllbGRzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmRyb3BVbmtub3duRmllbGRzID0gdGhpcy5fZHJvcFVua25vd25GaWVsZHM7XG4gICAgfVxuICAgIGlmICh0aGlzLl90YWJsZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC50YWJsZSA9IHRoaXMuX3RhYmxlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fdXNlVG9waWNTY2hlbWEgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQudXNlVG9waWNTY2hlbWEgPSB0aGlzLl91c2VUb3BpY1NjaGVtYTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3dyaXRlTWV0YWRhdGEgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQud3JpdGVNZXRhZGF0YSA9IHRoaXMuX3dyaXRlTWV0YWRhdGE7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25CaWdxdWVyeUNvbmZpZyB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2Ryb3BVbmtub3duRmllbGRzID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fdGFibGUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl91c2VUb3BpY1NjaGVtYSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3dyaXRlTWV0YWRhdGEgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2Ryb3BVbmtub3duRmllbGRzID0gdmFsdWUuZHJvcFVua25vd25GaWVsZHM7XG4gICAgICB0aGlzLl90YWJsZSA9IHZhbHVlLnRhYmxlO1xuICAgICAgdGhpcy5fdXNlVG9waWNTY2hlbWEgPSB2YWx1ZS51c2VUb3BpY1NjaGVtYTtcbiAgICAgIHRoaXMuX3dyaXRlTWV0YWRhdGEgPSB2YWx1ZS53cml0ZU1ldGFkYXRhO1xuICAgIH1cbiAgfVxuXG4gIC8vIGRyb3BfdW5rbm93bl9maWVsZHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZHJvcFVua25vd25GaWVsZHM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGRyb3BVbmtub3duRmllbGRzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2Ryb3BfdW5rbm93bl9maWVsZHMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRyb3BVbmtub3duRmllbGRzKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9kcm9wVW5rbm93bkZpZWxkcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERyb3BVbmtub3duRmllbGRzKCkge1xuICAgIHRoaXMuX2Ryb3BVbmtub3duRmllbGRzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkcm9wVW5rbm93bkZpZWxkc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kcm9wVW5rbm93bkZpZWxkcztcbiAgfVxuXG4gIC8vIHRhYmxlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3RhYmxlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB0YWJsZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3RhYmxlJyk7XG4gIH1cbiAgcHVibGljIHNldCB0YWJsZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdGFibGUgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGFibGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGFibGU7XG4gIH1cblxuICAvLyB1c2VfdG9waWNfc2NoZW1hIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VzZVRvcGljU2NoZW1hPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCB1c2VUb3BpY1NjaGVtYSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCd1c2VfdG9waWNfc2NoZW1hJyk7XG4gIH1cbiAgcHVibGljIHNldCB1c2VUb3BpY1NjaGVtYSh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fdXNlVG9waWNTY2hlbWEgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVc2VUb3BpY1NjaGVtYSgpIHtcbiAgICB0aGlzLl91c2VUb3BpY1NjaGVtYSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdXNlVG9waWNTY2hlbWFJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlVG9waWNTY2hlbWE7XG4gIH1cblxuICAvLyB3cml0ZV9tZXRhZGF0YSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF93cml0ZU1ldGFkYXRhPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCB3cml0ZU1ldGFkYXRhKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3dyaXRlX21ldGFkYXRhJyk7XG4gIH1cbiAgcHVibGljIHNldCB3cml0ZU1ldGFkYXRhKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl93cml0ZU1ldGFkYXRhID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0V3JpdGVNZXRhZGF0YSgpIHtcbiAgICB0aGlzLl93cml0ZU1ldGFkYXRhID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB3cml0ZU1ldGFkYXRhSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3dyaXRlTWV0YWRhdGE7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uRGVhZExldHRlclBvbGljeSB7XG4gIC8qKlxuICAqIFRoZSBuYW1lIG9mIHRoZSB0b3BpYyB0byB3aGljaCBkZWFkIGxldHRlciBtZXNzYWdlcyBzaG91bGQgYmUgcHVibGlzaGVkLlxuRm9ybWF0IGlzICdwcm9qZWN0cy97cHJvamVjdH0vdG9waWNzL3t0b3BpY30nLlxuXG5UaGUgQ2xvdWQgUHViL1N1YiBzZXJ2aWNlIGFjY291bnQgYXNzb2NpYXRlZCB3aXRoIHRoZSBlbmNsb3Npbmcgc3Vic2NyaXB0aW9uJ3NcbnBhcmVudCBwcm9qZWN0IChpLmUuLCBcbnNlcnZpY2Ute3Byb2plY3RfbnVtYmVyfUBnY3Atc2EtcHVic3ViLmlhbS5nc2VydmljZWFjY291bnQuY29tKSBtdXN0IGhhdmVcbnBlcm1pc3Npb24gdG8gUHVibGlzaCgpIHRvIHRoaXMgdG9waWMuXG5cblRoZSBvcGVyYXRpb24gd2lsbCBmYWlsIGlmIHRoZSB0b3BpYyBkb2VzIG5vdCBleGlzdC5cblVzZXJzIHNob3VsZCBlbnN1cmUgdGhhdCB0aGVyZSBpcyBhIHN1YnNjcmlwdGlvbiBhdHRhY2hlZCB0byB0aGlzIHRvcGljXG5zaW5jZSBtZXNzYWdlcyBwdWJsaXNoZWQgdG8gYSB0b3BpYyB3aXRoIG5vIHN1YnNjcmlwdGlvbnMgYXJlIGxvc3QuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNkZWFkX2xldHRlcl90b3BpYyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb24jZGVhZF9sZXR0ZXJfdG9waWN9XG4gICovXG4gIHJlYWRvbmx5IGRlYWRMZXR0ZXJUb3BpYz86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIG1heGltdW0gbnVtYmVyIG9mIGRlbGl2ZXJ5IGF0dGVtcHRzIGZvciBhbnkgbWVzc2FnZS4gVGhlIHZhbHVlIG11c3QgYmVcbmJldHdlZW4gNSBhbmQgMTAwLlxuXG5UaGUgbnVtYmVyIG9mIGRlbGl2ZXJ5IGF0dGVtcHRzIGlzIGRlZmluZWQgYXMgMSArICh0aGUgc3VtIG9mIG51bWJlciBvZiBcbk5BQ0tzIGFuZCBudW1iZXIgb2YgdGltZXMgdGhlIGFja25vd2xlZGdlbWVudCBkZWFkbGluZSBoYXMgYmVlbiBleGNlZWRlZCBmb3IgdGhlIG1lc3NhZ2UpLlxuXG5BIE5BQ0sgaXMgYW55IGNhbGwgdG8gTW9kaWZ5QWNrRGVhZGxpbmUgd2l0aCBhIDAgZGVhZGxpbmUuIE5vdGUgdGhhdFxuY2xpZW50IGxpYnJhcmllcyBtYXkgYXV0b21hdGljYWxseSBleHRlbmQgYWNrX2RlYWRsaW5lcy5cblxuVGhpcyBmaWVsZCB3aWxsIGJlIGhvbm9yZWQgb24gYSBiZXN0IGVmZm9ydCBiYXNpcy5cblxuSWYgdGhpcyBwYXJhbWV0ZXIgaXMgMCwgYSBkZWZhdWx0IHZhbHVlIG9mIDUgaXMgdXNlZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uI21heF9kZWxpdmVyeV9hdHRlbXB0cyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb24jbWF4X2RlbGl2ZXJ5X2F0dGVtcHRzfVxuICAqL1xuICByZWFkb25seSBtYXhEZWxpdmVyeUF0dGVtcHRzPzogbnVtYmVyO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uRGVhZExldHRlclBvbGljeVRvVGVycmFmb3JtKHN0cnVjdD86IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkRlYWRMZXR0ZXJQb2xpY3lPdXRwdXRSZWZlcmVuY2UgfCBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25EZWFkTGV0dGVyUG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGRlYWRfbGV0dGVyX3RvcGljOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLmRlYWRMZXR0ZXJUb3BpYyksXG4gICAgbWF4X2RlbGl2ZXJ5X2F0dGVtcHRzOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLm1heERlbGl2ZXJ5QXR0ZW1wdHMpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25EZWFkTGV0dGVyUG9saWN5T3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25EZWFkTGV0dGVyUG9saWN5IHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9kZWFkTGV0dGVyVG9waWMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGVhZExldHRlclRvcGljID0gdGhpcy5fZGVhZExldHRlclRvcGljO1xuICAgIH1cbiAgICBpZiAodGhpcy5fbWF4RGVsaXZlcnlBdHRlbXB0cyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5tYXhEZWxpdmVyeUF0dGVtcHRzID0gdGhpcy5fbWF4RGVsaXZlcnlBdHRlbXB0cztcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkRlYWRMZXR0ZXJQb2xpY3kgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9kZWFkTGV0dGVyVG9waWMgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9tYXhEZWxpdmVyeUF0dGVtcHRzID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9kZWFkTGV0dGVyVG9waWMgPSB2YWx1ZS5kZWFkTGV0dGVyVG9waWM7XG4gICAgICB0aGlzLl9tYXhEZWxpdmVyeUF0dGVtcHRzID0gdmFsdWUubWF4RGVsaXZlcnlBdHRlbXB0cztcbiAgICB9XG4gIH1cblxuICAvLyBkZWFkX2xldHRlcl90b3BpYyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWFkTGV0dGVyVG9waWM/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRlYWRMZXR0ZXJUb3BpYygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2RlYWRfbGV0dGVyX3RvcGljJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZWFkTGV0dGVyVG9waWModmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2RlYWRMZXR0ZXJUb3BpYyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlYWRMZXR0ZXJUb3BpYygpIHtcbiAgICB0aGlzLl9kZWFkTGV0dGVyVG9waWMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlYWRMZXR0ZXJUb3BpY0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWFkTGV0dGVyVG9waWM7XG4gIH1cblxuICAvLyBtYXhfZGVsaXZlcnlfYXR0ZW1wdHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWF4RGVsaXZlcnlBdHRlbXB0cz86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgbWF4RGVsaXZlcnlBdHRlbXB0cygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ21heF9kZWxpdmVyeV9hdHRlbXB0cycpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWF4RGVsaXZlcnlBdHRlbXB0cyh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fbWF4RGVsaXZlcnlBdHRlbXB0cyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1heERlbGl2ZXJ5QXR0ZW1wdHMoKSB7XG4gICAgdGhpcy5fbWF4RGVsaXZlcnlBdHRlbXB0cyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWF4RGVsaXZlcnlBdHRlbXB0c0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tYXhEZWxpdmVyeUF0dGVtcHRzO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkV4cGlyYXRpb25Qb2xpY3kge1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIFwidGltZS10by1saXZlXCIgZHVyYXRpb24gZm9yIGFuIGFzc29jaWF0ZWQgcmVzb3VyY2UuIFRoZVxucmVzb3VyY2UgZXhwaXJlcyBpZiBpdCBpcyBub3QgYWN0aXZlIGZvciBhIHBlcmlvZCBvZiB0dGwuXG5JZiB0dGwgaXMgbm90IHNldCwgdGhlIGFzc29jaWF0ZWQgcmVzb3VyY2UgbmV2ZXIgZXhwaXJlcy5cbkEgZHVyYXRpb24gaW4gc2Vjb25kcyB3aXRoIHVwIHRvIG5pbmUgZnJhY3Rpb25hbCBkaWdpdHMsIHRlcm1pbmF0ZWQgYnkgJ3MnLlxuRXhhbXBsZSAtIFwiMy41c1wiLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jdHRsIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiN0dGx9XG4gICovXG4gIHJlYWRvbmx5IHR0bDogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uRXhwaXJhdGlvblBvbGljeVRvVGVycmFmb3JtKHN0cnVjdD86IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkV4cGlyYXRpb25Qb2xpY3lPdXRwdXRSZWZlcmVuY2UgfCBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25FeHBpcmF0aW9uUG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIHR0bDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS50dGwpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25FeHBpcmF0aW9uUG9saWN5T3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25FeHBpcmF0aW9uUG9saWN5IHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl90dGwgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQudHRsID0gdGhpcy5fdHRsO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uRXhwaXJhdGlvblBvbGljeSB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX3R0bCA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fdHRsID0gdmFsdWUudHRsO1xuICAgIH1cbiAgfVxuXG4gIC8vIHR0bCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF90dGw/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHR0bCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3R0bCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgdHRsKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl90dGwgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdHRsSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3R0bDtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnT2lkY1Rva2VuIHtcbiAgLyoqXG4gICogQXVkaWVuY2UgdG8gYmUgdXNlZCB3aGVuIGdlbmVyYXRpbmcgT0lEQyB0b2tlbi4gVGhlIGF1ZGllbmNlIGNsYWltXG5pZGVudGlmaWVzIHRoZSByZWNpcGllbnRzIHRoYXQgdGhlIEpXVCBpcyBpbnRlbmRlZCBmb3IuIFRoZSBhdWRpZW5jZVxudmFsdWUgaXMgYSBzaW5nbGUgY2FzZS1zZW5zaXRpdmUgc3RyaW5nLiBIYXZpbmcgbXVsdGlwbGUgdmFsdWVzIChhcnJheSlcbmZvciB0aGUgYXVkaWVuY2UgZmllbGQgaXMgbm90IHN1cHBvcnRlZC4gTW9yZSBpbmZvIGFib3V0IHRoZSBPSURDIEpXVFxudG9rZW4gYXVkaWVuY2UgaGVyZTogaHR0cHM6Ly90b29scy5pZXRmLm9yZy9odG1sL3JmYzc1MTkjc2VjdGlvbi00LjEuM1xuTm90ZTogaWYgbm90IHNwZWNpZmllZCwgdGhlIFB1c2ggZW5kcG9pbnQgVVJMIHdpbGwgYmUgdXNlZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uI2F1ZGllbmNlIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNhdWRpZW5jZX1cbiAgKi9cbiAgcmVhZG9ubHkgYXVkaWVuY2U/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNlcnZpY2UgYWNjb3VudCBlbWFpbCB0byBiZSB1c2VkIGZvciBnZW5lcmF0aW5nIHRoZSBPSURDIHRva2VuLlxuVGhlIGNhbGxlciAoZm9yIHN1YnNjcmlwdGlvbnMuY3JlYXRlLCBzdWJzY3JpcHRpb25zLnBhdGNoLCBhbmRcbnN1YnNjcmlwdGlvbnMubW9kaWZ5UHVzaENvbmZpZyBSUENzKSBtdXN0IGhhdmUgdGhlXG5pYW0uc2VydmljZUFjY291bnRzLmFjdEFzIHBlcm1pc3Npb24gZm9yIHRoZSBzZXJ2aWNlIGFjY291bnQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNzZXJ2aWNlX2FjY291bnRfZW1haWwgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI3NlcnZpY2VfYWNjb3VudF9lbWFpbH1cbiAgKi9cbiAgcmVhZG9ubHkgc2VydmljZUFjY291bnRFbWFpbDogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uUHVzaENvbmZpZ09pZGNUb2tlblRvVGVycmFmb3JtKHN0cnVjdD86IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblB1c2hDb25maWdPaWRjVG9rZW5PdXRwdXRSZWZlcmVuY2UgfCBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnT2lkY1Rva2VuKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGF1ZGllbmNlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLmF1ZGllbmNlKSxcbiAgICBzZXJ2aWNlX2FjY291bnRfZW1haWw6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuc2VydmljZUFjY291bnRFbWFpbCksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblB1c2hDb25maWdPaWRjVG9rZW5PdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblB1c2hDb25maWdPaWRjVG9rZW4gfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2F1ZGllbmNlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmF1ZGllbmNlID0gdGhpcy5fYXVkaWVuY2U7XG4gICAgfVxuICAgIGlmICh0aGlzLl9zZXJ2aWNlQWNjb3VudEVtYWlsICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnNlcnZpY2VBY2NvdW50RW1haWwgPSB0aGlzLl9zZXJ2aWNlQWNjb3VudEVtYWlsO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uUHVzaENvbmZpZ09pZGNUb2tlbiB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2F1ZGllbmNlID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fc2VydmljZUFjY291bnRFbWFpbCA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fYXVkaWVuY2UgPSB2YWx1ZS5hdWRpZW5jZTtcbiAgICAgIHRoaXMuX3NlcnZpY2VBY2NvdW50RW1haWwgPSB2YWx1ZS5zZXJ2aWNlQWNjb3VudEVtYWlsO1xuICAgIH1cbiAgfVxuXG4gIC8vIGF1ZGllbmNlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2F1ZGllbmNlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhdWRpZW5jZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2F1ZGllbmNlJyk7XG4gIH1cbiAgcHVibGljIHNldCBhdWRpZW5jZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fYXVkaWVuY2UgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBdWRpZW5jZSgpIHtcbiAgICB0aGlzLl9hdWRpZW5jZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYXVkaWVuY2VJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYXVkaWVuY2U7XG4gIH1cblxuICAvLyBzZXJ2aWNlX2FjY291bnRfZW1haWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfc2VydmljZUFjY291bnRFbWFpbD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgc2VydmljZUFjY291bnRFbWFpbCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3NlcnZpY2VfYWNjb3VudF9lbWFpbCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2VydmljZUFjY291bnRFbWFpbCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc2VydmljZUFjY291bnRFbWFpbCA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzZXJ2aWNlQWNjb3VudEVtYWlsSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NlcnZpY2VBY2NvdW50RW1haWw7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uUHVzaENvbmZpZyB7XG4gIC8qKlxuICAqIEVuZHBvaW50IGNvbmZpZ3VyYXRpb24gYXR0cmlidXRlcy5cblxuRXZlcnkgZW5kcG9pbnQgaGFzIGEgc2V0IG9mIEFQSSBzdXBwb3J0ZWQgYXR0cmlidXRlcyB0aGF0IGNhblxuYmUgdXNlZCB0byBjb250cm9sIGRpZmZlcmVudCBhc3BlY3RzIG9mIHRoZSBtZXNzYWdlIGRlbGl2ZXJ5LlxuXG5UaGUgY3VycmVudGx5IHN1cHBvcnRlZCBhdHRyaWJ1dGUgaXMgeC1nb29nLXZlcnNpb24sIHdoaWNoIHlvdVxuY2FuIHVzZSB0byBjaGFuZ2UgdGhlIGZvcm1hdCBvZiB0aGUgcHVzaGVkIG1lc3NhZ2UuIFRoaXNcbmF0dHJpYnV0ZSBpbmRpY2F0ZXMgdGhlIHZlcnNpb24gb2YgdGhlIGRhdGEgZXhwZWN0ZWQgYnlcbnRoZSBlbmRwb2ludC4gVGhpcyBjb250cm9scyB0aGUgc2hhcGUgb2YgdGhlIHB1c2hlZCBtZXNzYWdlXG4oaS5lLiwgaXRzIGZpZWxkcyBhbmQgbWV0YWRhdGEpLiBUaGUgZW5kcG9pbnQgdmVyc2lvbiBpc1xuYmFzZWQgb24gdGhlIHZlcnNpb24gb2YgdGhlIFB1Yi9TdWIgQVBJLlxuXG5JZiBub3QgcHJlc2VudCBkdXJpbmcgdGhlIHN1YnNjcmlwdGlvbnMuY3JlYXRlIGNhbGwsXG5pdCB3aWxsIGRlZmF1bHQgdG8gdGhlIHZlcnNpb24gb2YgdGhlIEFQSSB1c2VkIHRvIG1ha2VcbnN1Y2ggY2FsbC4gSWYgbm90IHByZXNlbnQgZHVyaW5nIGEgc3Vic2NyaXB0aW9ucy5tb2RpZnlQdXNoQ29uZmlnXG5jYWxsLCBpdHMgdmFsdWUgd2lsbCBub3QgYmUgY2hhbmdlZC4gc3Vic2NyaXB0aW9ucy5nZXRcbmNhbGxzIHdpbGwgYWx3YXlzIHJldHVybiBhIHZhbGlkIHZlcnNpb24sIGV2ZW4gaWYgdGhlXG5zdWJzY3JpcHRpb24gd2FzIGNyZWF0ZWQgd2l0aG91dCB0aGlzIGF0dHJpYnV0ZS5cblxuVGhlIHBvc3NpYmxlIHZhbHVlcyBmb3IgdGhpcyBhdHRyaWJ1dGUgYXJlOlxuXG4tIHYxYmV0YTE6IHVzZXMgdGhlIHB1c2ggZm9ybWF0IGRlZmluZWQgaW4gdGhlIHYxYmV0YTEgUHViL1N1YiBBUEkuXG4tIHYxIG9yIHYxYmV0YTI6IHVzZXMgdGhlIHB1c2ggZm9ybWF0IGRlZmluZWQgaW4gdGhlIHYxIFB1Yi9TdWIgQVBJLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jYXR0cmlidXRlcyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb24jYXR0cmlidXRlc31cbiAgKi9cbiAgcmVhZG9ubHkgYXR0cmlidXRlcz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG4gIC8qKlxuICAqIEEgVVJMIGxvY2F0aW5nIHRoZSBlbmRwb2ludCB0byB3aGljaCBtZXNzYWdlcyBzaG91bGQgYmUgcHVzaGVkLlxuRm9yIGV4YW1wbGUsIGEgV2ViaG9vayBlbmRwb2ludCBtaWdodCB1c2VcblwiaHR0cHM6Ly9leGFtcGxlLmNvbS9wdXNoXCIuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNwdXNoX2VuZHBvaW50IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNwdXNoX2VuZHBvaW50fVxuICAqL1xuICByZWFkb25seSBwdXNoRW5kcG9pbnQ6IHN0cmluZztcbiAgLyoqXG4gICogb2lkY190b2tlbiBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jb2lkY190b2tlbiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb24jb2lkY190b2tlbn1cbiAgKi9cbiAgcmVhZG9ubHkgb2lkY1Rva2VuPzogR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uUHVzaENvbmZpZ09pZGNUb2tlbjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblB1c2hDb25maWdUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnT3V0cHV0UmVmZXJlbmNlIHwgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uUHVzaENvbmZpZyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBhdHRyaWJ1dGVzOiBjZGt0Zi5oYXNoTWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKShzdHJ1Y3QhLmF0dHJpYnV0ZXMpLFxuICAgIHB1c2hfZW5kcG9pbnQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucHVzaEVuZHBvaW50KSxcbiAgICBvaWRjX3Rva2VuOiBnb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnT2lkY1Rva2VuVG9UZXJyYWZvcm0oc3RydWN0IS5vaWRjVG9rZW4pLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9hdHRyaWJ1dGVzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmF0dHJpYnV0ZXMgPSB0aGlzLl9hdHRyaWJ1dGVzO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcHVzaEVuZHBvaW50ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnB1c2hFbmRwb2ludCA9IHRoaXMuX3B1c2hFbmRwb2ludDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX29pZGNUb2tlbj8uaW50ZXJuYWxWYWx1ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5vaWRjVG9rZW4gPSB0aGlzLl9vaWRjVG9rZW4/LmludGVybmFsVmFsdWU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fYXR0cmlidXRlcyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3B1c2hFbmRwb2ludCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX29pZGNUb2tlbi5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9hdHRyaWJ1dGVzID0gdmFsdWUuYXR0cmlidXRlcztcbiAgICAgIHRoaXMuX3B1c2hFbmRwb2ludCA9IHZhbHVlLnB1c2hFbmRwb2ludDtcbiAgICAgIHRoaXMuX29pZGNUb2tlbi5pbnRlcm5hbFZhbHVlID0gdmFsdWUub2lkY1Rva2VuO1xuICAgIH1cbiAgfVxuXG4gIC8vIGF0dHJpYnV0ZXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYXR0cmlidXRlcz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07IFxuICBwdWJsaWMgZ2V0IGF0dHJpYnV0ZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nTWFwQXR0cmlidXRlKCdhdHRyaWJ1dGVzJyk7XG4gIH1cbiAgcHVibGljIHNldCBhdHRyaWJ1dGVzKHZhbHVlOiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9KSB7XG4gICAgdGhpcy5fYXR0cmlidXRlcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEF0dHJpYnV0ZXMoKSB7XG4gICAgdGhpcy5fYXR0cmlidXRlcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYXR0cmlidXRlc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9hdHRyaWJ1dGVzO1xuICB9XG5cbiAgLy8gcHVzaF9lbmRwb2ludCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9wdXNoRW5kcG9pbnQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHB1c2hFbmRwb2ludCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3B1c2hfZW5kcG9pbnQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHB1c2hFbmRwb2ludCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcHVzaEVuZHBvaW50ID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHB1c2hFbmRwb2ludElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wdXNoRW5kcG9pbnQ7XG4gIH1cblxuICAvLyBvaWRjX3Rva2VuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX29pZGNUb2tlbiA9IG5ldyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnT2lkY1Rva2VuT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwib2lkY190b2tlblwiKTtcbiAgcHVibGljIGdldCBvaWRjVG9rZW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuX29pZGNUb2tlbjtcbiAgfVxuICBwdWJsaWMgcHV0T2lkY1Rva2VuKHZhbHVlOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnT2lkY1Rva2VuKSB7XG4gICAgdGhpcy5fb2lkY1Rva2VuLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRPaWRjVG9rZW4oKSB7XG4gICAgdGhpcy5fb2lkY1Rva2VuLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG9pZGNUb2tlbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9vaWRjVG9rZW4uaW50ZXJuYWxWYWx1ZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25SZXRyeVBvbGljeSB7XG4gIC8qKlxuICAqIFRoZSBtYXhpbXVtIGRlbGF5IGJldHdlZW4gY29uc2VjdXRpdmUgZGVsaXZlcmllcyBvZiBhIGdpdmVuIG1lc3NhZ2UuIFZhbHVlIHNob3VsZCBiZSBiZXR3ZWVuIDAgYW5kIDYwMCBzZWNvbmRzLiBEZWZhdWx0cyB0byA2MDAgc2Vjb25kcy4gXG5BIGR1cmF0aW9uIGluIHNlY29uZHMgd2l0aCB1cCB0byBuaW5lIGZyYWN0aW9uYWwgZGlnaXRzLCB0ZXJtaW5hdGVkIGJ5ICdzJy4gRXhhbXBsZTogXCIzLjVzXCIuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNtYXhpbXVtX2JhY2tvZmYgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI21heGltdW1fYmFja29mZn1cbiAgKi9cbiAgcmVhZG9ubHkgbWF4aW11bUJhY2tvZmY/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBtaW5pbXVtIGRlbGF5IGJldHdlZW4gY29uc2VjdXRpdmUgZGVsaXZlcmllcyBvZiBhIGdpdmVuIG1lc3NhZ2UuIFZhbHVlIHNob3VsZCBiZSBiZXR3ZWVuIDAgYW5kIDYwMCBzZWNvbmRzLiBEZWZhdWx0cyB0byAxMCBzZWNvbmRzLlxuQSBkdXJhdGlvbiBpbiBzZWNvbmRzIHdpdGggdXAgdG8gbmluZSBmcmFjdGlvbmFsIGRpZ2l0cywgdGVybWluYXRlZCBieSAncycuIEV4YW1wbGU6IFwiMy41c1wiLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jbWluaW11bV9iYWNrb2ZmIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNtaW5pbXVtX2JhY2tvZmZ9XG4gICovXG4gIHJlYWRvbmx5IG1pbmltdW1CYWNrb2ZmPzogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZ29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uUmV0cnlQb2xpY3lUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25SZXRyeVBvbGljeU91dHB1dFJlZmVyZW5jZSB8IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblJldHJ5UG9saWN5KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIG1heGltdW1fYmFja29mZjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5tYXhpbXVtQmFja29mZiksXG4gICAgbWluaW11bV9iYWNrb2ZmOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLm1pbmltdW1CYWNrb2ZmKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uUmV0cnlQb2xpY3lPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblJldHJ5UG9saWN5IHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9tYXhpbXVtQmFja29mZiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5tYXhpbXVtQmFja29mZiA9IHRoaXMuX21heGltdW1CYWNrb2ZmO1xuICAgIH1cbiAgICBpZiAodGhpcy5fbWluaW11bUJhY2tvZmYgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQubWluaW11bUJhY2tvZmYgPSB0aGlzLl9taW5pbXVtQmFja29mZjtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblJldHJ5UG9saWN5IHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fbWF4aW11bUJhY2tvZmYgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9taW5pbXVtQmFja29mZiA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fbWF4aW11bUJhY2tvZmYgPSB2YWx1ZS5tYXhpbXVtQmFja29mZjtcbiAgICAgIHRoaXMuX21pbmltdW1CYWNrb2ZmID0gdmFsdWUubWluaW11bUJhY2tvZmY7XG4gICAgfVxuICB9XG5cbiAgLy8gbWF4aW11bV9iYWNrb2ZmIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWF4aW11bUJhY2tvZmY/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG1heGltdW1CYWNrb2ZmKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbWF4aW11bV9iYWNrb2ZmJyk7XG4gIH1cbiAgcHVibGljIHNldCBtYXhpbXVtQmFja29mZih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbWF4aW11bUJhY2tvZmYgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNYXhpbXVtQmFja29mZigpIHtcbiAgICB0aGlzLl9tYXhpbXVtQmFja29mZiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWF4aW11bUJhY2tvZmZJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWF4aW11bUJhY2tvZmY7XG4gIH1cblxuICAvLyBtaW5pbXVtX2JhY2tvZmYgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9taW5pbXVtQmFja29mZj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbWluaW11bUJhY2tvZmYoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtaW5pbXVtX2JhY2tvZmYnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1pbmltdW1CYWNrb2ZmKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9taW5pbXVtQmFja29mZiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1pbmltdW1CYWNrb2ZmKCkge1xuICAgIHRoaXMuX21pbmltdW1CYWNrb2ZmID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtaW5pbXVtQmFja29mZklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9taW5pbXVtQmFja29mZjtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25UaW1lb3V0cyB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS1iZXRhL3IvZ29vZ2xlX3B1YnN1Yl9zdWJzY3JpcHRpb24jY3JlYXRlIEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbiNjcmVhdGV9XG4gICovXG4gIHJlYWRvbmx5IGNyZWF0ZT86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiNkZWxldGUgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uI2RlbGV0ZX1cbiAgKi9cbiAgcmVhZG9ubHkgZGVsZXRlPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uI3VwZGF0ZSBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb24jdXBkYXRlfVxuICAqL1xuICByZWFkb25seSB1cGRhdGU/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnb29nbGVQdWJzdWJTdWJzY3JpcHRpb25UaW1lb3V0c1RvVGVycmFmb3JtKHN0cnVjdD86IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblRpbWVvdXRzT3V0cHV0UmVmZXJlbmNlIHwgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uVGltZW91dHMgfCBjZGt0Zi5JUmVzb2x2YWJsZSk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBjcmVhdGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuY3JlYXRlKSxcbiAgICBkZWxldGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuZGVsZXRlKSxcbiAgICB1cGRhdGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEudXBkYXRlKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uVGltZW91dHNPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gIHByaXZhdGUgcmVzb2x2YWJsZVZhbHVlPzogY2RrdGYuSVJlc29sdmFibGU7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblRpbWVvdXRzIHwgY2RrdGYuSVJlc29sdmFibGUgfCB1bmRlZmluZWQge1xuICAgIGlmICh0aGlzLnJlc29sdmFibGVWYWx1ZSkge1xuICAgICAgcmV0dXJuIHRoaXMucmVzb2x2YWJsZVZhbHVlO1xuICAgIH1cbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9jcmVhdGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY3JlYXRlID0gdGhpcy5fY3JlYXRlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fZGVsZXRlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmRlbGV0ZSA9IHRoaXMuX2RlbGV0ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3VwZGF0ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC51cGRhdGUgPSB0aGlzLl91cGRhdGU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25UaW1lb3V0cyB8IGNka3RmLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9jcmVhdGUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9kZWxldGUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl91cGRhdGUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2UgaWYgKGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUodmFsdWUpKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMucmVzb2x2YWJsZVZhbHVlID0gdmFsdWU7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMucmVzb2x2YWJsZVZhbHVlID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fY3JlYXRlID0gdmFsdWUuY3JlYXRlO1xuICAgICAgdGhpcy5fZGVsZXRlID0gdmFsdWUuZGVsZXRlO1xuICAgICAgdGhpcy5fdXBkYXRlID0gdmFsdWUudXBkYXRlO1xuICAgIH1cbiAgfVxuXG4gIC8vIGNyZWF0ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jcmVhdGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNyZWF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NyZWF0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgY3JlYXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jcmVhdGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDcmVhdGUoKSB7XG4gICAgdGhpcy5fY3JlYXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjcmVhdGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3JlYXRlO1xuICB9XG5cbiAgLy8gZGVsZXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbGV0ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZGVsZXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGVsZXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZWxldGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2RlbGV0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlbGV0ZSgpIHtcbiAgICB0aGlzLl9kZWxldGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlbGV0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWxldGU7XG4gIH1cblxuICAvLyB1cGRhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdXBkYXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB1cGRhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd1cGRhdGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHVwZGF0ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdXBkYXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VXBkYXRlKCkge1xuICAgIHRoaXMuX3VwZGF0ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdXBkYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3VwZGF0ZTtcbiAgfVxufVxuXG4vKipcbiogUmVwcmVzZW50cyBhIHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlLWJldGEvci9nb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbiBnb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbn1cbiovXG5leHBvcnQgY2xhc3MgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtUmVzb3VyY2Uge1xuXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIC8vIFNUQVRJQyBQUk9QRVJUSUVTXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgdGZSZXNvdXJjZVR5cGUgPSBcImdvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uXCI7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUtYmV0YS9yL2dvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9uIGdvb2dsZV9wdWJzdWJfc3Vic2NyaXB0aW9ufSBSZXNvdXJjZVxuICAqXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaWQgVGhlIHNjb3BlZCBjb25zdHJ1Y3QgSUQuIE11c3QgYmUgdW5pcXVlIGFtb25nc3Qgc2libGluZ3MgaW4gdGhlIHNhbWUgc2NvcGVcbiAgKiBAcGFyYW0gb3B0aW9ucyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25Db25maWdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdnb29nbGVfcHVic3ViX3N1YnNjcmlwdGlvbicsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICdnb29nbGUtYmV0YScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzQuMzguMCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICd+PiA0LjE3J1xuICAgICAgfSxcbiAgICAgIHByb3ZpZGVyOiBjb25maWcucHJvdmlkZXIsXG4gICAgICBkZXBlbmRzT246IGNvbmZpZy5kZXBlbmRzT24sXG4gICAgICBjb3VudDogY29uZmlnLmNvdW50LFxuICAgICAgbGlmZWN5Y2xlOiBjb25maWcubGlmZWN5Y2xlLFxuICAgICAgcHJvdmlzaW9uZXJzOiBjb25maWcucHJvdmlzaW9uZXJzLFxuICAgICAgY29ubmVjdGlvbjogY29uZmlnLmNvbm5lY3Rpb24sXG4gICAgICBmb3JFYWNoOiBjb25maWcuZm9yRWFjaFxuICAgIH0pO1xuICAgIHRoaXMuX2Fja0RlYWRsaW5lU2Vjb25kcyA9IGNvbmZpZy5hY2tEZWFkbGluZVNlY29uZHM7XG4gICAgdGhpcy5fZW5hYmxlRXhhY3RseU9uY2VEZWxpdmVyeSA9IGNvbmZpZy5lbmFibGVFeGFjdGx5T25jZURlbGl2ZXJ5O1xuICAgIHRoaXMuX2VuYWJsZU1lc3NhZ2VPcmRlcmluZyA9IGNvbmZpZy5lbmFibGVNZXNzYWdlT3JkZXJpbmc7XG4gICAgdGhpcy5fZmlsdGVyID0gY29uZmlnLmZpbHRlcjtcbiAgICB0aGlzLl9pZCA9IGNvbmZpZy5pZDtcbiAgICB0aGlzLl9sYWJlbHMgPSBjb25maWcubGFiZWxzO1xuICAgIHRoaXMuX21lc3NhZ2VSZXRlbnRpb25EdXJhdGlvbiA9IGNvbmZpZy5tZXNzYWdlUmV0ZW50aW9uRHVyYXRpb247XG4gICAgdGhpcy5fbmFtZSA9IGNvbmZpZy5uYW1lO1xuICAgIHRoaXMuX3Byb2plY3QgPSBjb25maWcucHJvamVjdDtcbiAgICB0aGlzLl9yZXRhaW5BY2tlZE1lc3NhZ2VzID0gY29uZmlnLnJldGFpbkFja2VkTWVzc2FnZXM7XG4gICAgdGhpcy5fdG9waWMgPSBjb25maWcudG9waWM7XG4gICAgdGhpcy5fYmlncXVlcnlDb25maWcuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5iaWdxdWVyeUNvbmZpZztcbiAgICB0aGlzLl9kZWFkTGV0dGVyUG9saWN5LmludGVybmFsVmFsdWUgPSBjb25maWcuZGVhZExldHRlclBvbGljeTtcbiAgICB0aGlzLl9leHBpcmF0aW9uUG9saWN5LmludGVybmFsVmFsdWUgPSBjb25maWcuZXhwaXJhdGlvblBvbGljeTtcbiAgICB0aGlzLl9wdXNoQ29uZmlnLmludGVybmFsVmFsdWUgPSBjb25maWcucHVzaENvbmZpZztcbiAgICB0aGlzLl9yZXRyeVBvbGljeS5pbnRlcm5hbFZhbHVlID0gY29uZmlnLnJldHJ5UG9saWN5O1xuICAgIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUgPSBjb25maWcudGltZW91dHM7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGFja19kZWFkbGluZV9zZWNvbmRzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYWNrRGVhZGxpbmVTZWNvbmRzPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBhY2tEZWFkbGluZVNlY29uZHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdhY2tfZGVhZGxpbmVfc2Vjb25kcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgYWNrRGVhZGxpbmVTZWNvbmRzKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9hY2tEZWFkbGluZVNlY29uZHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBY2tEZWFkbGluZVNlY29uZHMoKSB7XG4gICAgdGhpcy5fYWNrRGVhZGxpbmVTZWNvbmRzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhY2tEZWFkbGluZVNlY29uZHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWNrRGVhZGxpbmVTZWNvbmRzO1xuICB9XG5cbiAgLy8gZW5hYmxlX2V4YWN0bHlfb25jZV9kZWxpdmVyeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9lbmFibGVFeGFjdGx5T25jZURlbGl2ZXJ5PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBlbmFibGVFeGFjdGx5T25jZURlbGl2ZXJ5KCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2VuYWJsZV9leGFjdGx5X29uY2VfZGVsaXZlcnknKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVuYWJsZUV4YWN0bHlPbmNlRGVsaXZlcnkodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2VuYWJsZUV4YWN0bHlPbmNlRGVsaXZlcnkgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRFbmFibGVFeGFjdGx5T25jZURlbGl2ZXJ5KCkge1xuICAgIHRoaXMuX2VuYWJsZUV4YWN0bHlPbmNlRGVsaXZlcnkgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGVuYWJsZUV4YWN0bHlPbmNlRGVsaXZlcnlJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZW5hYmxlRXhhY3RseU9uY2VEZWxpdmVyeTtcbiAgfVxuXG4gIC8vIGVuYWJsZV9tZXNzYWdlX29yZGVyaW5nIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2VuYWJsZU1lc3NhZ2VPcmRlcmluZz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZW5hYmxlTWVzc2FnZU9yZGVyaW5nKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2VuYWJsZV9tZXNzYWdlX29yZGVyaW5nJyk7XG4gIH1cbiAgcHVibGljIHNldCBlbmFibGVNZXNzYWdlT3JkZXJpbmcodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2VuYWJsZU1lc3NhZ2VPcmRlcmluZyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEVuYWJsZU1lc3NhZ2VPcmRlcmluZygpIHtcbiAgICB0aGlzLl9lbmFibGVNZXNzYWdlT3JkZXJpbmcgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGVuYWJsZU1lc3NhZ2VPcmRlcmluZ0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9lbmFibGVNZXNzYWdlT3JkZXJpbmc7XG4gIH1cblxuICAvLyBmaWx0ZXIgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZmlsdGVyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBmaWx0ZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdmaWx0ZXInKTtcbiAgfVxuICBwdWJsaWMgc2V0IGZpbHRlcih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZmlsdGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RmlsdGVyKCkge1xuICAgIHRoaXMuX2ZpbHRlciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZmlsdGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2ZpbHRlcjtcbiAgfVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGlkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9pZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldElkKCkge1xuICAgIHRoaXMuX2lkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pZDtcbiAgfVxuXG4gIC8vIGxhYmVscyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9sYWJlbHM/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9OyBcbiAgcHVibGljIGdldCBsYWJlbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nTWFwQXR0cmlidXRlKCdsYWJlbHMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGxhYmVscyh2YWx1ZTogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfSkge1xuICAgIHRoaXMuX2xhYmVscyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldExhYmVscygpIHtcbiAgICB0aGlzLl9sYWJlbHMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGxhYmVsc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9sYWJlbHM7XG4gIH1cblxuICAvLyBtZXNzYWdlX3JldGVudGlvbl9kdXJhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tZXNzYWdlUmV0ZW50aW9uRHVyYXRpb24/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG1lc3NhZ2VSZXRlbnRpb25EdXJhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21lc3NhZ2VfcmV0ZW50aW9uX2R1cmF0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBtZXNzYWdlUmV0ZW50aW9uRHVyYXRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX21lc3NhZ2VSZXRlbnRpb25EdXJhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1lc3NhZ2VSZXRlbnRpb25EdXJhdGlvbigpIHtcbiAgICB0aGlzLl9tZXNzYWdlUmV0ZW50aW9uRHVyYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG1lc3NhZ2VSZXRlbnRpb25EdXJhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tZXNzYWdlUmV0ZW50aW9uRHVyYXRpb247XG4gIH1cblxuICAvLyBuYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX25hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCduYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9uYW1lID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbmFtZTtcbiAgfVxuXG4gIC8vIHByb2plY3QgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wcm9qZWN0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwcm9qZWN0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncHJvamVjdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHJvamVjdCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcHJvamVjdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFByb2plY3QoKSB7XG4gICAgdGhpcy5fcHJvamVjdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJvamVjdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wcm9qZWN0O1xuICB9XG5cbiAgLy8gcmV0YWluX2Fja2VkX21lc3NhZ2VzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JldGFpbkFja2VkTWVzc2FnZXM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHJldGFpbkFja2VkTWVzc2FnZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgncmV0YWluX2Fja2VkX21lc3NhZ2VzJyk7XG4gIH1cbiAgcHVibGljIHNldCByZXRhaW5BY2tlZE1lc3NhZ2VzKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9yZXRhaW5BY2tlZE1lc3NhZ2VzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmV0YWluQWNrZWRNZXNzYWdlcygpIHtcbiAgICB0aGlzLl9yZXRhaW5BY2tlZE1lc3NhZ2VzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXRhaW5BY2tlZE1lc3NhZ2VzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JldGFpbkFja2VkTWVzc2FnZXM7XG4gIH1cblxuICAvLyB0b3BpYyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF90b3BpYz86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdG9waWMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd0b3BpYycpO1xuICB9XG4gIHB1YmxpYyBzZXQgdG9waWModmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3RvcGljID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRvcGljSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RvcGljO1xuICB9XG5cbiAgLy8gYmlncXVlcnlfY29uZmlnIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2JpZ3F1ZXJ5Q29uZmlnID0gbmV3IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkJpZ3F1ZXJ5Q29uZmlnT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwiYmlncXVlcnlfY29uZmlnXCIpO1xuICBwdWJsaWMgZ2V0IGJpZ3F1ZXJ5Q29uZmlnKCkge1xuICAgIHJldHVybiB0aGlzLl9iaWdxdWVyeUNvbmZpZztcbiAgfVxuICBwdWJsaWMgcHV0QmlncXVlcnlDb25maWcodmFsdWU6IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkJpZ3F1ZXJ5Q29uZmlnKSB7XG4gICAgdGhpcy5fYmlncXVlcnlDb25maWcuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEJpZ3F1ZXJ5Q29uZmlnKCkge1xuICAgIHRoaXMuX2JpZ3F1ZXJ5Q29uZmlnLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJpZ3F1ZXJ5Q29uZmlnSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2JpZ3F1ZXJ5Q29uZmlnLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyBkZWFkX2xldHRlcl9wb2xpY3kgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVhZExldHRlclBvbGljeSA9IG5ldyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25EZWFkTGV0dGVyUG9saWN5T3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwiZGVhZF9sZXR0ZXJfcG9saWN5XCIpO1xuICBwdWJsaWMgZ2V0IGRlYWRMZXR0ZXJQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlYWRMZXR0ZXJQb2xpY3k7XG4gIH1cbiAgcHVibGljIHB1dERlYWRMZXR0ZXJQb2xpY3kodmFsdWU6IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkRlYWRMZXR0ZXJQb2xpY3kpIHtcbiAgICB0aGlzLl9kZWFkTGV0dGVyUG9saWN5LmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWFkTGV0dGVyUG9saWN5KCkge1xuICAgIHRoaXMuX2RlYWRMZXR0ZXJQb2xpY3kuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVhZExldHRlclBvbGljeUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWFkTGV0dGVyUG9saWN5LmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyBleHBpcmF0aW9uX3BvbGljeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9leHBpcmF0aW9uUG9saWN5ID0gbmV3IEdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkV4cGlyYXRpb25Qb2xpY3lPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJleHBpcmF0aW9uX3BvbGljeVwiKTtcbiAgcHVibGljIGdldCBleHBpcmF0aW9uUG9saWN5KCkge1xuICAgIHJldHVybiB0aGlzLl9leHBpcmF0aW9uUG9saWN5O1xuICB9XG4gIHB1YmxpYyBwdXRFeHBpcmF0aW9uUG9saWN5KHZhbHVlOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25FeHBpcmF0aW9uUG9saWN5KSB7XG4gICAgdGhpcy5fZXhwaXJhdGlvblBvbGljeS5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RXhwaXJhdGlvblBvbGljeSgpIHtcbiAgICB0aGlzLl9leHBpcmF0aW9uUG9saWN5LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGV4cGlyYXRpb25Qb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZXhwaXJhdGlvblBvbGljeS5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gcHVzaF9jb25maWcgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcHVzaENvbmZpZyA9IG5ldyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25QdXNoQ29uZmlnT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwicHVzaF9jb25maWdcIik7XG4gIHB1YmxpYyBnZXQgcHVzaENvbmZpZygpIHtcbiAgICByZXR1cm4gdGhpcy5fcHVzaENvbmZpZztcbiAgfVxuICBwdWJsaWMgcHV0UHVzaENvbmZpZyh2YWx1ZTogR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uUHVzaENvbmZpZykge1xuICAgIHRoaXMuX3B1c2hDb25maWcuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFB1c2hDb25maWcoKSB7XG4gICAgdGhpcy5fcHVzaENvbmZpZy5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwdXNoQ29uZmlnSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3B1c2hDb25maWcuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIHJldHJ5X3BvbGljeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZXRyeVBvbGljeSA9IG5ldyBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25SZXRyeVBvbGljeU91dHB1dFJlZmVyZW5jZSh0aGlzLCBcInJldHJ5X3BvbGljeVwiKTtcbiAgcHVibGljIGdldCByZXRyeVBvbGljeSgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmV0cnlQb2xpY3k7XG4gIH1cbiAgcHVibGljIHB1dFJldHJ5UG9saWN5KHZhbHVlOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25SZXRyeVBvbGljeSkge1xuICAgIHRoaXMuX3JldHJ5UG9saWN5LmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSZXRyeVBvbGljeSgpIHtcbiAgICB0aGlzLl9yZXRyeVBvbGljeS5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXRyeVBvbGljeUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXRyeVBvbGljeS5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gdGltZW91dHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGltZW91dHMgPSBuZXcgR29vZ2xlUHVic3ViU3Vic2NyaXB0aW9uVGltZW91dHNPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJ0aW1lb3V0c1wiKTtcbiAgcHVibGljIGdldCB0aW1lb3V0cygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHM7XG4gIH1cbiAgcHVibGljIHB1dFRpbWVvdXRzKHZhbHVlOiBHb29nbGVQdWJzdWJTdWJzY3JpcHRpb25UaW1lb3V0cykge1xuICAgIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUaW1lb3V0cygpIHtcbiAgICB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0aW1lb3V0c0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBhY2tfZGVhZGxpbmVfc2Vjb25kczogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fYWNrRGVhZGxpbmVTZWNvbmRzKSxcbiAgICAgIGVuYWJsZV9leGFjdGx5X29uY2VfZGVsaXZlcnk6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9lbmFibGVFeGFjdGx5T25jZURlbGl2ZXJ5KSxcbiAgICAgIGVuYWJsZV9tZXNzYWdlX29yZGVyaW5nOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fZW5hYmxlTWVzc2FnZU9yZGVyaW5nKSxcbiAgICAgIGZpbHRlcjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fZmlsdGVyKSxcbiAgICAgIGlkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9pZCksXG4gICAgICBsYWJlbHM6IGNka3RmLmhhc2hNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0pKHRoaXMuX2xhYmVscyksXG4gICAgICBtZXNzYWdlX3JldGVudGlvbl9kdXJhdGlvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbWVzc2FnZVJldGVudGlvbkR1cmF0aW9uKSxcbiAgICAgIG5hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX25hbWUpLFxuICAgICAgcHJvamVjdDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fcHJvamVjdCksXG4gICAgICByZXRhaW5fYWNrZWRfbWVzc2FnZXM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9yZXRhaW5BY2tlZE1lc3NhZ2VzKSxcbiAgICAgIHRvcGljOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl90b3BpYyksXG4gICAgICBiaWdxdWVyeV9jb25maWc6IGdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkJpZ3F1ZXJ5Q29uZmlnVG9UZXJyYWZvcm0odGhpcy5fYmlncXVlcnlDb25maWcuaW50ZXJuYWxWYWx1ZSksXG4gICAgICBkZWFkX2xldHRlcl9wb2xpY3k6IGdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkRlYWRMZXR0ZXJQb2xpY3lUb1RlcnJhZm9ybSh0aGlzLl9kZWFkTGV0dGVyUG9saWN5LmludGVybmFsVmFsdWUpLFxuICAgICAgZXhwaXJhdGlvbl9wb2xpY3k6IGdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvbkV4cGlyYXRpb25Qb2xpY3lUb1RlcnJhZm9ybSh0aGlzLl9leHBpcmF0aW9uUG9saWN5LmludGVybmFsVmFsdWUpLFxuICAgICAgcHVzaF9jb25maWc6IGdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblB1c2hDb25maWdUb1RlcnJhZm9ybSh0aGlzLl9wdXNoQ29uZmlnLmludGVybmFsVmFsdWUpLFxuICAgICAgcmV0cnlfcG9saWN5OiBnb29nbGVQdWJzdWJTdWJzY3JpcHRpb25SZXRyeVBvbGljeVRvVGVycmFmb3JtKHRoaXMuX3JldHJ5UG9saWN5LmludGVybmFsVmFsdWUpLFxuICAgICAgdGltZW91dHM6IGdvb2dsZVB1YnN1YlN1YnNjcmlwdGlvblRpbWVvdXRzVG9UZXJyYWZvcm0odGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSksXG4gICAgfTtcbiAgfVxufVxuIl19