import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleRecaptchaEnterpriseKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human-readable display name of this key. Modifiable by user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#display_name GoogleRecaptchaEnterpriseKey#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#id GoogleRecaptchaEnterpriseKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#labels GoogleRecaptchaEnterpriseKey#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#project GoogleRecaptchaEnterpriseKey#project}
    */
    readonly project?: string;
    /**
    * android_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#android_settings GoogleRecaptchaEnterpriseKey#android_settings}
    */
    readonly androidSettings?: GoogleRecaptchaEnterpriseKeyAndroidSettings;
    /**
    * ios_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#ios_settings GoogleRecaptchaEnterpriseKey#ios_settings}
    */
    readonly iosSettings?: GoogleRecaptchaEnterpriseKeyIosSettings;
    /**
    * testing_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#testing_options GoogleRecaptchaEnterpriseKey#testing_options}
    */
    readonly testingOptions?: GoogleRecaptchaEnterpriseKeyTestingOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#timeouts GoogleRecaptchaEnterpriseKey#timeouts}
    */
    readonly timeouts?: GoogleRecaptchaEnterpriseKeyTimeouts;
    /**
    * web_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#web_settings GoogleRecaptchaEnterpriseKey#web_settings}
    */
    readonly webSettings?: GoogleRecaptchaEnterpriseKeyWebSettings;
}
export interface GoogleRecaptchaEnterpriseKeyAndroidSettings {
    /**
    * If set to true, it means allowed_package_names will not be enforced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#allow_all_package_names GoogleRecaptchaEnterpriseKey#allow_all_package_names}
    */
    readonly allowAllPackageNames?: boolean | cdktf.IResolvable;
    /**
    * Android package names of apps allowed to use the key. Example: 'com.companyname.appname'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#allowed_package_names GoogleRecaptchaEnterpriseKey#allowed_package_names}
    */
    readonly allowedPackageNames?: string[];
}
export declare function googleRecaptchaEnterpriseKeyAndroidSettingsToTerraform(struct?: GoogleRecaptchaEnterpriseKeyAndroidSettingsOutputReference | GoogleRecaptchaEnterpriseKeyAndroidSettings): any;
export declare class GoogleRecaptchaEnterpriseKeyAndroidSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRecaptchaEnterpriseKeyAndroidSettings | undefined;
    set internalValue(value: GoogleRecaptchaEnterpriseKeyAndroidSettings | undefined);
    private _allowAllPackageNames?;
    get allowAllPackageNames(): boolean | cdktf.IResolvable;
    set allowAllPackageNames(value: boolean | cdktf.IResolvable);
    resetAllowAllPackageNames(): void;
    get allowAllPackageNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedPackageNames?;
    get allowedPackageNames(): string[];
    set allowedPackageNames(value: string[]);
    resetAllowedPackageNames(): void;
    get allowedPackageNamesInput(): string[] | undefined;
}
export interface GoogleRecaptchaEnterpriseKeyIosSettings {
    /**
    * If set to true, it means allowed_bundle_ids will not be enforced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#allow_all_bundle_ids GoogleRecaptchaEnterpriseKey#allow_all_bundle_ids}
    */
    readonly allowAllBundleIds?: boolean | cdktf.IResolvable;
    /**
    * iOS bundle ids of apps allowed to use the key. Example: 'com.companyname.productname.appname'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#allowed_bundle_ids GoogleRecaptchaEnterpriseKey#allowed_bundle_ids}
    */
    readonly allowedBundleIds?: string[];
}
export declare function googleRecaptchaEnterpriseKeyIosSettingsToTerraform(struct?: GoogleRecaptchaEnterpriseKeyIosSettingsOutputReference | GoogleRecaptchaEnterpriseKeyIosSettings): any;
export declare class GoogleRecaptchaEnterpriseKeyIosSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRecaptchaEnterpriseKeyIosSettings | undefined;
    set internalValue(value: GoogleRecaptchaEnterpriseKeyIosSettings | undefined);
    private _allowAllBundleIds?;
    get allowAllBundleIds(): boolean | cdktf.IResolvable;
    set allowAllBundleIds(value: boolean | cdktf.IResolvable);
    resetAllowAllBundleIds(): void;
    get allowAllBundleIdsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedBundleIds?;
    get allowedBundleIds(): string[];
    set allowedBundleIds(value: string[]);
    resetAllowedBundleIds(): void;
    get allowedBundleIdsInput(): string[] | undefined;
}
export interface GoogleRecaptchaEnterpriseKeyTestingOptions {
    /**
    * For challenge-based keys only (CHECKBOX, INVISIBLE), all challenge requests for this site will return nocaptcha if NOCAPTCHA, or an unsolvable challenge if UNSOLVABLE_CHALLENGE. Possible values: TESTING_CHALLENGE_UNSPECIFIED, NOCAPTCHA, UNSOLVABLE_CHALLENGE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#testing_challenge GoogleRecaptchaEnterpriseKey#testing_challenge}
    */
    readonly testingChallenge?: string;
    /**
    * All assessments for this Key will return this score. Must be between 0 (likely not legitimate) and 1 (likely legitimate) inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#testing_score GoogleRecaptchaEnterpriseKey#testing_score}
    */
    readonly testingScore?: number;
}
export declare function googleRecaptchaEnterpriseKeyTestingOptionsToTerraform(struct?: GoogleRecaptchaEnterpriseKeyTestingOptionsOutputReference | GoogleRecaptchaEnterpriseKeyTestingOptions): any;
export declare class GoogleRecaptchaEnterpriseKeyTestingOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRecaptchaEnterpriseKeyTestingOptions | undefined;
    set internalValue(value: GoogleRecaptchaEnterpriseKeyTestingOptions | undefined);
    private _testingChallenge?;
    get testingChallenge(): string;
    set testingChallenge(value: string);
    resetTestingChallenge(): void;
    get testingChallengeInput(): string | undefined;
    private _testingScore?;
    get testingScore(): number;
    set testingScore(value: number);
    resetTestingScore(): void;
    get testingScoreInput(): number | undefined;
}
export interface GoogleRecaptchaEnterpriseKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#create GoogleRecaptchaEnterpriseKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#delete GoogleRecaptchaEnterpriseKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#update GoogleRecaptchaEnterpriseKey#update}
    */
    readonly update?: string;
}
export declare function googleRecaptchaEnterpriseKeyTimeoutsToTerraform(struct?: GoogleRecaptchaEnterpriseKeyTimeoutsOutputReference | GoogleRecaptchaEnterpriseKeyTimeouts | cdktf.IResolvable): any;
export declare class GoogleRecaptchaEnterpriseKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRecaptchaEnterpriseKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleRecaptchaEnterpriseKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleRecaptchaEnterpriseKeyWebSettings {
    /**
    * If set to true, it means allowed_domains will not be enforced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#allow_all_domains GoogleRecaptchaEnterpriseKey#allow_all_domains}
    */
    readonly allowAllDomains?: boolean | cdktf.IResolvable;
    /**
    * If set to true, the key can be used on AMP (Accelerated Mobile Pages) websites. This is supported only for the SCORE integration type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#allow_amp_traffic GoogleRecaptchaEnterpriseKey#allow_amp_traffic}
    */
    readonly allowAmpTraffic?: boolean | cdktf.IResolvable;
    /**
    * Domains or subdomains of websites allowed to use the key. All subdomains of an allowed domain are automatically allowed. A valid domain requires a host and must not include any path, port, query or fragment. Examples: 'example.com' or 'subdomain.example.com'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#allowed_domains GoogleRecaptchaEnterpriseKey#allowed_domains}
    */
    readonly allowedDomains?: string[];
    /**
    * Settings for the frequency and difficulty at which this key triggers captcha challenges. This should only be specified for IntegrationTypes CHECKBOX and INVISIBLE. Possible values: CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED, USABILITY, BALANCE, SECURITY
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#challenge_security_preference GoogleRecaptchaEnterpriseKey#challenge_security_preference}
    */
    readonly challengeSecurityPreference?: string;
    /**
    * Required. Describes how this key is integrated with the website. Possible values: SCORE, CHECKBOX, INVISIBLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key#integration_type GoogleRecaptchaEnterpriseKey#integration_type}
    */
    readonly integrationType: string;
}
export declare function googleRecaptchaEnterpriseKeyWebSettingsToTerraform(struct?: GoogleRecaptchaEnterpriseKeyWebSettingsOutputReference | GoogleRecaptchaEnterpriseKeyWebSettings): any;
export declare class GoogleRecaptchaEnterpriseKeyWebSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRecaptchaEnterpriseKeyWebSettings | undefined;
    set internalValue(value: GoogleRecaptchaEnterpriseKeyWebSettings | undefined);
    private _allowAllDomains?;
    get allowAllDomains(): boolean | cdktf.IResolvable;
    set allowAllDomains(value: boolean | cdktf.IResolvable);
    resetAllowAllDomains(): void;
    get allowAllDomainsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowAmpTraffic?;
    get allowAmpTraffic(): boolean | cdktf.IResolvable;
    set allowAmpTraffic(value: boolean | cdktf.IResolvable);
    resetAllowAmpTraffic(): void;
    get allowAmpTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedDomains?;
    get allowedDomains(): string[];
    set allowedDomains(value: string[]);
    resetAllowedDomains(): void;
    get allowedDomainsInput(): string[] | undefined;
    private _challengeSecurityPreference?;
    get challengeSecurityPreference(): string;
    set challengeSecurityPreference(value: string);
    resetChallengeSecurityPreference(): void;
    get challengeSecurityPreferenceInput(): string | undefined;
    private _integrationType?;
    get integrationType(): string;
    set integrationType(value: string);
    get integrationTypeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key google_recaptcha_enterprise_key}
*/
export declare class GoogleRecaptchaEnterpriseKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_recaptcha_enterprise_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_recaptcha_enterprise_key google_recaptcha_enterprise_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleRecaptchaEnterpriseKeyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleRecaptchaEnterpriseKeyConfig);
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _androidSettings;
    get androidSettings(): GoogleRecaptchaEnterpriseKeyAndroidSettingsOutputReference;
    putAndroidSettings(value: GoogleRecaptchaEnterpriseKeyAndroidSettings): void;
    resetAndroidSettings(): void;
    get androidSettingsInput(): GoogleRecaptchaEnterpriseKeyAndroidSettings | undefined;
    private _iosSettings;
    get iosSettings(): GoogleRecaptchaEnterpriseKeyIosSettingsOutputReference;
    putIosSettings(value: GoogleRecaptchaEnterpriseKeyIosSettings): void;
    resetIosSettings(): void;
    get iosSettingsInput(): GoogleRecaptchaEnterpriseKeyIosSettings | undefined;
    private _testingOptions;
    get testingOptions(): GoogleRecaptchaEnterpriseKeyTestingOptionsOutputReference;
    putTestingOptions(value: GoogleRecaptchaEnterpriseKeyTestingOptions): void;
    resetTestingOptions(): void;
    get testingOptionsInput(): GoogleRecaptchaEnterpriseKeyTestingOptions | undefined;
    private _timeouts;
    get timeouts(): GoogleRecaptchaEnterpriseKeyTimeoutsOutputReference;
    putTimeouts(value: GoogleRecaptchaEnterpriseKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleRecaptchaEnterpriseKeyTimeouts | undefined;
    private _webSettings;
    get webSettings(): GoogleRecaptchaEnterpriseKeyWebSettingsOutputReference;
    putWebSettings(value: GoogleRecaptchaEnterpriseKeyWebSettings): void;
    resetWebSettings(): void;
    get webSettingsInput(): GoogleRecaptchaEnterpriseKeyWebSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
