import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleRuntimeconfigConfigIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding#config GoogleRuntimeconfigConfigIamBinding#config}
    */
    readonly config: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding#id GoogleRuntimeconfigConfigIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding#members GoogleRuntimeconfigConfigIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding#project GoogleRuntimeconfigConfigIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding#role GoogleRuntimeconfigConfigIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding#condition GoogleRuntimeconfigConfigIamBinding#condition}
    */
    readonly condition?: GoogleRuntimeconfigConfigIamBindingCondition;
}
export interface GoogleRuntimeconfigConfigIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding#description GoogleRuntimeconfigConfigIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding#expression GoogleRuntimeconfigConfigIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding#title GoogleRuntimeconfigConfigIamBinding#title}
    */
    readonly title: string;
}
export declare function googleRuntimeconfigConfigIamBindingConditionToTerraform(struct?: GoogleRuntimeconfigConfigIamBindingConditionOutputReference | GoogleRuntimeconfigConfigIamBindingCondition): any;
export declare class GoogleRuntimeconfigConfigIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleRuntimeconfigConfigIamBindingCondition | undefined;
    set internalValue(value: GoogleRuntimeconfigConfigIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding google_runtimeconfig_config_iam_binding}
*/
export declare class GoogleRuntimeconfigConfigIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_runtimeconfig_config_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_config_iam_binding google_runtimeconfig_config_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleRuntimeconfigConfigIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleRuntimeconfigConfigIamBindingConfig);
    private _config?;
    get config(): string;
    set config(value: string);
    get configInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleRuntimeconfigConfigIamBindingConditionOutputReference;
    putCondition(value: GoogleRuntimeconfigConfigIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleRuntimeconfigConfigIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
