import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleRuntimeconfigVariableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_variable#id GoogleRuntimeconfigVariable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the variable to manage. Note that variable names can be hierarchical using slashes (e.g. "prod-variables/hostname").
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_variable#name GoogleRuntimeconfigVariable#name}
    */
    readonly name: string;
    /**
    * The name of the RuntimeConfig resource containing this variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_variable#parent GoogleRuntimeconfigVariable#parent}
    */
    readonly parent: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_variable#project GoogleRuntimeconfigVariable#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_variable#text GoogleRuntimeconfigVariable#text}
    */
    readonly text?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_variable#value GoogleRuntimeconfigVariable#value}
    */
    readonly value?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_variable google_runtimeconfig_variable}
*/
export declare class GoogleRuntimeconfigVariable extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_runtimeconfig_variable";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_runtimeconfig_variable google_runtimeconfig_variable} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleRuntimeconfigVariableConfig
    */
    constructor(scope: Construct, id: string, config: GoogleRuntimeconfigVariableConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
    get updateTime(): string;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
