import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSccNotificationConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * This must be unique within the organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#config_id GoogleSccNotificationConfig#config_id}
    */
    readonly configId: string;
    /**
    * The description of the notification config (max of 1024 characters).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#description GoogleSccNotificationConfig#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#id GoogleSccNotificationConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The organization whose Cloud Security Command Center the Notification
  Config lives in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#organization GoogleSccNotificationConfig#organization}
    */
    readonly organization: string;
    /**
    * The Pub/Sub topic to send notifications to. Its format is
  "projects/[project_id]/topics/[topic]".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#pubsub_topic GoogleSccNotificationConfig#pubsub_topic}
    */
    readonly pubsubTopic: string;
    /**
    * streaming_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#streaming_config GoogleSccNotificationConfig#streaming_config}
    */
    readonly streamingConfig: GoogleSccNotificationConfigStreamingConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#timeouts GoogleSccNotificationConfig#timeouts}
    */
    readonly timeouts?: GoogleSccNotificationConfigTimeouts;
}
export interface GoogleSccNotificationConfigStreamingConfig {
    /**
    * Expression that defines the filter to apply across create/update
  events of assets or findings as specified by the event type. The
  expression is a list of zero or more restrictions combined via
  logical operators AND and OR. Parentheses are supported, and OR
  has higher precedence than AND.
  
  Restrictions have the form <field> <operator> <value> and may have
  a - character in front of them to indicate negation. The fields
  map to those defined in the corresponding resource.
  
  The supported operators are:
  
  * = for all value types.
  * >, <, >=, <= for integer values.
  * :, meaning substring matching, for strings.
  
  The supported value types are:
  
  * string literals in quotes.
  * integer literals without quotes.
  * boolean literals true and false without quotes.
  
  See
  [Filtering notifications](https://cloud.google.com/security-command-center/docs/how-to-api-filter-notifications)
  for information on how to write a filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#filter GoogleSccNotificationConfig#filter}
    */
    readonly filter: string;
}
export declare function googleSccNotificationConfigStreamingConfigToTerraform(struct?: GoogleSccNotificationConfigStreamingConfigOutputReference | GoogleSccNotificationConfigStreamingConfig): any;
export declare class GoogleSccNotificationConfigStreamingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccNotificationConfigStreamingConfig | undefined;
    set internalValue(value: GoogleSccNotificationConfigStreamingConfig | undefined);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
}
export interface GoogleSccNotificationConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#create GoogleSccNotificationConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#delete GoogleSccNotificationConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config#update GoogleSccNotificationConfig#update}
    */
    readonly update?: string;
}
export declare function googleSccNotificationConfigTimeoutsToTerraform(struct?: GoogleSccNotificationConfigTimeoutsOutputReference | GoogleSccNotificationConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleSccNotificationConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccNotificationConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSccNotificationConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config google_scc_notification_config}
*/
export declare class GoogleSccNotificationConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_scc_notification_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_scc_notification_config google_scc_notification_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSccNotificationConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSccNotificationConfigConfig);
    private _configId?;
    get configId(): string;
    set configId(value: string);
    get configIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
    get serviceAccount(): string;
    private _streamingConfig;
    get streamingConfig(): GoogleSccNotificationConfigStreamingConfigOutputReference;
    putStreamingConfig(value: GoogleSccNotificationConfigStreamingConfig): void;
    get streamingConfigInput(): GoogleSccNotificationConfigStreamingConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleSccNotificationConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleSccNotificationConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSccNotificationConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
