import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSecretManagerSecretIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member#id GoogleSecretManagerSecretIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member#member GoogleSecretManagerSecretIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member#project GoogleSecretManagerSecretIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member#role GoogleSecretManagerSecretIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member#secret_id GoogleSecretManagerSecretIamMember#secret_id}
    */
    readonly secretId: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member#condition GoogleSecretManagerSecretIamMember#condition}
    */
    readonly condition?: GoogleSecretManagerSecretIamMemberCondition;
}
export interface GoogleSecretManagerSecretIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member#description GoogleSecretManagerSecretIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member#expression GoogleSecretManagerSecretIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member#title GoogleSecretManagerSecretIamMember#title}
    */
    readonly title: string;
}
export declare function googleSecretManagerSecretIamMemberConditionToTerraform(struct?: GoogleSecretManagerSecretIamMemberConditionOutputReference | GoogleSecretManagerSecretIamMemberCondition): any;
export declare class GoogleSecretManagerSecretIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecretManagerSecretIamMemberCondition | undefined;
    set internalValue(value: GoogleSecretManagerSecretIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member google_secret_manager_secret_iam_member}
*/
export declare class GoogleSecretManagerSecretIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_secret_manager_secret_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_secret_manager_secret_iam_member google_secret_manager_secret_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSecretManagerSecretIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSecretManagerSecretIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    private _condition;
    get condition(): GoogleSecretManagerSecretIamMemberConditionOutputReference;
    putCondition(value: GoogleSecretManagerSecretIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleSecretManagerSecretIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
