import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleServiceAccountIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member#id GoogleServiceAccountIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member#member GoogleServiceAccountIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member#role GoogleServiceAccountIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member#service_account_id GoogleServiceAccountIamMember#service_account_id}
    */
    readonly serviceAccountId: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member#condition GoogleServiceAccountIamMember#condition}
    */
    readonly condition?: GoogleServiceAccountIamMemberCondition;
}
export interface GoogleServiceAccountIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member#description GoogleServiceAccountIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member#expression GoogleServiceAccountIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member#title GoogleServiceAccountIamMember#title}
    */
    readonly title: string;
}
export declare function googleServiceAccountIamMemberConditionToTerraform(struct?: GoogleServiceAccountIamMemberConditionOutputReference | GoogleServiceAccountIamMemberCondition): any;
export declare class GoogleServiceAccountIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleServiceAccountIamMemberCondition | undefined;
    set internalValue(value: GoogleServiceAccountIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member google_service_account_iam_member}
*/
export declare class GoogleServiceAccountIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_service_account_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_account_iam_member google_service_account_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleServiceAccountIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleServiceAccountIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _serviceAccountId?;
    get serviceAccountId(): string;
    set serviceAccountId(value: string);
    get serviceAccountIdInput(): string | undefined;
    private _condition;
    get condition(): GoogleServiceAccountIamMemberConditionOutputReference;
    putCondition(value: GoogleServiceAccountIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleServiceAccountIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
