import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleServiceDirectoryServiceIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member#id GoogleServiceDirectoryServiceIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member#member GoogleServiceDirectoryServiceIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member#name GoogleServiceDirectoryServiceIamMember#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member#role GoogleServiceDirectoryServiceIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member#condition GoogleServiceDirectoryServiceIamMember#condition}
    */
    readonly condition?: GoogleServiceDirectoryServiceIamMemberCondition;
}
export interface GoogleServiceDirectoryServiceIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member#description GoogleServiceDirectoryServiceIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member#expression GoogleServiceDirectoryServiceIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member#title GoogleServiceDirectoryServiceIamMember#title}
    */
    readonly title: string;
}
export declare function googleServiceDirectoryServiceIamMemberConditionToTerraform(struct?: GoogleServiceDirectoryServiceIamMemberConditionOutputReference | GoogleServiceDirectoryServiceIamMemberCondition): any;
export declare class GoogleServiceDirectoryServiceIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleServiceDirectoryServiceIamMemberCondition | undefined;
    set internalValue(value: GoogleServiceDirectoryServiceIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member google_service_directory_service_iam_member}
*/
export declare class GoogleServiceDirectoryServiceIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_service_directory_service_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_service_directory_service_iam_member google_service_directory_service_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleServiceDirectoryServiceIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleServiceDirectoryServiceIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleServiceDirectoryServiceIamMemberConditionOutputReference;
    putCondition(value: GoogleServiceDirectoryServiceIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleServiceDirectoryServiceIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
