import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSourcerepoRepositoryIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sourcerepo_repository_iam_policy#id GoogleSourcerepoRepositoryIamPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sourcerepo_repository_iam_policy#policy_data GoogleSourcerepoRepositoryIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sourcerepo_repository_iam_policy#project GoogleSourcerepoRepositoryIamPolicy#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sourcerepo_repository_iam_policy#repository GoogleSourcerepoRepositoryIamPolicy#repository}
    */
    readonly repository: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_sourcerepo_repository_iam_policy google_sourcerepo_repository_iam_policy}
*/
export declare class GoogleSourcerepoRepositoryIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sourcerepo_repository_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_sourcerepo_repository_iam_policy google_sourcerepo_repository_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSourcerepoRepositoryIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSourcerepoRepositoryIamPolicyConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
