import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSpannerDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The dialect of the Cloud Spanner Database.
  If it is not provided, "GOOGLE_STANDARD_SQL" will be used. Possible values: ["GOOGLE_STANDARD_SQL", "POSTGRESQL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#database_dialect GoogleSpannerDatabase#database_dialect}
    */
    readonly databaseDialect?: string;
    /**
    * An optional list of DDL statements to run inside the newly created
  database. Statements can create tables, indexes, etc. These statements
  execute atomically with the creation of the database: if there is an
  error in any statement, the database is not created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#ddl GoogleSpannerDatabase#ddl}
    */
    readonly ddl?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#deletion_protection GoogleSpannerDatabase#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#id GoogleSpannerDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The instance to create the database on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#instance GoogleSpannerDatabase#instance}
    */
    readonly instance: string;
    /**
    * A unique identifier for the database, which cannot be changed after
  the instance is created. Values are of the form [a-z][-a-z0-9]*[a-z0-9].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#name GoogleSpannerDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#project GoogleSpannerDatabase#project}
    */
    readonly project?: string;
    /**
    * The retention period for the database. The retention period must be between 1 hour
  and 7 days, and can be specified in days, hours, minutes, or seconds. For example,
  the values 1d, 24h, 1440m, and 86400s are equivalent. Default value is 1h.
  If this property is used, you must avoid adding new DDL statements to 'ddl' that
  update the database's version_retention_period.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#version_retention_period GoogleSpannerDatabase#version_retention_period}
    */
    readonly versionRetentionPeriod?: string;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#encryption_config GoogleSpannerDatabase#encryption_config}
    */
    readonly encryptionConfig?: GoogleSpannerDatabaseEncryptionConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#timeouts GoogleSpannerDatabase#timeouts}
    */
    readonly timeouts?: GoogleSpannerDatabaseTimeouts;
}
export interface GoogleSpannerDatabaseEncryptionConfig {
    /**
    * Fully qualified name of the KMS key to use to encrypt this database. This key must exist
  in the same location as the Spanner Database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#kms_key_name GoogleSpannerDatabase#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleSpannerDatabaseEncryptionConfigToTerraform(struct?: GoogleSpannerDatabaseEncryptionConfigOutputReference | GoogleSpannerDatabaseEncryptionConfig): any;
export declare class GoogleSpannerDatabaseEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSpannerDatabaseEncryptionConfig | undefined;
    set internalValue(value: GoogleSpannerDatabaseEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleSpannerDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#create GoogleSpannerDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#delete GoogleSpannerDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database#update GoogleSpannerDatabase#update}
    */
    readonly update?: string;
}
export declare function googleSpannerDatabaseTimeoutsToTerraform(struct?: GoogleSpannerDatabaseTimeoutsOutputReference | GoogleSpannerDatabaseTimeouts | cdktf.IResolvable): any;
export declare class GoogleSpannerDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSpannerDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSpannerDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database google_spanner_database}
*/
export declare class GoogleSpannerDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_spanner_database";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_spanner_database google_spanner_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSpannerDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSpannerDatabaseConfig);
    private _databaseDialect?;
    get databaseDialect(): string;
    set databaseDialect(value: string);
    resetDatabaseDialect(): void;
    get databaseDialectInput(): string | undefined;
    private _ddl?;
    get ddl(): string[];
    set ddl(value: string[]);
    resetDdl(): void;
    get ddlInput(): string[] | undefined;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _versionRetentionPeriod?;
    get versionRetentionPeriod(): string;
    set versionRetentionPeriod(value: string);
    resetVersionRetentionPeriod(): void;
    get versionRetentionPeriodInput(): string | undefined;
    private _encryptionConfig;
    get encryptionConfig(): GoogleSpannerDatabaseEncryptionConfigOutputReference;
    putEncryptionConfig(value: GoogleSpannerDatabaseEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): GoogleSpannerDatabaseEncryptionConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleSpannerDatabaseTimeoutsOutputReference;
    putTimeouts(value: GoogleSpannerDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSpannerDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
