import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSqlUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * The deletion policy for the user. Setting ABANDON allows the resource
                  to be abandoned rather than deleted. This is useful for Postgres, where users cannot be deleted from the API if they
                  have been granted SQL roles. Possible values are: "ABANDON".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#deletion_policy GoogleSqlUser#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * The host the user can connect from. This is only supported for MySQL instances. Don't set this field for PostgreSQL instances. Can be an IP address. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#host GoogleSqlUser#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#id GoogleSqlUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Cloud SQL instance. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#instance GoogleSqlUser#instance}
    */
    readonly instance: string;
    /**
    * The name of the user. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#name GoogleSqlUser#name}
    */
    readonly name: string;
    /**
    * The password for the user. Can be updated. For Postgres instances this is a Required field, unless type is set to
                  either CLOUD_IAM_USER or CLOUD_IAM_SERVICE_ACCOUNT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#password GoogleSqlUser#password}
    */
    readonly password?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#project GoogleSqlUser#project}
    */
    readonly project?: string;
    /**
    * The user type. It determines the method to authenticate the user during login.
                  The default is the database's built-in user type. Flags include "BUILT_IN", "CLOUD_IAM_USER", or "CLOUD_IAM_SERVICE_ACCOUNT".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#type GoogleSqlUser#type}
    */
    readonly type?: string;
    /**
    * sql_server_user_details block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#sql_server_user_details GoogleSqlUser#sql_server_user_details}
    */
    readonly sqlServerUserDetails?: GoogleSqlUserSqlServerUserDetails;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#timeouts GoogleSqlUser#timeouts}
    */
    readonly timeouts?: GoogleSqlUserTimeouts;
}
export interface GoogleSqlUserSqlServerUserDetails {
    /**
    * If the user has been disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#disabled GoogleSqlUser#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The server roles for this user in the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#server_roles GoogleSqlUser#server_roles}
    */
    readonly serverRoles?: string[];
}
export declare function googleSqlUserSqlServerUserDetailsToTerraform(struct?: GoogleSqlUserSqlServerUserDetailsOutputReference | GoogleSqlUserSqlServerUserDetails): any;
export declare class GoogleSqlUserSqlServerUserDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSqlUserSqlServerUserDetails | undefined;
    set internalValue(value: GoogleSqlUserSqlServerUserDetails | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _serverRoles?;
    get serverRoles(): string[];
    set serverRoles(value: string[]);
    resetServerRoles(): void;
    get serverRolesInput(): string[] | undefined;
}
export interface GoogleSqlUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#create GoogleSqlUser#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#delete GoogleSqlUser#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user#update GoogleSqlUser#update}
    */
    readonly update?: string;
}
export declare function googleSqlUserTimeoutsToTerraform(struct?: GoogleSqlUserTimeoutsOutputReference | GoogleSqlUserTimeouts | cdktf.IResolvable): any;
export declare class GoogleSqlUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSqlUserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSqlUserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user google_sql_user}
*/
export declare class GoogleSqlUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sql_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_sql_user google_sql_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSqlUserConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSqlUserConfig);
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _sqlServerUserDetails;
    get sqlServerUserDetails(): GoogleSqlUserSqlServerUserDetailsOutputReference;
    putSqlServerUserDetails(value: GoogleSqlUserSqlServerUserDetails): void;
    resetSqlServerUserDetails(): void;
    get sqlServerUserDetailsInput(): GoogleSqlUserSqlServerUserDetails | undefined;
    private _timeouts;
    get timeouts(): GoogleSqlUserTimeoutsOutputReference;
    putTimeouts(value: GoogleSqlUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSqlUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
