import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleStorageBucketAccessControlConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control#bucket GoogleStorageBucketAccessControl#bucket}
    */
    readonly bucket: string;
    /**
    * The entity holding the permission, in one of the following forms:
    user-userId
    user-email
    group-groupId
    group-email
    domain-domain
    project-team-projectId
    allUsers
    allAuthenticatedUsers
  Examples:
    The user liz@example.com would be user-liz@example.com.
    The group example@googlegroups.com would be
    group-example@googlegroups.com.
    To refer to all members of the Google Apps for Business domain
    example.com, the entity would be domain-example.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control#entity GoogleStorageBucketAccessControl#entity}
    */
    readonly entity: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control#id GoogleStorageBucketAccessControl#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The access permission for the entity. Possible values: ["OWNER", "READER", "WRITER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control#role GoogleStorageBucketAccessControl#role}
    */
    readonly role?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control#timeouts GoogleStorageBucketAccessControl#timeouts}
    */
    readonly timeouts?: GoogleStorageBucketAccessControlTimeouts;
}
export interface GoogleStorageBucketAccessControlTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control#create GoogleStorageBucketAccessControl#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control#delete GoogleStorageBucketAccessControl#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control#update GoogleStorageBucketAccessControl#update}
    */
    readonly update?: string;
}
export declare function googleStorageBucketAccessControlTimeoutsToTerraform(struct?: GoogleStorageBucketAccessControlTimeoutsOutputReference | GoogleStorageBucketAccessControlTimeouts | cdktf.IResolvable): any;
export declare class GoogleStorageBucketAccessControlTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketAccessControlTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleStorageBucketAccessControlTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control google_storage_bucket_access_control}
*/
export declare class GoogleStorageBucketAccessControl extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_bucket_access_control";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_access_control google_storage_bucket_access_control} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleStorageBucketAccessControlConfig
    */
    constructor(scope: Construct, id: string, config: GoogleStorageBucketAccessControlConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get domain(): string;
    get email(): string;
    private _entity?;
    get entity(): string;
    set entity(value: string);
    get entityInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleStorageBucketAccessControlTimeoutsOutputReference;
    putTimeouts(value: GoogleStorageBucketAccessControlTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleStorageBucketAccessControlTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
