import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleStorageBucketAclConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the bucket it applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_acl#bucket GoogleStorageBucketAcl#bucket}
    */
    readonly bucket: string;
    /**
    * Configure this ACL to be the default ACL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_acl#default_acl GoogleStorageBucketAcl#default_acl}
    */
    readonly defaultAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_acl#id GoogleStorageBucketAcl#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The canned GCS ACL to apply. Must be set if role_entity is not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_acl#predefined_acl GoogleStorageBucketAcl#predefined_acl}
    */
    readonly predefinedAcl?: string;
    /**
    * List of role/entity pairs in the form ROLE:entity. See GCS Bucket ACL documentation  for more details. Must be set if predefined_acl is not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_acl#role_entity GoogleStorageBucketAcl#role_entity}
    */
    readonly roleEntity?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_acl google_storage_bucket_acl}
*/
export declare class GoogleStorageBucketAcl extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_bucket_acl";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_bucket_acl google_storage_bucket_acl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleStorageBucketAclConfig
    */
    constructor(scope: Construct, id: string, config: GoogleStorageBucketAclConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _defaultAcl?;
    get defaultAcl(): string;
    set defaultAcl(value: string);
    resetDefaultAcl(): void;
    get defaultAclInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _predefinedAcl?;
    get predefinedAcl(): string;
    set predefinedAcl(value: string);
    resetPredefinedAcl(): void;
    get predefinedAclInput(): string | undefined;
    private _roleEntity?;
    get roleEntity(): string[];
    set roleEntity(value: string[]);
    resetRoleEntity(): void;
    get roleEntityInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
