import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleStorageObjectAccessControlConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control#bucket GoogleStorageObjectAccessControl#bucket}
    */
    readonly bucket: string;
    /**
    * The entity holding the permission, in one of the following forms:
    * user-{{userId}}
    * user-{{email}} (such as "user-liz@example.com")
    * group-{{groupId}}
    * group-{{email}} (such as "group-example@googlegroups.com")
    * domain-{{domain}} (such as "domain-example.com")
    * project-team-{{projectId}}
    * allUsers
    * allAuthenticatedUsers
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control#entity GoogleStorageObjectAccessControl#entity}
    */
    readonly entity: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control#id GoogleStorageObjectAccessControl#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the object to apply the access control to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control#object GoogleStorageObjectAccessControl#object}
    */
    readonly object: string;
    /**
    * The access permission for the entity. Possible values: ["OWNER", "READER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control#role GoogleStorageObjectAccessControl#role}
    */
    readonly role: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control#timeouts GoogleStorageObjectAccessControl#timeouts}
    */
    readonly timeouts?: GoogleStorageObjectAccessControlTimeouts;
}
export interface GoogleStorageObjectAccessControlProjectTeam {
}
export declare function googleStorageObjectAccessControlProjectTeamToTerraform(struct?: GoogleStorageObjectAccessControlProjectTeam): any;
export declare class GoogleStorageObjectAccessControlProjectTeamOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleStorageObjectAccessControlProjectTeam | undefined;
    set internalValue(value: GoogleStorageObjectAccessControlProjectTeam | undefined);
    get projectNumber(): string;
    get team(): string;
}
export declare class GoogleStorageObjectAccessControlProjectTeamList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleStorageObjectAccessControlProjectTeamOutputReference;
}
export interface GoogleStorageObjectAccessControlTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control#create GoogleStorageObjectAccessControl#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control#delete GoogleStorageObjectAccessControl#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control#update GoogleStorageObjectAccessControl#update}
    */
    readonly update?: string;
}
export declare function googleStorageObjectAccessControlTimeoutsToTerraform(struct?: GoogleStorageObjectAccessControlTimeoutsOutputReference | GoogleStorageObjectAccessControlTimeouts | cdktf.IResolvable): any;
export declare class GoogleStorageObjectAccessControlTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageObjectAccessControlTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleStorageObjectAccessControlTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control google_storage_object_access_control}
*/
export declare class GoogleStorageObjectAccessControl extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_object_access_control";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_storage_object_access_control google_storage_object_access_control} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleStorageObjectAccessControlConfig
    */
    constructor(scope: Construct, id: string, config: GoogleStorageObjectAccessControlConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get domain(): string;
    get email(): string;
    private _entity?;
    get entity(): string;
    set entity(value: string);
    get entityInput(): string | undefined;
    get entityId(): string;
    get generation(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
    private _projectTeam;
    get projectTeam(): GoogleStorageObjectAccessControlProjectTeamList;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleStorageObjectAccessControlTimeoutsOutputReference;
    putTimeouts(value: GoogleStorageObjectAccessControlTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleStorageObjectAccessControlTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
