import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleTagsTagKeyIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding#id GoogleTagsTagKeyIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding#members GoogleTagsTagKeyIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding#role GoogleTagsTagKeyIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding#tag_key GoogleTagsTagKeyIamBinding#tag_key}
    */
    readonly tagKey: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding#condition GoogleTagsTagKeyIamBinding#condition}
    */
    readonly condition?: GoogleTagsTagKeyIamBindingCondition;
}
export interface GoogleTagsTagKeyIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding#description GoogleTagsTagKeyIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding#expression GoogleTagsTagKeyIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding#title GoogleTagsTagKeyIamBinding#title}
    */
    readonly title: string;
}
export declare function googleTagsTagKeyIamBindingConditionToTerraform(struct?: GoogleTagsTagKeyIamBindingConditionOutputReference | GoogleTagsTagKeyIamBindingCondition): any;
export declare class GoogleTagsTagKeyIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTagsTagKeyIamBindingCondition | undefined;
    set internalValue(value: GoogleTagsTagKeyIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding google_tags_tag_key_iam_binding}
*/
export declare class GoogleTagsTagKeyIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_tags_tag_key_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_key_iam_binding google_tags_tag_key_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleTagsTagKeyIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleTagsTagKeyIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _tagKey?;
    get tagKey(): string;
    set tagKey(value: string);
    get tagKeyInput(): string | undefined;
    private _condition;
    get condition(): GoogleTagsTagKeyIamBindingConditionOutputReference;
    putCondition(value: GoogleTagsTagKeyIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleTagsTagKeyIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
