import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleTagsTagValueConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-assigned description of the TagValue. Must not exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value#description GoogleTagsTagValue#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value#id GoogleTagsTagValue#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Input only. The resource name of the new TagValue's parent. Must be of the form tagKeys/{tag_key_id}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value#parent GoogleTagsTagValue#parent}
    */
    readonly parent: string;
    /**
    * Input only. User-assigned short name for TagValue. The short name should be unique for TagValues within the same parent TagKey.
  
  The short name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value#short_name GoogleTagsTagValue#short_name}
    */
    readonly shortName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value#timeouts GoogleTagsTagValue#timeouts}
    */
    readonly timeouts?: GoogleTagsTagValueTimeouts;
}
export interface GoogleTagsTagValueTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value#create GoogleTagsTagValue#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value#delete GoogleTagsTagValue#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value#update GoogleTagsTagValue#update}
    */
    readonly update?: string;
}
export declare function googleTagsTagValueTimeoutsToTerraform(struct?: GoogleTagsTagValueTimeoutsOutputReference | GoogleTagsTagValueTimeouts | cdktf.IResolvable): any;
export declare class GoogleTagsTagValueTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTagsTagValueTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleTagsTagValueTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value google_tags_tag_value}
*/
export declare class GoogleTagsTagValue extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_tags_tag_value";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_tags_tag_value google_tags_tag_value} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleTagsTagValueConfig
    */
    constructor(scope: Construct, id: string, config: GoogleTagsTagValueConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get namespacedName(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleTagsTagValueTimeoutsOutputReference;
    putTimeouts(value: GoogleTagsTagValueTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleTagsTagValueTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
