import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user-defined name of the Dataset. The name can be up to 128 characters long and can be consist of any UTF-8 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#display_name GoogleVertexAiDataset#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#id GoogleVertexAiDataset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this Workflow.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#labels GoogleVertexAiDataset#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Points to a YAML file stored on Google Cloud Storage describing additional information about the Dataset. The schema is defined as an OpenAPI 3.0.2 Schema Object. The schema files that can be used here are found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#metadata_schema_uri GoogleVertexAiDataset#metadata_schema_uri}
    */
    readonly metadataSchemaUri: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#project GoogleVertexAiDataset#project}
    */
    readonly project?: string;
    /**
    * The region of the dataset. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#region GoogleVertexAiDataset#region}
    */
    readonly region?: string;
    /**
    * encryption_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#encryption_spec GoogleVertexAiDataset#encryption_spec}
    */
    readonly encryptionSpec?: GoogleVertexAiDatasetEncryptionSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#timeouts GoogleVertexAiDataset#timeouts}
    */
    readonly timeouts?: GoogleVertexAiDatasetTimeouts;
}
export interface GoogleVertexAiDatasetEncryptionSpec {
    /**
    * Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
  Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#kms_key_name GoogleVertexAiDataset#kms_key_name}
    */
    readonly kmsKeyName?: string;
}
export declare function googleVertexAiDatasetEncryptionSpecToTerraform(struct?: GoogleVertexAiDatasetEncryptionSpecOutputReference | GoogleVertexAiDatasetEncryptionSpec): any;
export declare class GoogleVertexAiDatasetEncryptionSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiDatasetEncryptionSpec | undefined;
    set internalValue(value: GoogleVertexAiDatasetEncryptionSpec | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleVertexAiDatasetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#create GoogleVertexAiDataset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#delete GoogleVertexAiDataset#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset#update GoogleVertexAiDataset#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiDatasetTimeoutsToTerraform(struct?: GoogleVertexAiDatasetTimeoutsOutputReference | GoogleVertexAiDatasetTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiDatasetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiDatasetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset google_vertex_ai_dataset}
*/
export declare class GoogleVertexAiDataset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_dataset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_dataset google_vertex_ai_dataset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiDatasetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiDatasetConfig);
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _metadataSchemaUri?;
    get metadataSchemaUri(): string;
    set metadataSchemaUri(value: string);
    get metadataSchemaUriInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get updateTime(): string;
    private _encryptionSpec;
    get encryptionSpec(): GoogleVertexAiDatasetEncryptionSpecOutputReference;
    putEncryptionSpec(value: GoogleVertexAiDatasetEncryptionSpec): void;
    resetEncryptionSpec(): void;
    get encryptionSpecInput(): GoogleVertexAiDatasetEncryptionSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiDatasetTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiDatasetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiDatasetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
