import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiFeaturestoreEntitytypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Featurestore to use, in the format projects/{project}/locations/{location}/featurestores/{featurestore}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#featurestore GoogleVertexAiFeaturestoreEntitytype#featurestore}
    */
    readonly featurestore: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#id GoogleVertexAiFeaturestoreEntitytype#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this EntityType.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#labels GoogleVertexAiFeaturestoreEntitytype#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the EntityType. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#name GoogleVertexAiFeaturestoreEntitytype#name}
    */
    readonly name?: string;
    /**
    * monitoring_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#monitoring_config GoogleVertexAiFeaturestoreEntitytype#monitoring_config}
    */
    readonly monitoringConfig?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#timeouts GoogleVertexAiFeaturestoreEntitytype#timeouts}
    */
    readonly timeouts?: GoogleVertexAiFeaturestoreEntitytypeTimeouts;
}
export interface GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis {
    /**
    * The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoringInterval for Features under it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#disabled GoogleVertexAiFeaturestoreEntitytype#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Configuration of the snapshot analysis based monitoring pipeline running interval. The value is rolled up to full day.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#monitoring_interval GoogleVertexAiFeaturestoreEntitytype#monitoring_interval}
    */
    readonly monitoringInterval?: string;
}
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _monitoringInterval?;
    get monitoringInterval(): string;
    set monitoringInterval(value: string);
    resetMonitoringInterval(): void;
    get monitoringIntervalInput(): string | undefined;
}
export interface GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig {
    /**
    * snapshot_analysis block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#snapshot_analysis GoogleVertexAiFeaturestoreEntitytype#snapshot_analysis}
    */
    readonly snapshotAnalysis?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis;
}
export declare function googleVertexAiFeaturestoreEntitytypeMonitoringConfigToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference | GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig | undefined);
    private _snapshotAnalysis;
    get snapshotAnalysis(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysisOutputReference;
    putSnapshotAnalysis(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis): void;
    resetSnapshotAnalysis(): void;
    get snapshotAnalysisInput(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigSnapshotAnalysis | undefined;
}
export interface GoogleVertexAiFeaturestoreEntitytypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#create GoogleVertexAiFeaturestoreEntitytype#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#delete GoogleVertexAiFeaturestoreEntitytype#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype#update GoogleVertexAiFeaturestoreEntitytype#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiFeaturestoreEntitytypeTimeoutsToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeTimeoutsOutputReference | GoogleVertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype google_vertex_ai_featurestore_entitytype}
*/
export declare class GoogleVertexAiFeaturestoreEntitytype extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_featurestore_entitytype";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore_entitytype google_vertex_ai_featurestore_entitytype} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiFeaturestoreEntitytypeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiFeaturestoreEntitytypeConfig);
    get createTime(): string;
    get etag(): string;
    private _featurestore?;
    get featurestore(): string;
    set featurestore(value: string);
    get featurestoreInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get updateTime(): string;
    private _monitoringConfig;
    get monitoringConfig(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfigOutputReference;
    putMonitoringConfig(value: GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig): void;
    resetMonitoringConfig(): void;
    get monitoringConfigInput(): GoogleVertexAiFeaturestoreEntitytypeMonitoringConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiFeaturestoreEntitytypeTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiFeaturestoreEntitytypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiFeaturestoreEntitytypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
