import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiFeaturestoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#force_destroy GoogleVertexAiFeaturestore#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#id GoogleVertexAiFeaturestore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this Featurestore.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#labels GoogleVertexAiFeaturestore#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the Featurestore. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#name GoogleVertexAiFeaturestore#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#project GoogleVertexAiFeaturestore#project}
    */
    readonly project?: string;
    /**
    * The region of the dataset. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#region GoogleVertexAiFeaturestore#region}
    */
    readonly region?: string;
    /**
    * encryption_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#encryption_spec GoogleVertexAiFeaturestore#encryption_spec}
    */
    readonly encryptionSpec?: GoogleVertexAiFeaturestoreEncryptionSpec;
    /**
    * online_serving_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#online_serving_config GoogleVertexAiFeaturestore#online_serving_config}
    */
    readonly onlineServingConfig?: GoogleVertexAiFeaturestoreOnlineServingConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#timeouts GoogleVertexAiFeaturestore#timeouts}
    */
    readonly timeouts?: GoogleVertexAiFeaturestoreTimeouts;
}
export interface GoogleVertexAiFeaturestoreEncryptionSpec {
    /**
    * The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the compute resource is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#kms_key_name GoogleVertexAiFeaturestore#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleVertexAiFeaturestoreEncryptionSpecToTerraform(struct?: GoogleVertexAiFeaturestoreEncryptionSpecOutputReference | GoogleVertexAiFeaturestoreEncryptionSpec): any;
export declare class GoogleVertexAiFeaturestoreEncryptionSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEncryptionSpec | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEncryptionSpec | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleVertexAiFeaturestoreOnlineServingConfig {
    /**
    * The number of nodes for each cluster. The number of nodes will not scale automatically but can be scaled manually by providing different values when updating.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#fixed_node_count GoogleVertexAiFeaturestore#fixed_node_count}
    */
    readonly fixedNodeCount: number;
}
export declare function googleVertexAiFeaturestoreOnlineServingConfigToTerraform(struct?: GoogleVertexAiFeaturestoreOnlineServingConfigOutputReference | GoogleVertexAiFeaturestoreOnlineServingConfig): any;
export declare class GoogleVertexAiFeaturestoreOnlineServingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreOnlineServingConfig | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreOnlineServingConfig | undefined);
    private _fixedNodeCount?;
    get fixedNodeCount(): number;
    set fixedNodeCount(value: number);
    get fixedNodeCountInput(): number | undefined;
}
export interface GoogleVertexAiFeaturestoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#create GoogleVertexAiFeaturestore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#delete GoogleVertexAiFeaturestore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore#update GoogleVertexAiFeaturestore#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiFeaturestoreTimeoutsToTerraform(struct?: GoogleVertexAiFeaturestoreTimeoutsOutputReference | GoogleVertexAiFeaturestoreTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiFeaturestoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore google_vertex_ai_featurestore}
*/
export declare class GoogleVertexAiFeaturestore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_featurestore";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_vertex_ai_featurestore google_vertex_ai_featurestore} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiFeaturestoreConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleVertexAiFeaturestoreConfig);
    get createTime(): string;
    get etag(): string;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get updateTime(): string;
    private _encryptionSpec;
    get encryptionSpec(): GoogleVertexAiFeaturestoreEncryptionSpecOutputReference;
    putEncryptionSpec(value: GoogleVertexAiFeaturestoreEncryptionSpec): void;
    resetEncryptionSpec(): void;
    get encryptionSpecInput(): GoogleVertexAiFeaturestoreEncryptionSpec | undefined;
    private _onlineServingConfig;
    get onlineServingConfig(): GoogleVertexAiFeaturestoreOnlineServingConfigOutputReference;
    putOnlineServingConfig(value: GoogleVertexAiFeaturestoreOnlineServingConfig): void;
    resetOnlineServingConfig(): void;
    get onlineServingConfigInput(): GoogleVertexAiFeaturestoreOnlineServingConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiFeaturestoreTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiFeaturestoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiFeaturestoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
