import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBetaProviderConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#access_approval_custom_endpoint GoogleBetaProvider#access_approval_custom_endpoint}
    */
    readonly accessApprovalCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#access_context_manager_custom_endpoint GoogleBetaProvider#access_context_manager_custom_endpoint}
    */
    readonly accessContextManagerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#access_token GoogleBetaProvider#access_token}
    */
    readonly accessToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#active_directory_custom_endpoint GoogleBetaProvider#active_directory_custom_endpoint}
    */
    readonly activeDirectoryCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#api_gateway_custom_endpoint GoogleBetaProvider#api_gateway_custom_endpoint}
    */
    readonly apiGatewayCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#apigee_custom_endpoint GoogleBetaProvider#apigee_custom_endpoint}
    */
    readonly apigeeCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#apikeys_custom_endpoint GoogleBetaProvider#apikeys_custom_endpoint}
    */
    readonly apikeysCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#app_engine_custom_endpoint GoogleBetaProvider#app_engine_custom_endpoint}
    */
    readonly appEngineCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#artifact_registry_custom_endpoint GoogleBetaProvider#artifact_registry_custom_endpoint}
    */
    readonly artifactRegistryCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#assured_workloads_custom_endpoint GoogleBetaProvider#assured_workloads_custom_endpoint}
    */
    readonly assuredWorkloadsCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#big_query_custom_endpoint GoogleBetaProvider#big_query_custom_endpoint}
    */
    readonly bigQueryCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#bigquery_analytics_hub_custom_endpoint GoogleBetaProvider#bigquery_analytics_hub_custom_endpoint}
    */
    readonly bigqueryAnalyticsHubCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#bigquery_connection_custom_endpoint GoogleBetaProvider#bigquery_connection_custom_endpoint}
    */
    readonly bigqueryConnectionCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#bigquery_data_transfer_custom_endpoint GoogleBetaProvider#bigquery_data_transfer_custom_endpoint}
    */
    readonly bigqueryDataTransferCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#bigquery_reservation_custom_endpoint GoogleBetaProvider#bigquery_reservation_custom_endpoint}
    */
    readonly bigqueryReservationCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#bigtable_custom_endpoint GoogleBetaProvider#bigtable_custom_endpoint}
    */
    readonly bigtableCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#billing_custom_endpoint GoogleBetaProvider#billing_custom_endpoint}
    */
    readonly billingCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#billing_project GoogleBetaProvider#billing_project}
    */
    readonly billingProject?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#binary_authorization_custom_endpoint GoogleBetaProvider#binary_authorization_custom_endpoint}
    */
    readonly binaryAuthorizationCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#certificate_manager_custom_endpoint GoogleBetaProvider#certificate_manager_custom_endpoint}
    */
    readonly certificateManagerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_asset_custom_endpoint GoogleBetaProvider#cloud_asset_custom_endpoint}
    */
    readonly cloudAssetCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_billing_custom_endpoint GoogleBetaProvider#cloud_billing_custom_endpoint}
    */
    readonly cloudBillingCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_build_custom_endpoint GoogleBetaProvider#cloud_build_custom_endpoint}
    */
    readonly cloudBuildCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_build_worker_pool_custom_endpoint GoogleBetaProvider#cloud_build_worker_pool_custom_endpoint}
    */
    readonly cloudBuildWorkerPoolCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_functions_custom_endpoint GoogleBetaProvider#cloud_functions_custom_endpoint}
    */
    readonly cloudFunctionsCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_identity_custom_endpoint GoogleBetaProvider#cloud_identity_custom_endpoint}
    */
    readonly cloudIdentityCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_iot_custom_endpoint GoogleBetaProvider#cloud_iot_custom_endpoint}
    */
    readonly cloudIotCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_resource_manager_custom_endpoint GoogleBetaProvider#cloud_resource_manager_custom_endpoint}
    */
    readonly cloudResourceManagerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_run_custom_endpoint GoogleBetaProvider#cloud_run_custom_endpoint}
    */
    readonly cloudRunCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_scheduler_custom_endpoint GoogleBetaProvider#cloud_scheduler_custom_endpoint}
    */
    readonly cloudSchedulerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloud_tasks_custom_endpoint GoogleBetaProvider#cloud_tasks_custom_endpoint}
    */
    readonly cloudTasksCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#clouddeploy_custom_endpoint GoogleBetaProvider#clouddeploy_custom_endpoint}
    */
    readonly clouddeployCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#cloudfunctions2_custom_endpoint GoogleBetaProvider#cloudfunctions2_custom_endpoint}
    */
    readonly cloudfunctions2CustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#composer_custom_endpoint GoogleBetaProvider#composer_custom_endpoint}
    */
    readonly composerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#compute_custom_endpoint GoogleBetaProvider#compute_custom_endpoint}
    */
    readonly computeCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#container_analysis_custom_endpoint GoogleBetaProvider#container_analysis_custom_endpoint}
    */
    readonly containerAnalysisCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#container_aws_custom_endpoint GoogleBetaProvider#container_aws_custom_endpoint}
    */
    readonly containerAwsCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#container_azure_custom_endpoint GoogleBetaProvider#container_azure_custom_endpoint}
    */
    readonly containerAzureCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#container_custom_endpoint GoogleBetaProvider#container_custom_endpoint}
    */
    readonly containerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#credentials GoogleBetaProvider#credentials}
    */
    readonly credentials?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#data_catalog_custom_endpoint GoogleBetaProvider#data_catalog_custom_endpoint}
    */
    readonly dataCatalogCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#data_fusion_custom_endpoint GoogleBetaProvider#data_fusion_custom_endpoint}
    */
    readonly dataFusionCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#data_loss_prevention_custom_endpoint GoogleBetaProvider#data_loss_prevention_custom_endpoint}
    */
    readonly dataLossPreventionCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#dataflow_custom_endpoint GoogleBetaProvider#dataflow_custom_endpoint}
    */
    readonly dataflowCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#dataplex_custom_endpoint GoogleBetaProvider#dataplex_custom_endpoint}
    */
    readonly dataplexCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#dataproc_custom_endpoint GoogleBetaProvider#dataproc_custom_endpoint}
    */
    readonly dataprocCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#dataproc_metastore_custom_endpoint GoogleBetaProvider#dataproc_metastore_custom_endpoint}
    */
    readonly dataprocMetastoreCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#datastore_custom_endpoint GoogleBetaProvider#datastore_custom_endpoint}
    */
    readonly datastoreCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#datastream_custom_endpoint GoogleBetaProvider#datastream_custom_endpoint}
    */
    readonly datastreamCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#deployment_manager_custom_endpoint GoogleBetaProvider#deployment_manager_custom_endpoint}
    */
    readonly deploymentManagerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#dialogflow_custom_endpoint GoogleBetaProvider#dialogflow_custom_endpoint}
    */
    readonly dialogflowCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#dialogflow_cx_custom_endpoint GoogleBetaProvider#dialogflow_cx_custom_endpoint}
    */
    readonly dialogflowCxCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#dns_custom_endpoint GoogleBetaProvider#dns_custom_endpoint}
    */
    readonly dnsCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#document_ai_custom_endpoint GoogleBetaProvider#document_ai_custom_endpoint}
    */
    readonly documentAiCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#essential_contacts_custom_endpoint GoogleBetaProvider#essential_contacts_custom_endpoint}
    */
    readonly essentialContactsCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#eventarc_custom_endpoint GoogleBetaProvider#eventarc_custom_endpoint}
    */
    readonly eventarcCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#filestore_custom_endpoint GoogleBetaProvider#filestore_custom_endpoint}
    */
    readonly filestoreCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#firebase_custom_endpoint GoogleBetaProvider#firebase_custom_endpoint}
    */
    readonly firebaseCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#firebaserules_custom_endpoint GoogleBetaProvider#firebaserules_custom_endpoint}
    */
    readonly firebaserulesCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#firestore_custom_endpoint GoogleBetaProvider#firestore_custom_endpoint}
    */
    readonly firestoreCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#game_services_custom_endpoint GoogleBetaProvider#game_services_custom_endpoint}
    */
    readonly gameServicesCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#gke_hub_custom_endpoint GoogleBetaProvider#gke_hub_custom_endpoint}
    */
    readonly gkeHubCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#gkehub_feature_custom_endpoint GoogleBetaProvider#gkehub_feature_custom_endpoint}
    */
    readonly gkehubFeatureCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#healthcare_custom_endpoint GoogleBetaProvider#healthcare_custom_endpoint}
    */
    readonly healthcareCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#iam2_custom_endpoint GoogleBetaProvider#iam2_custom_endpoint}
    */
    readonly iam2CustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#iam_beta_custom_endpoint GoogleBetaProvider#iam_beta_custom_endpoint}
    */
    readonly iamBetaCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#iam_credentials_custom_endpoint GoogleBetaProvider#iam_credentials_custom_endpoint}
    */
    readonly iamCredentialsCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#iam_custom_endpoint GoogleBetaProvider#iam_custom_endpoint}
    */
    readonly iamCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#iap_custom_endpoint GoogleBetaProvider#iap_custom_endpoint}
    */
    readonly iapCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#identity_platform_custom_endpoint GoogleBetaProvider#identity_platform_custom_endpoint}
    */
    readonly identityPlatformCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#impersonate_service_account GoogleBetaProvider#impersonate_service_account}
    */
    readonly impersonateServiceAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#impersonate_service_account_delegates GoogleBetaProvider#impersonate_service_account_delegates}
    */
    readonly impersonateServiceAccountDelegates?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#kms_custom_endpoint GoogleBetaProvider#kms_custom_endpoint}
    */
    readonly kmsCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#logging_custom_endpoint GoogleBetaProvider#logging_custom_endpoint}
    */
    readonly loggingCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#memcache_custom_endpoint GoogleBetaProvider#memcache_custom_endpoint}
    */
    readonly memcacheCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#ml_engine_custom_endpoint GoogleBetaProvider#ml_engine_custom_endpoint}
    */
    readonly mlEngineCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#monitoring_custom_endpoint GoogleBetaProvider#monitoring_custom_endpoint}
    */
    readonly monitoringCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#network_connectivity_custom_endpoint GoogleBetaProvider#network_connectivity_custom_endpoint}
    */
    readonly networkConnectivityCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#network_management_custom_endpoint GoogleBetaProvider#network_management_custom_endpoint}
    */
    readonly networkManagementCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#network_services_custom_endpoint GoogleBetaProvider#network_services_custom_endpoint}
    */
    readonly networkServicesCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#notebooks_custom_endpoint GoogleBetaProvider#notebooks_custom_endpoint}
    */
    readonly notebooksCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#org_policy_custom_endpoint GoogleBetaProvider#org_policy_custom_endpoint}
    */
    readonly orgPolicyCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#os_config_custom_endpoint GoogleBetaProvider#os_config_custom_endpoint}
    */
    readonly osConfigCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#os_login_custom_endpoint GoogleBetaProvider#os_login_custom_endpoint}
    */
    readonly osLoginCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#privateca_custom_endpoint GoogleBetaProvider#privateca_custom_endpoint}
    */
    readonly privatecaCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#project GoogleBetaProvider#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#pubsub_custom_endpoint GoogleBetaProvider#pubsub_custom_endpoint}
    */
    readonly pubsubCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#pubsub_lite_custom_endpoint GoogleBetaProvider#pubsub_lite_custom_endpoint}
    */
    readonly pubsubLiteCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#recaptcha_enterprise_custom_endpoint GoogleBetaProvider#recaptcha_enterprise_custom_endpoint}
    */
    readonly recaptchaEnterpriseCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#redis_custom_endpoint GoogleBetaProvider#redis_custom_endpoint}
    */
    readonly redisCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#region GoogleBetaProvider#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#request_reason GoogleBetaProvider#request_reason}
    */
    readonly requestReason?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#request_timeout GoogleBetaProvider#request_timeout}
    */
    readonly requestTimeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#resource_manager_custom_endpoint GoogleBetaProvider#resource_manager_custom_endpoint}
    */
    readonly resourceManagerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#resource_manager_v3_custom_endpoint GoogleBetaProvider#resource_manager_v3_custom_endpoint}
    */
    readonly resourceManagerV3CustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#runtime_config_custom_endpoint GoogleBetaProvider#runtime_config_custom_endpoint}
    */
    readonly runtimeConfigCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#runtimeconfig_custom_endpoint GoogleBetaProvider#runtimeconfig_custom_endpoint}
    */
    readonly runtimeconfigCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#scopes GoogleBetaProvider#scopes}
    */
    readonly scopes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#secret_manager_custom_endpoint GoogleBetaProvider#secret_manager_custom_endpoint}
    */
    readonly secretManagerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#security_center_custom_endpoint GoogleBetaProvider#security_center_custom_endpoint}
    */
    readonly securityCenterCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#security_scanner_custom_endpoint GoogleBetaProvider#security_scanner_custom_endpoint}
    */
    readonly securityScannerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#service_directory_custom_endpoint GoogleBetaProvider#service_directory_custom_endpoint}
    */
    readonly serviceDirectoryCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#service_management_custom_endpoint GoogleBetaProvider#service_management_custom_endpoint}
    */
    readonly serviceManagementCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#service_networking_custom_endpoint GoogleBetaProvider#service_networking_custom_endpoint}
    */
    readonly serviceNetworkingCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#service_usage_custom_endpoint GoogleBetaProvider#service_usage_custom_endpoint}
    */
    readonly serviceUsageCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#source_repo_custom_endpoint GoogleBetaProvider#source_repo_custom_endpoint}
    */
    readonly sourceRepoCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#spanner_custom_endpoint GoogleBetaProvider#spanner_custom_endpoint}
    */
    readonly spannerCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#sql_custom_endpoint GoogleBetaProvider#sql_custom_endpoint}
    */
    readonly sqlCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#storage_custom_endpoint GoogleBetaProvider#storage_custom_endpoint}
    */
    readonly storageCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#storage_transfer_custom_endpoint GoogleBetaProvider#storage_transfer_custom_endpoint}
    */
    readonly storageTransferCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#tags_custom_endpoint GoogleBetaProvider#tags_custom_endpoint}
    */
    readonly tagsCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#tpu_custom_endpoint GoogleBetaProvider#tpu_custom_endpoint}
    */
    readonly tpuCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#user_project_override GoogleBetaProvider#user_project_override}
    */
    readonly userProjectOverride?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#vertex_ai_custom_endpoint GoogleBetaProvider#vertex_ai_custom_endpoint}
    */
    readonly vertexAiCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#vpc_access_custom_endpoint GoogleBetaProvider#vpc_access_custom_endpoint}
    */
    readonly vpcAccessCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#workflows_custom_endpoint GoogleBetaProvider#workflows_custom_endpoint}
    */
    readonly workflowsCustomEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#zone GoogleBetaProvider#zone}
    */
    readonly zone?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#alias GoogleBetaProvider#alias}
    */
    readonly alias?: string;
    /**
    * batching block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#batching GoogleBetaProvider#batching}
    */
    readonly batching?: GoogleBetaProviderBatching;
}
export interface GoogleBetaProviderBatching {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#enable_batching GoogleBetaProvider#enable_batching}
    */
    readonly enableBatching?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta#send_after GoogleBetaProvider#send_after}
    */
    readonly sendAfter?: string;
}
export declare function googleBetaProviderBatchingToTerraform(struct?: GoogleBetaProviderBatching): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta google-beta}
*/
export declare class GoogleBetaProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "google-beta";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta google-beta} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBetaProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleBetaProviderConfig);
    private _accessApprovalCustomEndpoint?;
    get accessApprovalCustomEndpoint(): string | undefined;
    set accessApprovalCustomEndpoint(value: string | undefined);
    resetAccessApprovalCustomEndpoint(): void;
    get accessApprovalCustomEndpointInput(): string | undefined;
    private _accessContextManagerCustomEndpoint?;
    get accessContextManagerCustomEndpoint(): string | undefined;
    set accessContextManagerCustomEndpoint(value: string | undefined);
    resetAccessContextManagerCustomEndpoint(): void;
    get accessContextManagerCustomEndpointInput(): string | undefined;
    private _accessToken?;
    get accessToken(): string | undefined;
    set accessToken(value: string | undefined);
    resetAccessToken(): void;
    get accessTokenInput(): string | undefined;
    private _activeDirectoryCustomEndpoint?;
    get activeDirectoryCustomEndpoint(): string | undefined;
    set activeDirectoryCustomEndpoint(value: string | undefined);
    resetActiveDirectoryCustomEndpoint(): void;
    get activeDirectoryCustomEndpointInput(): string | undefined;
    private _apiGatewayCustomEndpoint?;
    get apiGatewayCustomEndpoint(): string | undefined;
    set apiGatewayCustomEndpoint(value: string | undefined);
    resetApiGatewayCustomEndpoint(): void;
    get apiGatewayCustomEndpointInput(): string | undefined;
    private _apigeeCustomEndpoint?;
    get apigeeCustomEndpoint(): string | undefined;
    set apigeeCustomEndpoint(value: string | undefined);
    resetApigeeCustomEndpoint(): void;
    get apigeeCustomEndpointInput(): string | undefined;
    private _apikeysCustomEndpoint?;
    get apikeysCustomEndpoint(): string | undefined;
    set apikeysCustomEndpoint(value: string | undefined);
    resetApikeysCustomEndpoint(): void;
    get apikeysCustomEndpointInput(): string | undefined;
    private _appEngineCustomEndpoint?;
    get appEngineCustomEndpoint(): string | undefined;
    set appEngineCustomEndpoint(value: string | undefined);
    resetAppEngineCustomEndpoint(): void;
    get appEngineCustomEndpointInput(): string | undefined;
    private _artifactRegistryCustomEndpoint?;
    get artifactRegistryCustomEndpoint(): string | undefined;
    set artifactRegistryCustomEndpoint(value: string | undefined);
    resetArtifactRegistryCustomEndpoint(): void;
    get artifactRegistryCustomEndpointInput(): string | undefined;
    private _assuredWorkloadsCustomEndpoint?;
    get assuredWorkloadsCustomEndpoint(): string | undefined;
    set assuredWorkloadsCustomEndpoint(value: string | undefined);
    resetAssuredWorkloadsCustomEndpoint(): void;
    get assuredWorkloadsCustomEndpointInput(): string | undefined;
    private _bigQueryCustomEndpoint?;
    get bigQueryCustomEndpoint(): string | undefined;
    set bigQueryCustomEndpoint(value: string | undefined);
    resetBigQueryCustomEndpoint(): void;
    get bigQueryCustomEndpointInput(): string | undefined;
    private _bigqueryAnalyticsHubCustomEndpoint?;
    get bigqueryAnalyticsHubCustomEndpoint(): string | undefined;
    set bigqueryAnalyticsHubCustomEndpoint(value: string | undefined);
    resetBigqueryAnalyticsHubCustomEndpoint(): void;
    get bigqueryAnalyticsHubCustomEndpointInput(): string | undefined;
    private _bigqueryConnectionCustomEndpoint?;
    get bigqueryConnectionCustomEndpoint(): string | undefined;
    set bigqueryConnectionCustomEndpoint(value: string | undefined);
    resetBigqueryConnectionCustomEndpoint(): void;
    get bigqueryConnectionCustomEndpointInput(): string | undefined;
    private _bigqueryDataTransferCustomEndpoint?;
    get bigqueryDataTransferCustomEndpoint(): string | undefined;
    set bigqueryDataTransferCustomEndpoint(value: string | undefined);
    resetBigqueryDataTransferCustomEndpoint(): void;
    get bigqueryDataTransferCustomEndpointInput(): string | undefined;
    private _bigqueryReservationCustomEndpoint?;
    get bigqueryReservationCustomEndpoint(): string | undefined;
    set bigqueryReservationCustomEndpoint(value: string | undefined);
    resetBigqueryReservationCustomEndpoint(): void;
    get bigqueryReservationCustomEndpointInput(): string | undefined;
    private _bigtableCustomEndpoint?;
    get bigtableCustomEndpoint(): string | undefined;
    set bigtableCustomEndpoint(value: string | undefined);
    resetBigtableCustomEndpoint(): void;
    get bigtableCustomEndpointInput(): string | undefined;
    private _billingCustomEndpoint?;
    get billingCustomEndpoint(): string | undefined;
    set billingCustomEndpoint(value: string | undefined);
    resetBillingCustomEndpoint(): void;
    get billingCustomEndpointInput(): string | undefined;
    private _billingProject?;
    get billingProject(): string | undefined;
    set billingProject(value: string | undefined);
    resetBillingProject(): void;
    get billingProjectInput(): string | undefined;
    private _binaryAuthorizationCustomEndpoint?;
    get binaryAuthorizationCustomEndpoint(): string | undefined;
    set binaryAuthorizationCustomEndpoint(value: string | undefined);
    resetBinaryAuthorizationCustomEndpoint(): void;
    get binaryAuthorizationCustomEndpointInput(): string | undefined;
    private _certificateManagerCustomEndpoint?;
    get certificateManagerCustomEndpoint(): string | undefined;
    set certificateManagerCustomEndpoint(value: string | undefined);
    resetCertificateManagerCustomEndpoint(): void;
    get certificateManagerCustomEndpointInput(): string | undefined;
    private _cloudAssetCustomEndpoint?;
    get cloudAssetCustomEndpoint(): string | undefined;
    set cloudAssetCustomEndpoint(value: string | undefined);
    resetCloudAssetCustomEndpoint(): void;
    get cloudAssetCustomEndpointInput(): string | undefined;
    private _cloudBillingCustomEndpoint?;
    get cloudBillingCustomEndpoint(): string | undefined;
    set cloudBillingCustomEndpoint(value: string | undefined);
    resetCloudBillingCustomEndpoint(): void;
    get cloudBillingCustomEndpointInput(): string | undefined;
    private _cloudBuildCustomEndpoint?;
    get cloudBuildCustomEndpoint(): string | undefined;
    set cloudBuildCustomEndpoint(value: string | undefined);
    resetCloudBuildCustomEndpoint(): void;
    get cloudBuildCustomEndpointInput(): string | undefined;
    private _cloudBuildWorkerPoolCustomEndpoint?;
    get cloudBuildWorkerPoolCustomEndpoint(): string | undefined;
    set cloudBuildWorkerPoolCustomEndpoint(value: string | undefined);
    resetCloudBuildWorkerPoolCustomEndpoint(): void;
    get cloudBuildWorkerPoolCustomEndpointInput(): string | undefined;
    private _cloudFunctionsCustomEndpoint?;
    get cloudFunctionsCustomEndpoint(): string | undefined;
    set cloudFunctionsCustomEndpoint(value: string | undefined);
    resetCloudFunctionsCustomEndpoint(): void;
    get cloudFunctionsCustomEndpointInput(): string | undefined;
    private _cloudIdentityCustomEndpoint?;
    get cloudIdentityCustomEndpoint(): string | undefined;
    set cloudIdentityCustomEndpoint(value: string | undefined);
    resetCloudIdentityCustomEndpoint(): void;
    get cloudIdentityCustomEndpointInput(): string | undefined;
    private _cloudIotCustomEndpoint?;
    get cloudIotCustomEndpoint(): string | undefined;
    set cloudIotCustomEndpoint(value: string | undefined);
    resetCloudIotCustomEndpoint(): void;
    get cloudIotCustomEndpointInput(): string | undefined;
    private _cloudResourceManagerCustomEndpoint?;
    get cloudResourceManagerCustomEndpoint(): string | undefined;
    set cloudResourceManagerCustomEndpoint(value: string | undefined);
    resetCloudResourceManagerCustomEndpoint(): void;
    get cloudResourceManagerCustomEndpointInput(): string | undefined;
    private _cloudRunCustomEndpoint?;
    get cloudRunCustomEndpoint(): string | undefined;
    set cloudRunCustomEndpoint(value: string | undefined);
    resetCloudRunCustomEndpoint(): void;
    get cloudRunCustomEndpointInput(): string | undefined;
    private _cloudSchedulerCustomEndpoint?;
    get cloudSchedulerCustomEndpoint(): string | undefined;
    set cloudSchedulerCustomEndpoint(value: string | undefined);
    resetCloudSchedulerCustomEndpoint(): void;
    get cloudSchedulerCustomEndpointInput(): string | undefined;
    private _cloudTasksCustomEndpoint?;
    get cloudTasksCustomEndpoint(): string | undefined;
    set cloudTasksCustomEndpoint(value: string | undefined);
    resetCloudTasksCustomEndpoint(): void;
    get cloudTasksCustomEndpointInput(): string | undefined;
    private _clouddeployCustomEndpoint?;
    get clouddeployCustomEndpoint(): string | undefined;
    set clouddeployCustomEndpoint(value: string | undefined);
    resetClouddeployCustomEndpoint(): void;
    get clouddeployCustomEndpointInput(): string | undefined;
    private _cloudfunctions2CustomEndpoint?;
    get cloudfunctions2CustomEndpoint(): string | undefined;
    set cloudfunctions2CustomEndpoint(value: string | undefined);
    resetCloudfunctions2CustomEndpoint(): void;
    get cloudfunctions2CustomEndpointInput(): string | undefined;
    private _composerCustomEndpoint?;
    get composerCustomEndpoint(): string | undefined;
    set composerCustomEndpoint(value: string | undefined);
    resetComposerCustomEndpoint(): void;
    get composerCustomEndpointInput(): string | undefined;
    private _computeCustomEndpoint?;
    get computeCustomEndpoint(): string | undefined;
    set computeCustomEndpoint(value: string | undefined);
    resetComputeCustomEndpoint(): void;
    get computeCustomEndpointInput(): string | undefined;
    private _containerAnalysisCustomEndpoint?;
    get containerAnalysisCustomEndpoint(): string | undefined;
    set containerAnalysisCustomEndpoint(value: string | undefined);
    resetContainerAnalysisCustomEndpoint(): void;
    get containerAnalysisCustomEndpointInput(): string | undefined;
    private _containerAwsCustomEndpoint?;
    get containerAwsCustomEndpoint(): string | undefined;
    set containerAwsCustomEndpoint(value: string | undefined);
    resetContainerAwsCustomEndpoint(): void;
    get containerAwsCustomEndpointInput(): string | undefined;
    private _containerAzureCustomEndpoint?;
    get containerAzureCustomEndpoint(): string | undefined;
    set containerAzureCustomEndpoint(value: string | undefined);
    resetContainerAzureCustomEndpoint(): void;
    get containerAzureCustomEndpointInput(): string | undefined;
    private _containerCustomEndpoint?;
    get containerCustomEndpoint(): string | undefined;
    set containerCustomEndpoint(value: string | undefined);
    resetContainerCustomEndpoint(): void;
    get containerCustomEndpointInput(): string | undefined;
    private _credentials?;
    get credentials(): string | undefined;
    set credentials(value: string | undefined);
    resetCredentials(): void;
    get credentialsInput(): string | undefined;
    private _dataCatalogCustomEndpoint?;
    get dataCatalogCustomEndpoint(): string | undefined;
    set dataCatalogCustomEndpoint(value: string | undefined);
    resetDataCatalogCustomEndpoint(): void;
    get dataCatalogCustomEndpointInput(): string | undefined;
    private _dataFusionCustomEndpoint?;
    get dataFusionCustomEndpoint(): string | undefined;
    set dataFusionCustomEndpoint(value: string | undefined);
    resetDataFusionCustomEndpoint(): void;
    get dataFusionCustomEndpointInput(): string | undefined;
    private _dataLossPreventionCustomEndpoint?;
    get dataLossPreventionCustomEndpoint(): string | undefined;
    set dataLossPreventionCustomEndpoint(value: string | undefined);
    resetDataLossPreventionCustomEndpoint(): void;
    get dataLossPreventionCustomEndpointInput(): string | undefined;
    private _dataflowCustomEndpoint?;
    get dataflowCustomEndpoint(): string | undefined;
    set dataflowCustomEndpoint(value: string | undefined);
    resetDataflowCustomEndpoint(): void;
    get dataflowCustomEndpointInput(): string | undefined;
    private _dataplexCustomEndpoint?;
    get dataplexCustomEndpoint(): string | undefined;
    set dataplexCustomEndpoint(value: string | undefined);
    resetDataplexCustomEndpoint(): void;
    get dataplexCustomEndpointInput(): string | undefined;
    private _dataprocCustomEndpoint?;
    get dataprocCustomEndpoint(): string | undefined;
    set dataprocCustomEndpoint(value: string | undefined);
    resetDataprocCustomEndpoint(): void;
    get dataprocCustomEndpointInput(): string | undefined;
    private _dataprocMetastoreCustomEndpoint?;
    get dataprocMetastoreCustomEndpoint(): string | undefined;
    set dataprocMetastoreCustomEndpoint(value: string | undefined);
    resetDataprocMetastoreCustomEndpoint(): void;
    get dataprocMetastoreCustomEndpointInput(): string | undefined;
    private _datastoreCustomEndpoint?;
    get datastoreCustomEndpoint(): string | undefined;
    set datastoreCustomEndpoint(value: string | undefined);
    resetDatastoreCustomEndpoint(): void;
    get datastoreCustomEndpointInput(): string | undefined;
    private _datastreamCustomEndpoint?;
    get datastreamCustomEndpoint(): string | undefined;
    set datastreamCustomEndpoint(value: string | undefined);
    resetDatastreamCustomEndpoint(): void;
    get datastreamCustomEndpointInput(): string | undefined;
    private _deploymentManagerCustomEndpoint?;
    get deploymentManagerCustomEndpoint(): string | undefined;
    set deploymentManagerCustomEndpoint(value: string | undefined);
    resetDeploymentManagerCustomEndpoint(): void;
    get deploymentManagerCustomEndpointInput(): string | undefined;
    private _dialogflowCustomEndpoint?;
    get dialogflowCustomEndpoint(): string | undefined;
    set dialogflowCustomEndpoint(value: string | undefined);
    resetDialogflowCustomEndpoint(): void;
    get dialogflowCustomEndpointInput(): string | undefined;
    private _dialogflowCxCustomEndpoint?;
    get dialogflowCxCustomEndpoint(): string | undefined;
    set dialogflowCxCustomEndpoint(value: string | undefined);
    resetDialogflowCxCustomEndpoint(): void;
    get dialogflowCxCustomEndpointInput(): string | undefined;
    private _dnsCustomEndpoint?;
    get dnsCustomEndpoint(): string | undefined;
    set dnsCustomEndpoint(value: string | undefined);
    resetDnsCustomEndpoint(): void;
    get dnsCustomEndpointInput(): string | undefined;
    private _documentAiCustomEndpoint?;
    get documentAiCustomEndpoint(): string | undefined;
    set documentAiCustomEndpoint(value: string | undefined);
    resetDocumentAiCustomEndpoint(): void;
    get documentAiCustomEndpointInput(): string | undefined;
    private _essentialContactsCustomEndpoint?;
    get essentialContactsCustomEndpoint(): string | undefined;
    set essentialContactsCustomEndpoint(value: string | undefined);
    resetEssentialContactsCustomEndpoint(): void;
    get essentialContactsCustomEndpointInput(): string | undefined;
    private _eventarcCustomEndpoint?;
    get eventarcCustomEndpoint(): string | undefined;
    set eventarcCustomEndpoint(value: string | undefined);
    resetEventarcCustomEndpoint(): void;
    get eventarcCustomEndpointInput(): string | undefined;
    private _filestoreCustomEndpoint?;
    get filestoreCustomEndpoint(): string | undefined;
    set filestoreCustomEndpoint(value: string | undefined);
    resetFilestoreCustomEndpoint(): void;
    get filestoreCustomEndpointInput(): string | undefined;
    private _firebaseCustomEndpoint?;
    get firebaseCustomEndpoint(): string | undefined;
    set firebaseCustomEndpoint(value: string | undefined);
    resetFirebaseCustomEndpoint(): void;
    get firebaseCustomEndpointInput(): string | undefined;
    private _firebaserulesCustomEndpoint?;
    get firebaserulesCustomEndpoint(): string | undefined;
    set firebaserulesCustomEndpoint(value: string | undefined);
    resetFirebaserulesCustomEndpoint(): void;
    get firebaserulesCustomEndpointInput(): string | undefined;
    private _firestoreCustomEndpoint?;
    get firestoreCustomEndpoint(): string | undefined;
    set firestoreCustomEndpoint(value: string | undefined);
    resetFirestoreCustomEndpoint(): void;
    get firestoreCustomEndpointInput(): string | undefined;
    private _gameServicesCustomEndpoint?;
    get gameServicesCustomEndpoint(): string | undefined;
    set gameServicesCustomEndpoint(value: string | undefined);
    resetGameServicesCustomEndpoint(): void;
    get gameServicesCustomEndpointInput(): string | undefined;
    private _gkeHubCustomEndpoint?;
    get gkeHubCustomEndpoint(): string | undefined;
    set gkeHubCustomEndpoint(value: string | undefined);
    resetGkeHubCustomEndpoint(): void;
    get gkeHubCustomEndpointInput(): string | undefined;
    private _gkehubFeatureCustomEndpoint?;
    get gkehubFeatureCustomEndpoint(): string | undefined;
    set gkehubFeatureCustomEndpoint(value: string | undefined);
    resetGkehubFeatureCustomEndpoint(): void;
    get gkehubFeatureCustomEndpointInput(): string | undefined;
    private _healthcareCustomEndpoint?;
    get healthcareCustomEndpoint(): string | undefined;
    set healthcareCustomEndpoint(value: string | undefined);
    resetHealthcareCustomEndpoint(): void;
    get healthcareCustomEndpointInput(): string | undefined;
    private _iam2CustomEndpoint?;
    get iam2CustomEndpoint(): string | undefined;
    set iam2CustomEndpoint(value: string | undefined);
    resetIam2CustomEndpoint(): void;
    get iam2CustomEndpointInput(): string | undefined;
    private _iamBetaCustomEndpoint?;
    get iamBetaCustomEndpoint(): string | undefined;
    set iamBetaCustomEndpoint(value: string | undefined);
    resetIamBetaCustomEndpoint(): void;
    get iamBetaCustomEndpointInput(): string | undefined;
    private _iamCredentialsCustomEndpoint?;
    get iamCredentialsCustomEndpoint(): string | undefined;
    set iamCredentialsCustomEndpoint(value: string | undefined);
    resetIamCredentialsCustomEndpoint(): void;
    get iamCredentialsCustomEndpointInput(): string | undefined;
    private _iamCustomEndpoint?;
    get iamCustomEndpoint(): string | undefined;
    set iamCustomEndpoint(value: string | undefined);
    resetIamCustomEndpoint(): void;
    get iamCustomEndpointInput(): string | undefined;
    private _iapCustomEndpoint?;
    get iapCustomEndpoint(): string | undefined;
    set iapCustomEndpoint(value: string | undefined);
    resetIapCustomEndpoint(): void;
    get iapCustomEndpointInput(): string | undefined;
    private _identityPlatformCustomEndpoint?;
    get identityPlatformCustomEndpoint(): string | undefined;
    set identityPlatformCustomEndpoint(value: string | undefined);
    resetIdentityPlatformCustomEndpoint(): void;
    get identityPlatformCustomEndpointInput(): string | undefined;
    private _impersonateServiceAccount?;
    get impersonateServiceAccount(): string | undefined;
    set impersonateServiceAccount(value: string | undefined);
    resetImpersonateServiceAccount(): void;
    get impersonateServiceAccountInput(): string | undefined;
    private _impersonateServiceAccountDelegates?;
    get impersonateServiceAccountDelegates(): string[] | undefined;
    set impersonateServiceAccountDelegates(value: string[] | undefined);
    resetImpersonateServiceAccountDelegates(): void;
    get impersonateServiceAccountDelegatesInput(): string[] | undefined;
    private _kmsCustomEndpoint?;
    get kmsCustomEndpoint(): string | undefined;
    set kmsCustomEndpoint(value: string | undefined);
    resetKmsCustomEndpoint(): void;
    get kmsCustomEndpointInput(): string | undefined;
    private _loggingCustomEndpoint?;
    get loggingCustomEndpoint(): string | undefined;
    set loggingCustomEndpoint(value: string | undefined);
    resetLoggingCustomEndpoint(): void;
    get loggingCustomEndpointInput(): string | undefined;
    private _memcacheCustomEndpoint?;
    get memcacheCustomEndpoint(): string | undefined;
    set memcacheCustomEndpoint(value: string | undefined);
    resetMemcacheCustomEndpoint(): void;
    get memcacheCustomEndpointInput(): string | undefined;
    private _mlEngineCustomEndpoint?;
    get mlEngineCustomEndpoint(): string | undefined;
    set mlEngineCustomEndpoint(value: string | undefined);
    resetMlEngineCustomEndpoint(): void;
    get mlEngineCustomEndpointInput(): string | undefined;
    private _monitoringCustomEndpoint?;
    get monitoringCustomEndpoint(): string | undefined;
    set monitoringCustomEndpoint(value: string | undefined);
    resetMonitoringCustomEndpoint(): void;
    get monitoringCustomEndpointInput(): string | undefined;
    private _networkConnectivityCustomEndpoint?;
    get networkConnectivityCustomEndpoint(): string | undefined;
    set networkConnectivityCustomEndpoint(value: string | undefined);
    resetNetworkConnectivityCustomEndpoint(): void;
    get networkConnectivityCustomEndpointInput(): string | undefined;
    private _networkManagementCustomEndpoint?;
    get networkManagementCustomEndpoint(): string | undefined;
    set networkManagementCustomEndpoint(value: string | undefined);
    resetNetworkManagementCustomEndpoint(): void;
    get networkManagementCustomEndpointInput(): string | undefined;
    private _networkServicesCustomEndpoint?;
    get networkServicesCustomEndpoint(): string | undefined;
    set networkServicesCustomEndpoint(value: string | undefined);
    resetNetworkServicesCustomEndpoint(): void;
    get networkServicesCustomEndpointInput(): string | undefined;
    private _notebooksCustomEndpoint?;
    get notebooksCustomEndpoint(): string | undefined;
    set notebooksCustomEndpoint(value: string | undefined);
    resetNotebooksCustomEndpoint(): void;
    get notebooksCustomEndpointInput(): string | undefined;
    private _orgPolicyCustomEndpoint?;
    get orgPolicyCustomEndpoint(): string | undefined;
    set orgPolicyCustomEndpoint(value: string | undefined);
    resetOrgPolicyCustomEndpoint(): void;
    get orgPolicyCustomEndpointInput(): string | undefined;
    private _osConfigCustomEndpoint?;
    get osConfigCustomEndpoint(): string | undefined;
    set osConfigCustomEndpoint(value: string | undefined);
    resetOsConfigCustomEndpoint(): void;
    get osConfigCustomEndpointInput(): string | undefined;
    private _osLoginCustomEndpoint?;
    get osLoginCustomEndpoint(): string | undefined;
    set osLoginCustomEndpoint(value: string | undefined);
    resetOsLoginCustomEndpoint(): void;
    get osLoginCustomEndpointInput(): string | undefined;
    private _privatecaCustomEndpoint?;
    get privatecaCustomEndpoint(): string | undefined;
    set privatecaCustomEndpoint(value: string | undefined);
    resetPrivatecaCustomEndpoint(): void;
    get privatecaCustomEndpointInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _pubsubCustomEndpoint?;
    get pubsubCustomEndpoint(): string | undefined;
    set pubsubCustomEndpoint(value: string | undefined);
    resetPubsubCustomEndpoint(): void;
    get pubsubCustomEndpointInput(): string | undefined;
    private _pubsubLiteCustomEndpoint?;
    get pubsubLiteCustomEndpoint(): string | undefined;
    set pubsubLiteCustomEndpoint(value: string | undefined);
    resetPubsubLiteCustomEndpoint(): void;
    get pubsubLiteCustomEndpointInput(): string | undefined;
    private _recaptchaEnterpriseCustomEndpoint?;
    get recaptchaEnterpriseCustomEndpoint(): string | undefined;
    set recaptchaEnterpriseCustomEndpoint(value: string | undefined);
    resetRecaptchaEnterpriseCustomEndpoint(): void;
    get recaptchaEnterpriseCustomEndpointInput(): string | undefined;
    private _redisCustomEndpoint?;
    get redisCustomEndpoint(): string | undefined;
    set redisCustomEndpoint(value: string | undefined);
    resetRedisCustomEndpoint(): void;
    get redisCustomEndpointInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _requestReason?;
    get requestReason(): string | undefined;
    set requestReason(value: string | undefined);
    resetRequestReason(): void;
    get requestReasonInput(): string | undefined;
    private _requestTimeout?;
    get requestTimeout(): string | undefined;
    set requestTimeout(value: string | undefined);
    resetRequestTimeout(): void;
    get requestTimeoutInput(): string | undefined;
    private _resourceManagerCustomEndpoint?;
    get resourceManagerCustomEndpoint(): string | undefined;
    set resourceManagerCustomEndpoint(value: string | undefined);
    resetResourceManagerCustomEndpoint(): void;
    get resourceManagerCustomEndpointInput(): string | undefined;
    private _resourceManagerV3CustomEndpoint?;
    get resourceManagerV3CustomEndpoint(): string | undefined;
    set resourceManagerV3CustomEndpoint(value: string | undefined);
    resetResourceManagerV3CustomEndpoint(): void;
    get resourceManagerV3CustomEndpointInput(): string | undefined;
    private _runtimeConfigCustomEndpoint?;
    get runtimeConfigCustomEndpoint(): string | undefined;
    set runtimeConfigCustomEndpoint(value: string | undefined);
    resetRuntimeConfigCustomEndpoint(): void;
    get runtimeConfigCustomEndpointInput(): string | undefined;
    private _runtimeconfigCustomEndpoint?;
    get runtimeconfigCustomEndpoint(): string | undefined;
    set runtimeconfigCustomEndpoint(value: string | undefined);
    resetRuntimeconfigCustomEndpoint(): void;
    get runtimeconfigCustomEndpointInput(): string | undefined;
    private _scopes?;
    get scopes(): string[] | undefined;
    set scopes(value: string[] | undefined);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    private _secretManagerCustomEndpoint?;
    get secretManagerCustomEndpoint(): string | undefined;
    set secretManagerCustomEndpoint(value: string | undefined);
    resetSecretManagerCustomEndpoint(): void;
    get secretManagerCustomEndpointInput(): string | undefined;
    private _securityCenterCustomEndpoint?;
    get securityCenterCustomEndpoint(): string | undefined;
    set securityCenterCustomEndpoint(value: string | undefined);
    resetSecurityCenterCustomEndpoint(): void;
    get securityCenterCustomEndpointInput(): string | undefined;
    private _securityScannerCustomEndpoint?;
    get securityScannerCustomEndpoint(): string | undefined;
    set securityScannerCustomEndpoint(value: string | undefined);
    resetSecurityScannerCustomEndpoint(): void;
    get securityScannerCustomEndpointInput(): string | undefined;
    private _serviceDirectoryCustomEndpoint?;
    get serviceDirectoryCustomEndpoint(): string | undefined;
    set serviceDirectoryCustomEndpoint(value: string | undefined);
    resetServiceDirectoryCustomEndpoint(): void;
    get serviceDirectoryCustomEndpointInput(): string | undefined;
    private _serviceManagementCustomEndpoint?;
    get serviceManagementCustomEndpoint(): string | undefined;
    set serviceManagementCustomEndpoint(value: string | undefined);
    resetServiceManagementCustomEndpoint(): void;
    get serviceManagementCustomEndpointInput(): string | undefined;
    private _serviceNetworkingCustomEndpoint?;
    get serviceNetworkingCustomEndpoint(): string | undefined;
    set serviceNetworkingCustomEndpoint(value: string | undefined);
    resetServiceNetworkingCustomEndpoint(): void;
    get serviceNetworkingCustomEndpointInput(): string | undefined;
    private _serviceUsageCustomEndpoint?;
    get serviceUsageCustomEndpoint(): string | undefined;
    set serviceUsageCustomEndpoint(value: string | undefined);
    resetServiceUsageCustomEndpoint(): void;
    get serviceUsageCustomEndpointInput(): string | undefined;
    private _sourceRepoCustomEndpoint?;
    get sourceRepoCustomEndpoint(): string | undefined;
    set sourceRepoCustomEndpoint(value: string | undefined);
    resetSourceRepoCustomEndpoint(): void;
    get sourceRepoCustomEndpointInput(): string | undefined;
    private _spannerCustomEndpoint?;
    get spannerCustomEndpoint(): string | undefined;
    set spannerCustomEndpoint(value: string | undefined);
    resetSpannerCustomEndpoint(): void;
    get spannerCustomEndpointInput(): string | undefined;
    private _sqlCustomEndpoint?;
    get sqlCustomEndpoint(): string | undefined;
    set sqlCustomEndpoint(value: string | undefined);
    resetSqlCustomEndpoint(): void;
    get sqlCustomEndpointInput(): string | undefined;
    private _storageCustomEndpoint?;
    get storageCustomEndpoint(): string | undefined;
    set storageCustomEndpoint(value: string | undefined);
    resetStorageCustomEndpoint(): void;
    get storageCustomEndpointInput(): string | undefined;
    private _storageTransferCustomEndpoint?;
    get storageTransferCustomEndpoint(): string | undefined;
    set storageTransferCustomEndpoint(value: string | undefined);
    resetStorageTransferCustomEndpoint(): void;
    get storageTransferCustomEndpointInput(): string | undefined;
    private _tagsCustomEndpoint?;
    get tagsCustomEndpoint(): string | undefined;
    set tagsCustomEndpoint(value: string | undefined);
    resetTagsCustomEndpoint(): void;
    get tagsCustomEndpointInput(): string | undefined;
    private _tpuCustomEndpoint?;
    get tpuCustomEndpoint(): string | undefined;
    set tpuCustomEndpoint(value: string | undefined);
    resetTpuCustomEndpoint(): void;
    get tpuCustomEndpointInput(): string | undefined;
    private _userProjectOverride?;
    get userProjectOverride(): boolean | cdktf.IResolvable | undefined;
    set userProjectOverride(value: boolean | cdktf.IResolvable | undefined);
    resetUserProjectOverride(): void;
    get userProjectOverrideInput(): boolean | cdktf.IResolvable | undefined;
    private _vertexAiCustomEndpoint?;
    get vertexAiCustomEndpoint(): string | undefined;
    set vertexAiCustomEndpoint(value: string | undefined);
    resetVertexAiCustomEndpoint(): void;
    get vertexAiCustomEndpointInput(): string | undefined;
    private _vpcAccessCustomEndpoint?;
    get vpcAccessCustomEndpoint(): string | undefined;
    set vpcAccessCustomEndpoint(value: string | undefined);
    resetVpcAccessCustomEndpoint(): void;
    get vpcAccessCustomEndpointInput(): string | undefined;
    private _workflowsCustomEndpoint?;
    get workflowsCustomEndpoint(): string | undefined;
    set workflowsCustomEndpoint(value: string | undefined);
    resetWorkflowsCustomEndpoint(): void;
    get workflowsCustomEndpointInput(): string | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _batching?;
    get batching(): GoogleBetaProviderBatching | undefined;
    set batching(value: GoogleBetaProviderBatching | undefined);
    resetBatching(): void;
    get batchingInput(): GoogleBetaProviderBatching | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
