# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class DRSAccessMethod(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'access_url': 'DRSAccessURL',
        'access_id': 'str',
        'region': 'str',
        'authorizations': 'DRSAuthorizations'
    }

    attribute_map = {
        'type': 'type',
        'access_url': 'access_url',
        'access_id': 'access_id',
        'region': 'region',
        'authorizations': 'authorizations'
    }

    def __init__(self, type=None, access_url=None, access_id=None, region=None, authorizations=None, local_vars_configuration=None):  # noqa: E501
        """DRSAccessMethod - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._access_url = None
        self._access_id = None
        self._region = None
        self._authorizations = None
        self.discriminator = None

        self.type = type
        if access_url is not None:
            self.access_url = access_url
        if access_id is not None:
            self.access_id = access_id
        if region is not None:
            self.region = region
        if authorizations is not None:
            self.authorizations = authorizations

    @property
    def type(self):
        """Gets the type of this DRSAccessMethod.  # noqa: E501

        Type of the access method.  # noqa: E501

        :return: The type of this DRSAccessMethod.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this DRSAccessMethod.

        Type of the access method.  # noqa: E501

        :param type: The type of this DRSAccessMethod.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["s3", "gs", "ftp", "gsiftp", "globus", "htsget", "https", "file"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def access_url(self):
        """Gets the access_url of this DRSAccessMethod.  # noqa: E501


        :return: The access_url of this DRSAccessMethod.  # noqa: E501
        :rtype: DRSAccessURL
        """
        return self._access_url

    @access_url.setter
    def access_url(self, access_url):
        """Sets the access_url of this DRSAccessMethod.


        :param access_url: The access_url of this DRSAccessMethod.  # noqa: E501
        :type: DRSAccessURL
        """

        self._access_url = access_url

    @property
    def access_id(self):
        """Gets the access_id of this DRSAccessMethod.  # noqa: E501

        An arbitrary string to be passed to the `/access` path to get an `AccessURL`. This must be unique per object. Note that at least one of `access_url` and `access_id` must be provided.  # noqa: E501

        :return: The access_id of this DRSAccessMethod.  # noqa: E501
        :rtype: str
        """
        return self._access_id

    @access_id.setter
    def access_id(self, access_id):
        """Sets the access_id of this DRSAccessMethod.

        An arbitrary string to be passed to the `/access` path to get an `AccessURL`. This must be unique per object. Note that at least one of `access_url` and `access_id` must be provided.  # noqa: E501

        :param access_id: The access_id of this DRSAccessMethod.  # noqa: E501
        :type: str
        """

        self._access_id = access_id

    @property
    def region(self):
        """Gets the region of this DRSAccessMethod.  # noqa: E501

        Name of the region in the cloud service provider that the object belongs to.  # noqa: E501

        :return: The region of this DRSAccessMethod.  # noqa: E501
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """Sets the region of this DRSAccessMethod.

        Name of the region in the cloud service provider that the object belongs to.  # noqa: E501

        :param region: The region of this DRSAccessMethod.  # noqa: E501
        :type: str
        """

        self._region = region

    @property
    def authorizations(self):
        """Gets the authorizations of this DRSAccessMethod.  # noqa: E501


        :return: The authorizations of this DRSAccessMethod.  # noqa: E501
        :rtype: DRSAuthorizations
        """
        return self._authorizations

    @authorizations.setter
    def authorizations(self, authorizations):
        """Sets the authorizations of this DRSAccessMethod.


        :param authorizations: The authorizations of this DRSAccessMethod.  # noqa: E501
        :type: DRSAuthorizations
        """

        self._authorizations = authorizations

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DRSAccessMethod):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DRSAccessMethod):
            return True

        return self.to_dict() != other.to_dict()
