import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [cognito-idp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncognitouserpools.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class CognitoIdp extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [cognito-idp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncognitouserpools.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Adds additional user attributes to the user pool schema
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AddCustomAttributes.html
     */
    toAddCustomAttributes(): this;
    /**
     * Adds the specified user to the specified group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminAddUserToGroup.html
     */
    toAdminAddUserToGroup(): this;
    /**
     * Confirms user registration as an admin without using a confirmation code. Works on any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminConfirmSignUp.html
     */
    toAdminConfirmSignUp(): this;
    /**
     * Creates a new user in the specified user pool and sends a welcome message via email or phone (SMS)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html
     */
    toAdminCreateUser(): this;
    /**
     * Deletes a user as an administrator. Works on any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDeleteUser.html
     */
    toAdminDeleteUser(): this;
    /**
     * Deletes the user attributes in a user pool as an administrator. Works on any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDeleteUserAttributes.html
     */
    toAdminDeleteUserAttributes(): this;
    /**
     * Disables the user from signing in with the specified external (SAML or social) identity provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDisableProviderForUser.html
     */
    toAdminDisableProviderForUser(): this;
    /**
     * Disables the specified user as an administrator. Works on any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDisableUser.html
     */
    toAdminDisableUser(): this;
    /**
     * Enables the specified user as an administrator. Works on any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminEnableUser.html
     */
    toAdminEnableUser(): this;
    /**
     * Forgets the device, as an administrator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminForgetDevice.html
     */
    toAdminForgetDevice(): this;
    /**
     * Gets the device, as an administrator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminGetDevice.html
     */
    toAdminGetDevice(): this;
    /**
     * Gets the specified user by user name in a user pool as an administrator. Works on any user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminGetUser.html
     */
    toAdminGetUser(): this;
    /**
     * Authenticates a user in a user pool as an administrator. Works on any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html
     */
    toAdminInitiateAuth(): this;
    /**
     * Links an existing user account in a user pool (DestinationUser) to an identity from an external identity provider (SourceUser) based on a specified attribute name and value from the external identity provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html
     */
    toAdminLinkProviderForUser(): this;
    /**
     * Lists devices, as an administrator
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminListDevices.html
     */
    toAdminListDevices(): this;
    /**
     * Lists the groups that the user belongs to
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminListGroupsForUser.html
     */
    toAdminListGroupsForUser(): this;
    /**
     * Lists the authentication events for the user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminListUserAuthEvents.html
     */
    toAdminListUserAuthEvents(): this;
    /**
     * Removes the specified user from the specified group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminRemoveUserFromGroup.html
     */
    toAdminRemoveUserFromGroup(): this;
    /**
     * Resets the specified user's password in a user pool as an administrator. Works on any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminResetUserPassword.html
     */
    toAdminResetUserPassword(): this;
    /**
     * Responds to an authentication challenge, as an administrator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminRespondToAuthChallenge.html
     */
    toAdminRespondToAuthChallenge(): this;
    /**
     * Sets MFA preference for the user in the userpool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html
     */
    toAdminSetUserMFAPreference(): this;
    /**
     * Sets the specified user's password in a user pool as an administrator. Works on any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html
     */
    toAdminSetUserPassword(): this;
    /**
     * Sets all the user settings for a specified user name. Works on any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserSettings.html
     */
    toAdminSetUserSettings(): this;
    /**
     * Updates the feedback for the user authentication event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateAuthEventFeedback.html
     */
    toAdminUpdateAuthEventFeedback(): this;
    /**
     * Updates the device status as an administrator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateDeviceStatus.html
     */
    toAdminUpdateDeviceStatus(): this;
    /**
     * Updates the specified user's attributes, including developer attributes, as an administrator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html
     */
    toAdminUpdateUserAttributes(): this;
    /**
     * Signs out users from all devices, as an administrator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUserGlobalSignOut.html
     */
    toAdminUserGlobalSignOut(): this;
    /**
     * Returns a unique generated shared secret key code for the user account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html
     */
    toAssociateSoftwareToken(): this;
    /**
     * Changes the password for a specified user in a user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ChangePassword.html
     */
    toChangePassword(): this;
    /**
     * Confirms tracking of the device. This API call is the call that begins device tracking
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html
     */
    toConfirmDevice(): this;
    /**
     * Allows a user to enter a confirmation code to reset a forgotten password
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html
     */
    toConfirmForgotPassword(): this;
    /**
     * Confirms registration of a user and handles the existing alias from a previous user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmSignUp.html
     */
    toConfirmSignUp(): this;
    /**
     * Creates a new group in the specified user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html
     */
    toCreateGroup(): this;
    /**
     * Creates an identity provider for a user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html
     */
    toCreateIdentityProvider(): this;
    /**
     * Creates a new OAuth2.0 resource server and defines custom scopes in it
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateResourceServer.html
     */
    toCreateResourceServer(): this;
    /**
     * Creates the user import job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserImportJob.html
     */
    toCreateUserImportJob(): this;
    /**
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html
     */
    toCreateUserPool(): this;
    /**
     * Creates the user pool client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPoolClient.html
     */
    toCreateUserPoolClient(): this;
    /**
     * Creates a new domain for a user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPoolDomain.html
     */
    toCreateUserPoolDomain(): this;
    /**
     * Deletes a group. Currently only groups with no members can be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteGroup.html
     */
    toDeleteGroup(): this;
    /**
     * Deletes an identity provider for a user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteIdentityProvider.html
     */
    toDeleteIdentityProvider(): this;
    /**
     * Deletes a resource server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteResourceServer.html
     */
    toDeleteResourceServer(): this;
    /**
     * Allows a user to delete one's self
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Deletes the attributes for a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserAttributes.html
     */
    toDeleteUserAttributes(): this;
    /**
     * Deletes the specified Amazon Cognito user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserPool.html
     */
    toDeleteUserPool(): this;
    /**
     * Allows the developer to delete the user pool client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserPoolClient.html
     */
    toDeleteUserPoolClient(): this;
    /**
     * Deletes a domain for a user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserPoolDomain.html
     */
    toDeleteUserPoolDomain(): this;
    /**
     * Gets information about a specific identity provider
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeIdentityProvider.html
     */
    toDescribeIdentityProvider(): this;
    /**
     * Describes a resource server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeResourceServer.html
     */
    toDescribeResourceServer(): this;
    /**
     * Describes the risk configuration setting for the userpool / userpool client
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeRiskConfiguration.html
     */
    toDescribeRiskConfiguration(): this;
    /**
     * Describes the user import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserImportJob.html
     */
    toDescribeUserImportJob(): this;
    /**
     * Returns the configuration information and metadata of the specified user pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html
     */
    toDescribeUserPool(): this;
    /**
     * Client method for returning the configuration information and metadata of the specified user pool client
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html
     */
    toDescribeUserPoolClient(): this;
    /**
     * Gets information about a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolDomain.html
     */
    toDescribeUserPoolDomain(): this;
    /**
     * Forgets the specified device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgetDevice.html
     */
    toForgetDevice(): this;
    /**
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html
     */
    toForgotPassword(): this;
    /**
     * Gets the header information for the .csv file to be used as input for the user import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetCSVHeader.html
     */
    toGetCSVHeader(): this;
    /**
     * Gets the device
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetDevice.html
     */
    toGetDevice(): this;
    /**
     * Gets a group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetGroup.html
     */
    toGetGroup(): this;
    /**
     * Gets the specified identity provider
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetIdentityProviderByIdentifier.html
     */
    toGetIdentityProviderByIdentifier(): this;
    /**
     * Returns the signing certificate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetSigningCertificate.html
     */
    toGetSigningCertificate(): this;
    /**
     * Gets the UI Customization information for a particular app client's app UI, if there is something set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUICustomization.html
     */
    toGetUICustomization(): this;
    /**
     * Gets the user attributes and metadata for a user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html
     */
    toGetUser(): this;
    /**
     * Gets the user attribute verification code for the specified attribute name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUserAttributeVerificationCode.html
     */
    toGetUserAttributeVerificationCode(): this;
    /**
     * Gets the MFA configuration for the userpool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUserPoolMfaConfig.html
     */
    toGetUserPoolMfaConfig(): this;
    /**
     * Signs out users from all devices
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GlobalSignOut.html
     */
    toGlobalSignOut(): this;
    /**
     * Initiates the authentication flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html
     */
    toInitiateAuth(): this;
    /**
     * Lists the devices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListDevices.html
     */
    toListDevices(): this;
    /**
     * Lists the groups associated with a user pool
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListGroups.html
     */
    toListGroups(): this;
    /**
     * Lists information about all identity providers for a user pool
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListIdentityProviders.html
     */
    toListIdentityProviders(): this;
    /**
     * Lists the resource servers for a user pool
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListResourceServers.html
     */
    toListResourceServers(): this;
    /**
     * Lists the tags that are assigned to an Amazon Cognito user pool
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Lists the user import jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUserImportJobs.html
     */
    toListUserImportJobs(): this;
    /**
     * Lists the clients that have been created for the specified user pool
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUserPoolClients.html
     */
    toListUserPoolClients(): this;
    /**
     * Lists the user pools associated with an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUserPools.html
     */
    toListUserPools(): this;
    /**
     * Lists the users in the Amazon Cognito user pool
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUsers.html
     */
    toListUsers(): this;
    /**
     * Lists the users in the specified group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUsersInGroup.html
     */
    toListUsersInGroup(): this;
    /**
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ResendConfirmationCode.html
     */
    toResendConfirmationCode(): this;
    /**
     * Responds to the authentication challenge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RespondToAuthChallenge.html
     */
    toRespondToAuthChallenge(): this;
    /**
     * Revokes all of the access tokens generated by the specified refresh token
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html
     */
    toRevokeToken(): this;
    /**
     * sets the risk configuration setting for the userpool / userpool client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetRiskConfiguration.html
     */
    toSetRiskConfiguration(): this;
    /**
     * Sets the UI customization information for a user pool's built-in app UI
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUICustomization.html
     */
    toSetUICustomization(): this;
    /**
     * Sets MFA preference for the user in the userpool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html
     */
    toSetUserMFAPreference(): this;
    /**
     * Sets the MFA configuration for the userpool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html
     */
    toSetUserPoolMfaConfig(): this;
    /**
     * Sets the user settings like multi-factor authentication (MFA)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserSettings.html
     */
    toSetUserSettings(): this;
    /**
     * Registers the user in the specified user pool and creates a user name, password, and user attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SignUp.html
     */
    toSignUp(): this;
    /**
     * Starts the user import
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_StartUserImportJob.html
     */
    toStartUserImportJob(): this;
    /**
     * Stops the user import job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_StopUserImportJob.html
     */
    toStopUserImportJob(): this;
    /**
     * Assigns a set of tags to an Amazon Cognito user pool
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Removes the specified tags from an Amazon Cognito user pool
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Updates the feedback for the user authentication event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateAuthEventFeedback.html
     */
    toUpdateAuthEventFeedback(): this;
    /**
     * Updates the device status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html
     */
    toUpdateDeviceStatus(): this;
    /**
     * Updates the specified group with the specified attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateGroup.html
     */
    toUpdateGroup(): this;
    /**
     * Updates identity provider information for a user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateIdentityProvider.html
     */
    toUpdateIdentityProvider(): this;
    /**
     * Updates the name and scopes of resource server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateResourceServer.html
     */
    toUpdateResourceServer(): this;
    /**
     * Allows a user to update a specific attribute (one at a time)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html
     */
    toUpdateUserAttributes(): this;
    /**
     * Updates the specified user pool with the specified attributes
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html
     */
    toUpdateUserPool(): this;
    /**
     * Allows the developer to update the specified user pool client and password policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPoolClient.html
     */
    toUpdateUserPoolClient(): this;
    /**
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPoolDomain.html
     */
    toUpdateUserPoolDomain(): this;
    /**
     * Registers a user's entered TOTP code and mark the user's software token MFA status as verified if successful
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html
     */
    toVerifySoftwareToken(): this;
    /**
     * Verifies a user attribute using a one time verification code
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifyUserAttribute.html
     */
    toVerifyUserAttribute(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type userpool to the statement
     *
     * https://docs.aws.amazon.com/cognito/latest/developerguide/resource-permissions.html#amazon-cognito-amazon-resource-names
     *
     * @param userPoolId - Identifier for the userPoolId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUserpool(userPoolId: string, account?: string, region?: string, partition?: string): this;
}
