"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Deepracer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Deepracer extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'deepracer';
        this.accessLevelList = {
            Write: [
                'AddLeaderboardAccessPermission',
                'AdminManageUser',
                'AdminSetAccountConfig',
                'CloneReinforcementLearningModel',
                'CreateCar',
                'CreateLeaderboard',
                'CreateLeaderboardAccessToken',
                'CreateLeaderboardSubmission',
                'CreateReinforcementLearningModel',
                'DeleteLeaderboard',
                'DeleteModel',
                'EditLeaderboard',
                'ImportModel',
                'MigrateModels',
                'PerformLeaderboardOperation',
                'RemoveLeaderboardAccessPermission',
                'SetAlias',
                'StartEvaluation',
                'StopEvaluation',
                'StopTrainingReinforcementLearningModel',
                'TestRewardFunction',
                'UpdateCar'
            ],
            Read: [
                'AdminGetAccountConfig',
                'AdminListAssociatedResources',
                'AdminListAssociatedUsers',
                'GetAccountConfig',
                'GetAlias',
                'GetAssetUrl',
                'GetCar',
                'GetCars',
                'GetEvaluation',
                'GetLatestUserSubmission',
                'GetLeaderboard',
                'GetModel',
                'GetPrivateLeaderboard',
                'GetRankedUserSubmission',
                'GetTrack',
                'GetTrainingJob',
                'ListEvaluations',
                'ListLeaderboardSubmissions',
                'ListLeaderboards',
                'ListModels',
                'ListPrivateLeaderboardParticipants',
                'ListPrivateLeaderboards',
                'ListSubscribedPrivateLeaderboards',
                'ListTagsForResource',
                'ListTracks',
                'ListTrainingJobs'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to add access for a private leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toAddLeaderboardAccessPermission() {
        return this.to('AddLeaderboardAccessPermission');
    }
    /**
     * Grants permission to get current admin multiuser configuration for this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-set-account-config.html
     */
    toAdminGetAccountConfig() {
        return this.to('AdminGetAccountConfig');
    }
    /**
     * Grants permission to list all deepracer users with their associated resources created under this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-list-associated-resources.html
     */
    toAdminListAssociatedResources() {
        return this.to('AdminListAssociatedResources');
    }
    /**
     * Grants permission to list user data for all users associated with this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-list-associated-users.html
     */
    toAdminListAssociatedUsers() {
        return this.to('AdminListAssociatedUsers');
    }
    /**
     * Grants permission to manage a user associated with this account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-manage-user.html
     */
    toAdminManageUser() {
        return this.to('AdminManageUser');
    }
    /**
     * Grants permission to set configuration options for this account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-set-account-config.html
     */
    toAdminSetAccountConfig() {
        return this.to('AdminSetAccountConfig');
    }
    /**
     * Grants permission to clone an existing DeepRacer model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-clone-trained-model
     */
    toCloneReinforcementLearningModel() {
        return this.to('CloneReinforcementLearningModel');
    }
    /**
     * Grants permission to create a DeepRacer car in your garage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     */
    toCreateCar() {
        return this.to('CreateCar');
    }
    /**
     * Grants permission to create a leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-create-community-race.html
     */
    toCreateLeaderboard() {
        return this.to('CreateLeaderboard');
    }
    /**
     * Grants permission to create an access token for a private leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toCreateLeaderboardAccessToken() {
        return this.to('CreateLeaderboardAccessToken');
    }
    /**
     * Grants permission to submit a DeepRacer model to be evaluated for leaderboards
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toCreateLeaderboardSubmission() {
        return this.to('CreateLeaderboardSubmission');
    }
    /**
     * Grants permission to create ra einforcement learning model for DeepRacer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toCreateReinforcementLearningModel() {
        return this.to('CreateReinforcementLearningModel');
    }
    /**
     * Grants permission to delete a leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toDeleteLeaderboard() {
        return this.to('DeleteLeaderboard');
    }
    /**
     * Grants permission to delete a DeepRacer model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toDeleteModel() {
        return this.to('DeleteModel');
    }
    /**
     * Grants permission to edit a leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toEditLeaderboard() {
        return this.to('EditLeaderboard');
    }
    /**
     * Grants permission to get current multiuser configuration for this account
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-admin-set-account-config.html
     */
    toGetAccountConfig() {
        return this.to('GetAccountConfig');
    }
    /**
     * Grants permission to retrieve the user's alias for submitting a DeepRacer model to leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetAlias() {
        return this.to('GetAlias');
    }
    /**
     * Grants permission to download artifacts for an existing DeepRacer model
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     */
    toGetAssetUrl() {
        return this.to('GetAssetUrl');
    }
    /**
     * Grants permission to retrieve a specific DeepRacer car from your garage
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     */
    toGetCar() {
        return this.to('GetCar');
    }
    /**
     * Grants permission to view all the DeepRacer cars in your garage
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     */
    toGetCars() {
        return this.to('GetCars');
    }
    /**
     * Grants permission to retrieve information about an existing DeepRacer model's evaluation jobs
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toGetEvaluation() {
        return this.to('GetEvaluation');
    }
    /**
     * Grants permission to retrieve information about how the latest submitted DeepRacer model for a user performed on a leaderboard
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetLatestUserSubmission() {
        return this.to('GetLatestUserSubmission');
    }
    /**
     * Grants permission to retrieve information about leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetLeaderboard() {
        return this.to('GetLeaderboard');
    }
    /**
     * Grants permission to retrieve information about an existing DeepRacer model
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toGetModel() {
        return this.to('GetModel');
    }
    /**
     * Grants permission to retrieve information about private leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     */
    toGetPrivateLeaderboard() {
        return this.to('GetPrivateLeaderboard');
    }
    /**
     * Grants permission to retrieve information about the performance of a user's DeepRacer model that got placed on a leaderboard
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetRankedUserSubmission() {
        return this.to('GetRankedUserSubmission');
    }
    /**
     * Grants permission to retrieve information about DeepRacer tracks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     */
    toGetTrack() {
        return this.to('GetTrack');
    }
    /**
     * Grants permission to retrieve information about an existing DeepRacer model's training job
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toGetTrainingJob() {
        return this.to('GetTrainingJob');
    }
    /**
     * Grants permission to import a reinforcement learning model for DeepRacer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-troubleshooting-service-migration-errors.html
     */
    toImportModel() {
        return this.to('ImportModel');
    }
    /**
     * Grants permission to list a DeepRacer model's evaluation jobs
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toListEvaluations() {
        return this.to('ListEvaluations');
    }
    /**
     * Grants permission to list all the DeepRacer model submissions of a user on a leaderboard
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toListLeaderboardSubmissions() {
        return this.to('ListLeaderboardSubmissions');
    }
    /**
     * Grants permission to list all the available leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toListLeaderboards() {
        return this.to('ListLeaderboards');
    }
    /**
     * Grants permission to list all existing DeepRacer models
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toListModels() {
        return this.to('ListModels');
    }
    /**
     * Grants permission to retrieve participant information about private leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     */
    toListPrivateLeaderboardParticipants() {
        return this.to('ListPrivateLeaderboardParticipants');
    }
    /**
     * Grants permission to list all the available private leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     */
    toListPrivateLeaderboards() {
        return this.to('ListPrivateLeaderboards');
    }
    /**
     * Grants permission to list all the subscribed private leaderboards
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-join-community-race.html
     */
    toListSubscribedPrivateLeaderboards() {
        return this.to('ListSubscribedPrivateLeaderboards');
    }
    /**
     * Grants permission to lists tag for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-tagging.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list all DeepRacer tracks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     */
    toListTracks() {
        return this.to('ListTracks');
    }
    /**
     * Grants permission to list a DeepRacer model's training jobs
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toListTrainingJobs() {
        return this.to('ListTrainingJobs');
    }
    /**
     * Grants permission to migrate previous reinforcement learning models for DeepRacer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-troubleshooting-service-migration-errors.html
     */
    toMigrateModels() {
        return this.to('MigrateModels');
    }
    /**
     * Grants permission to performs the leaderboard operation mentioned in the operation attribute
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-perform-leaderboard-operation.html
     */
    toPerformLeaderboardOperation() {
        return this.to('PerformLeaderboardOperation');
    }
    /**
     * Grants permission to remove access for a private leaderboard
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-manage-community-races.html
     */
    toRemoveLeaderboardAccessPermission() {
        return this.to('RemoveLeaderboardAccessPermission');
    }
    /**
     * Grants permission to set the user's alias for submitting a DeepRacer model to leaderboards
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toSetAlias() {
        return this.to('SetAlias');
    }
    /**
     * Grants permission to evaluate a DeepRacer model in a simulated environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toStartEvaluation() {
        return this.to('StartEvaluation');
    }
    /**
     * Grants permission to stop DeepRacer model evaluations
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toStopEvaluation() {
        return this.to('StopEvaluation');
    }
    /**
     * Grants permission to stop training a DeepRacer model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toStopTrainingReinforcementLearningModel() {
        return this.to('StopTrainingReinforcementLearningModel');
    }
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-tagging.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to test reward functions for correctness
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-train-models-define-reward-function
     */
    toTestRewardFunction() {
        return this.to('TestRewardFunction');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-tagging.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a DeepRacer car in your garage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserToken()
     * - .ifMultiUser()
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     */
    toUpdateCar() {
        return this.to('UpdateCar');
    }
    /**
     * Adds a resource of type car to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-choose-race-type.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCar(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Deepracer.defaultPartition}:deepracer:${region || '*'}:${account || '*'}:car/${resourceId}`);
    }
    /**
     * Adds a resource of type evaluation_job to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEvaluationJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Deepracer.defaultPartition}:deepracer:${region || '*'}:${account || '*'}:evaluation_job/${resourceId}`);
    }
    /**
     * Adds a resource of type leaderboard to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLeaderboard(resourceId, region, partition) {
        return this.on(`arn:${partition || Deepracer.defaultPartition}:deepracer:${region || '*'}::leaderboard/${resourceId}`);
    }
    /**
     * Adds a resource of type leaderboard_evaluation_job to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLeaderboardEvaluationJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Deepracer.defaultPartition}:deepracer:${region || '*'}:${account || '*'}:leaderboard_evaluation_job/${resourceId}`);
    }
    /**
     * Adds a resource of type reinforcement_learning_model to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReinforcementLearningModel(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Deepracer.defaultPartition}:deepracer:${region || '*'}:${account || '*'}:model/reinforcement_learning/${resourceId}`);
    }
    /**
     * Adds a resource of type track to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTrack(resourceId, region, partition) {
        return this.on(`arn:${partition || Deepracer.defaultPartition}:deepracer:${region || '*'}::track/${resourceId}`);
    }
    /**
     * Adds a resource of type training_job to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrainingJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Deepracer.defaultPartition}:deepracer:${region || '*'}:${account || '*'}:training_job/${resourceId}`);
    }
    /**
     * Filters access by multiuser flag
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/reference_policies_iam-condition-keys.html#condition-keys-multiuser
     *
     * Applies to actions:
     * - .toAddLeaderboardAccessPermission()
     * - .toCloneReinforcementLearningModel()
     * - .toCreateCar()
     * - .toCreateLeaderboard()
     * - .toCreateLeaderboardAccessToken()
     * - .toCreateLeaderboardSubmission()
     * - .toCreateReinforcementLearningModel()
     * - .toDeleteLeaderboard()
     * - .toDeleteModel()
     * - .toEditLeaderboard()
     * - .toGetAccountConfig()
     * - .toGetAlias()
     * - .toGetAssetUrl()
     * - .toGetCar()
     * - .toGetCars()
     * - .toGetEvaluation()
     * - .toGetLatestUserSubmission()
     * - .toGetLeaderboard()
     * - .toGetModel()
     * - .toGetPrivateLeaderboard()
     * - .toGetRankedUserSubmission()
     * - .toGetTrainingJob()
     * - .toImportModel()
     * - .toListEvaluations()
     * - .toListLeaderboardSubmissions()
     * - .toListLeaderboards()
     * - .toListModels()
     * - .toListPrivateLeaderboardParticipants()
     * - .toListPrivateLeaderboards()
     * - .toListSubscribedPrivateLeaderboards()
     * - .toListTagsForResource()
     * - .toListTrainingJobs()
     * - .toPerformLeaderboardOperation()
     * - .toRemoveLeaderboardAccessPermission()
     * - .toSetAlias()
     * - .toStartEvaluation()
     * - .toStopEvaluation()
     * - .toStopTrainingReinforcementLearningModel()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCar()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifMultiUser(value) {
        return this.if(`MultiUser`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by user token in the request
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/reference_policies_iam-condition-keys.html#condition-keys-usertoken
     *
     * Applies to actions:
     * - .toAddLeaderboardAccessPermission()
     * - .toCloneReinforcementLearningModel()
     * - .toCreateCar()
     * - .toCreateLeaderboard()
     * - .toCreateLeaderboardAccessToken()
     * - .toCreateLeaderboardSubmission()
     * - .toCreateReinforcementLearningModel()
     * - .toDeleteLeaderboard()
     * - .toDeleteModel()
     * - .toEditLeaderboard()
     * - .toGetAccountConfig()
     * - .toGetAlias()
     * - .toGetAssetUrl()
     * - .toGetCar()
     * - .toGetCars()
     * - .toGetEvaluation()
     * - .toGetLatestUserSubmission()
     * - .toGetLeaderboard()
     * - .toGetModel()
     * - .toGetPrivateLeaderboard()
     * - .toGetRankedUserSubmission()
     * - .toGetTrainingJob()
     * - .toImportModel()
     * - .toListEvaluations()
     * - .toListLeaderboardSubmissions()
     * - .toListLeaderboards()
     * - .toListModels()
     * - .toListPrivateLeaderboardParticipants()
     * - .toListPrivateLeaderboards()
     * - .toListSubscribedPrivateLeaderboards()
     * - .toListTagsForResource()
     * - .toListTrainingJobs()
     * - .toPerformLeaderboardOperation()
     * - .toRemoveLeaderboardAccessPermission()
     * - .toSetAlias()
     * - .toStartEvaluation()
     * - .toStopEvaluation()
     * - .toStopTrainingReinforcementLearningModel()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCar()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserToken(value, operator) {
        return this.if(`UserToken`, value, operator || 'StringLike');
    }
}
exports.Deepracer = Deepracer;
_a = JSII_RTTI_SYMBOL_1;
Deepracer[_a] = { fqn: "iam-floyd.Deepracer", version: "0.364.0" };
//# sourceMappingURL=data:application/json;base64,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