"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Healthlake = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [healthlake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonhealthlake.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Healthlake extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [healthlake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonhealthlake.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'healthlake';
        this.accessLevelList = {
            Write: [
                'CreateFHIRDatastore',
                'CreateResource',
                'DeleteFHIRDatastore',
                'DeleteResource',
                'StartFHIRExportJob',
                'StartFHIRImportJob',
                'UpdateResource'
            ],
            Read: [
                'DescribeFHIRDatastore',
                'DescribeFHIRExportJob',
                'DescribeFHIRImportJob',
                'GetCapabilities',
                'ListTagsForResource',
                'ReadResource',
                'SearchWithGet',
                'SearchWithPost'
            ],
            List: [
                'ListFHIRDatastores',
                'ListFHIRExportJobs',
                'ListFHIRImportJobs'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create a datastore that can ingest and export FHIR data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_CreateFHIRDatastore.html
     */
    toCreateFHIRDatastore() {
        return this.to('CreateFHIRDatastore');
    }
    /**
     * Grants permission to create resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     */
    toCreateResource() {
        return this.to('CreateResource');
    }
    /**
     * Grants permission to delete a datastore
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DeleteFHIRDatastore.html
     */
    toDeleteFHIRDatastore() {
        return this.to('DeleteFHIRDatastore');
    }
    /**
     * Grants permission to delete resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     */
    toDeleteResource() {
        return this.to('DeleteResource');
    }
    /**
     * Grants permission to get the properties associated with the FHIR datastore, including the datastore ID, datastore ARN, datastore name, datastore status, created at, datastore type version, and datastore endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DescribeFHIRDatastore.html
     */
    toDescribeFHIRDatastore() {
        return this.to('DescribeFHIRDatastore');
    }
    /**
     * Grants permission to display the properties of a FHIR export job, including the ID, ARN, name, and the status of the datastore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DescribeFHIRExportJob.html
     */
    toDescribeFHIRExportJob() {
        return this.to('DescribeFHIRExportJob');
    }
    /**
     * Grants permission to display the properties of a FHIR import job, including the ID, ARN, name, and the status of the datastore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DescribeFHIRImportJob.html
     */
    toDescribeFHIRImportJob() {
        return this.to('DescribeFHIRImportJob');
    }
    /**
     * Grants permission to get the capabilities of a FHIR datastore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     */
    toGetCapabilities() {
        return this.to('GetCapabilities');
    }
    /**
     * Grants permission to list all FHIR datastores that are in the user’s account, regardless of datastore status
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_ListFHIRDatastores.html
     */
    toListFHIRDatastores() {
        return this.to('ListFHIRDatastores');
    }
    /**
     * Grants permission to get a list of export jobs for the specified datastore
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_ListFHIRExportJobs.html
     */
    toListFHIRExportJobs() {
        return this.to('ListFHIRExportJobs');
    }
    /**
     * Grants permission to get a list of import jobs for the specified datastore
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_ListFHIRImportJobs.html
     */
    toListFHIRImportJobs() {
        return this.to('ListFHIRImportJobs');
    }
    /**
     * Grants permission to get a list of tags for the specified datastore
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to read resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     */
    toReadResource() {
        return this.to('ReadResource');
    }
    /**
     * Grants permission to search resources with GET method
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/search-healthlake.html
     */
    toSearchWithGet() {
        return this.to('SearchWithGet');
    }
    /**
     * Grants permission to search resources with POST method
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/search-healthlake.html
     */
    toSearchWithPost() {
        return this.to('SearchWithPost');
    }
    /**
     * Grants permission to begin a FHIR Export job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_StartFHIRExportJob.html
     */
    toStartFHIRExportJob() {
        return this.to('StartFHIRExportJob');
    }
    /**
     * Grants permission to begin a FHIR Import job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_StartFHIRImportJob.html
     */
    toStartFHIRImportJob() {
        return this.to('StartFHIRImportJob');
    }
    /**
     * Grants permission to add tags to a datastore
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags associated with a datastore
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/healthlake/latest/devguide/crud-healthlake.html
     */
    toUpdateResource() {
        return this.to('UpdateResource');
    }
    /**
     * Adds a resource of type datastore to the statement
     *
     * https://docs.aws.amazon.com/healthlake/latest/APIReference/API_DatastoreProperties.html
     *
     * @param datastoreId - Identifier for the datastoreId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDatastore(datastoreId, accountId, region, partition) {
        return this.on(`arn:${partition || Healthlake.defaultPartition}:healthlake:${region || '*'}:${accountId || '*'}:datastore/fhir/${datastoreId}`);
    }
}
exports.Healthlake = Healthlake;
_a = JSII_RTTI_SYMBOL_1;
Healthlake[_a] = { fqn: "iam-floyd.Healthlake", version: "0.364.0" };
//# sourceMappingURL=data:application/json;base64,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