"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _3_actions_1 = require("./3-actions");
/**
 * Adds "resource" functionality to the Policy Statement
 */
class PolicyStatementWithResources extends _3_actions_1.PolicyStatementWithActions {
    constructor() {
        super(...arguments);
        this.useNotResources = false;
        this.resources = [];
        this.skipAutoResource = false;
        this.cdkResourcesApplied = false;
    }
    /**
     * Injects resources into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            this.cdkApplyResources();
            return super.toJSON();
        }
        const mode = this.useNotResources ? 'NotResource' : 'Resource';
        const statement = super.toJSON();
        const self = this;
        this.ensureResource();
        if (this.resources.length) {
            const resources = this.resources.filter((elem, pos) => {
                return self.resources.indexOf(elem) == pos;
            });
            statement[mode] = resources.length > 1 ? resources : resources[0];
        }
        return statement;
    }
    toStatementJson() {
        this.ensureResource();
        this.cdkApplyResources();
        // @ts-ignore only available after swapping 1-base
        return super.toStatementJson();
    }
    cdkApplyResources() {
        if (!this.cdkResourcesApplied) {
            const mode = this.useNotResources ? 'addNotResources' : 'addResources';
            const self = this;
            const uniqueResources = this.resources.filter((elem, pos) => {
                return self.resources.indexOf(elem) == pos;
            });
            // @ts-ignore only available after swapping 1-base
            this[mode](...uniqueResources);
            this.cdkResourcesApplied = true;
        }
    }
    /**
     * Switches the statement to use [`NotResource`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html).
     */
    notResources() {
        this.useNotResources = true;
        return this;
    }
    /**
     * Checks weather any resource was applied to the policy.
     */
    hasResources() {
        return this.resources.length > 0;
    }
    /**
     * Limit statement to specified resources.
     *
     * To allow all resources, pass `*`
     */
    on(...arns) {
        this.resources.push(...arns);
        return this;
    }
    /**
     * Add all resources (`*`) to the statement
     *
     * This is the default behavior, unless the statement has principals.
     */
    onAllResources() {
        this.resources.push('*');
        return this;
    }
    ensureResource() {
        if (this.hasResources())
            return;
        // @ts-ignore only available after swapping 1-base
        if (this.hasResource)
            return;
        // @ts-ignore only available after swapping 1-base
        if (this.hasPrincipal)
            return; //assume policies may not have resources
        if (this.skipAutoResource)
            return;
        // a statement requires resources. if none was added, we assume the user wants all resources
        this.onAllResources();
    }
    /**
     * Dummy method. Will be overridden by 6-principal.ts
     *
     * We just need it here so we can reference it in method `ensureResource`
     */
    hasPrincipals() {
        return false;
    }
}
exports.PolicyStatementWithResources = PolicyStatementWithResources;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithResources[_a] = { fqn: "iam-floyd.PolicyStatementWithResources", version: "0.364.0" };
//# sourceMappingURL=data:application/json;base64,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