import * as iam from 'aws-cdk-lib/aws-iam';
import * as kms from 'aws-cdk-lib/aws-kms';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { DataFormat } from './data-format';
import { IDatabase } from './database';
import { Column } from './schema';
/**
 * @experimental
 */
export interface ITable extends IResource {
    /**
     * @experimental
     * @attribute true
     */
    readonly tableArn: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly tableName: string;
}
/**
 * (experimental) Encryption options for a Table.
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/encryption.html
 * @experimental
 */
export declare enum TableEncryption {
    /**
     * @experimental
     */
    UNENCRYPTED = "Unencrypted",
    /**
     * (experimental) Server side encryption (SSE) with an Amazon S3-managed key.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html
     * @experimental
     */
    S3_MANAGED = "SSE-S3",
    /**
     * (experimental) Server-side encryption (SSE) with an AWS KMS key managed by the account owner.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html
     * @experimental
     */
    KMS = "SSE-KMS",
    /**
     * (experimental) Server-side encryption (SSE) with an AWS KMS key managed by the KMS service.
     *
     * @experimental
     */
    KMS_MANAGED = "SSE-KMS-MANAGED",
    /**
     * (experimental) Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html
     * @experimental
     */
    CLIENT_SIDE_KMS = "CSE-KMS"
}
/**
 * @experimental
 */
export interface TableAttributes {
    /**
     * @experimental
     */
    readonly tableArn: string;
    /**
     * @experimental
     */
    readonly tableName: string;
}
/**
 * @experimental
 */
export interface TableProps {
    /**
     * (experimental) Name of the table.
     *
     * @experimental
     */
    readonly tableName: string;
    /**
     * (experimental) Description of the table.
     *
     * @default generated
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Database in which to store the table.
     *
     * @experimental
     */
    readonly database: IDatabase;
    /**
     * (experimental) S3 bucket in which to store data.
     *
     * @default one is created for you
     * @experimental
     */
    readonly bucket?: s3.IBucket;
    /**
     * (experimental) S3 prefix under which table objects are stored.
     *
     * @default - No prefix. The data will be stored under the root of the bucket.
     * @experimental
     */
    readonly s3Prefix?: string;
    /**
     * (experimental) Columns of the table.
     *
     * @experimental
     */
    readonly columns: Column[];
    /**
     * (experimental) Partition columns of the table.
     *
     * @default table is not partitioned
     * @experimental
     */
    readonly partitionKeys?: Column[];
    /**
     * (experimental) Storage type of the table's data.
     *
     * @experimental
     */
    readonly dataFormat: DataFormat;
    /**
     * (experimental) Indicates whether the table's data is compressed or not.
     *
     * @default false
     * @experimental
     */
    readonly compressed?: boolean;
    /**
     * (experimental) The kind of encryption to secure the data with.
     *
     * You can only provide this option if you are not explicitly passing in a bucket.
     *
     * If you choose `SSE-KMS`, you *can* provide an un-managed KMS key with `encryptionKey`.
     * If you choose `CSE-KMS`, you *must* provide an un-managed KMS key with `encryptionKey`.
     *
     * @default Unencrypted
     * @experimental
     */
    readonly encryption?: TableEncryption;
    /**
     * (experimental) External KMS key to use for bucket encryption.
     *
     * The `encryption` property must be `SSE-KMS` or `CSE-KMS`.
     *
     * @default key is managed by KMS.
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Indicates whether the table data is stored in subdirectories.
     *
     * @default false
     * @experimental
     */
    readonly storedAsSubDirectories?: boolean;
}
/**
 * (experimental) A Glue table.
 *
 * @experimental
 */
export declare class Table extends Resource implements ITable {
    /**
     * @experimental
     */
    static fromTableArn(scope: Construct, id: string, tableArn: string): ITable;
    /**
     * (experimental) Creates a Table construct that represents an external table.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param attrs Import attributes.
     * @experimental
     */
    static fromTableAttributes(scope: Construct, id: string, attrs: TableAttributes): ITable;
    /**
     * (experimental) Database this table belongs to.
     *
     * @experimental
     */
    readonly database: IDatabase;
    /**
     * (experimental) Indicates whether the table's data is compressed or not.
     *
     * @experimental
     */
    readonly compressed: boolean;
    /**
     * (experimental) The type of encryption enabled for the table.
     *
     * @experimental
     */
    readonly encryption: TableEncryption;
    /**
     * (experimental) The KMS key used to secure the data if `encryption` is set to `CSE-KMS` or `SSE-KMS`.
     *
     * Otherwise, `undefined`.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) S3 bucket in which the table's data resides.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) S3 Key Prefix under which this table's files are stored in S3.
     *
     * @experimental
     */
    readonly s3Prefix: string;
    /**
     * (experimental) Name of this table.
     *
     * @experimental
     */
    readonly tableName: string;
    /**
     * (experimental) ARN of this table.
     *
     * @experimental
     */
    readonly tableArn: string;
    /**
     * (experimental) Format of this table's data files.
     *
     * @experimental
     */
    readonly dataFormat: DataFormat;
    /**
     * (experimental) This table's columns.
     *
     * @experimental
     */
    readonly columns: Column[];
    /**
     * (experimental) This table's partition keys if the table is partitioned.
     *
     * @experimental
     */
    readonly partitionKeys?: Column[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TableProps);
    /**
     * (experimental) Grant read permissions to the table and the underlying data stored in S3 to an IAM principal.
     *
     * @param grantee the principal.
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions to the table and the underlying data stored in S3 to an IAM principal.
     *
     * @param grantee the principal.
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read and write permissions to the table and the underlying data stored in S3 to an IAM principal.
     *
     * @param grantee the principal.
     * @experimental
     */
    grantReadWrite(grantee: iam.IGrantable): iam.Grant;
    private grant;
    private getS3PrefixForGrant;
}
