/*
* Copyright © 2020 Contrast Security, Inc.
* See https://www.contrastsecurity.com/enduser-terms-0317a for more details.
*/
/* THIS FILE WAS AUTOMATICALLY GENERATED BY HOOKSPY */
/* Python requires its own header to always be included first */
#define PY_SSIZE_T_CLEAN
#include <Python.h>

#include <contrast/assess/propagate.h>
#include <contrast/assess/scope.h>
#include <contrast/assess/utils.h>

typedef PyObject *(*fastcall_func)(PyObject *, PyObject *const *, Py_ssize_t);
typedef PyObject *(*fastcall_kwargs_func)(PyObject *, PyObject *const *, Py_ssize_t, PyObject *);

#define BYTES_DECODE_OFFSET 4
#define BYTES_REPLACE_OFFSET 25
#define BYTES_SPLIT_OFFSET 34
#define BYTES_RSPLIT_OFFSET 32
#define BYTES_JOIN_OFFSET 19
#define BYTES_CAPITALIZE_OFFSET 1
#define BYTES_TITLE_OFFSET 39
#define BYTES_CENTER_OFFSET 2
#define BYTES_EXPANDTABS_OFFSET 6
#define BYTES_PARTITION_OFFSET 24
#define BYTES_LJUST_OFFSET 20
#define BYTES_LOWER_OFFSET 21
#define BYTES_LSTRIP_OFFSET 22
#define BYTES_RJUST_OFFSET 30
#define BYTES_RSTRIP_OFFSET 33
#define BYTES_RPARTITION_OFFSET 31
#define BYTES_SPLITLINES_OFFSET 35
#define BYTES_STRIP_OFFSET 37
#define BYTES_SWAPCASE_OFFSET 38
#define BYTES_TRANSLATE_OFFSET 40
#define BYTES_UPPER_OFFSET 41
#define BYTES_ZFILL_OFFSET 42


fastcall_kwargs_func bytes_decode_orig;
fastcall_func bytes_replace_orig;
fastcall_kwargs_func bytes_split_orig;
fastcall_kwargs_func bytes_rsplit_orig;
binaryfunc bytes_join_orig;
unaryfunc bytes_capitalize_orig;
unaryfunc bytes_title_orig;
fastcall_func bytes_center_orig;
fastcall_kwargs_func bytes_expandtabs_orig;
binaryfunc bytes_partition_orig;
fastcall_func bytes_ljust_orig;
unaryfunc bytes_lower_orig;
fastcall_func bytes_lstrip_orig;
fastcall_func bytes_rjust_orig;
fastcall_func bytes_rstrip_orig;
binaryfunc bytes_rpartition_orig;
fastcall_kwargs_func bytes_splitlines_orig;
fastcall_func bytes_strip_orig;
unaryfunc bytes_swapcase_orig;
fastcall_kwargs_func bytes_translate_orig;
unaryfunc bytes_upper_orig;
binaryfunc bytes_zfill_orig;
newfunc bytes_new_orig;


HOOK_TERNARY_FASTCALL(bytes_decode, "decode");
PyObject *bytes_replace_new(PyObject *self, PyObject *const *args, Py_ssize_t nargs) {
    /* In Py37 the replace method type moved to METH_FASTARGS. This means that
     * instead of args being passed as a tuple, they are passed as a C array
     * that contains PyObjects. We need to check whether there is the number of
     * args that we expect, and whether the arg we care about is not NULL.
     * Specifically, we want args[1] since it represents the "new" string in
     * the replacement.
     */
    PyObject *hook_args = pack_args_tuple(args, nargs);
    PyObject *result = bytes_replace_orig(self, args, nargs);

    if (result == NULL || nargs < 2 || args[1] == NULL)
        goto cleanup_and_exit;

    if (result == self)
        goto cleanup_and_exit;

    propagate_result("replace", self, result, hook_args, NULL);

cleanup_and_exit:
    Py_XDECREF(hook_args);
    return result;

}

PyObject *bytes_split_new(PyObject *self, PyObject *const *args, Py_ssize_t nargs, PyObject *kwnames) {
    PyObject *result = bytes_split_orig(self, args, nargs, kwnames);
    PyObject *args_tuple = pack_args_tuple(args, nargs);
    PyObject *kwargs = pack_kwargs_dict(args, nargs, kwnames);

    if (result == NULL || PySequence_Length(result) == 1)
        goto cleanup_and_exit;

    propagate_result("split", (PyObject *)self, result, args_tuple, kwargs);

cleanup_and_exit:
    Py_XDECREF(args_tuple);
    Py_XDECREF(kwargs);
    return result;

}

PyObject *bytes_rsplit_new(PyObject *self, PyObject *const *args, Py_ssize_t nargs, PyObject *kwnames) {
    PyObject *result = bytes_rsplit_orig(self, args, nargs, kwnames);
    PyObject *args_tuple = pack_args_tuple(args, nargs);
    PyObject *kwargs = pack_kwargs_dict(args, nargs, kwnames);

    if (result == NULL || PySequence_Length(result) == 1)
        goto cleanup_and_exit;

    propagate_result("rsplit", (PyObject *)self, result, args_tuple, kwargs);

cleanup_and_exit:
    Py_XDECREF(args_tuple);
    Py_XDECREF(kwargs);
    return result;

}

PyObject *bytes_join_new(PyObject *self, PyObject *args) {
    PyObject *list = PySequence_List(args);

    /* If this fails for any reason, just call the original function and get
     * out of here.
     */
    if (list == NULL) {
        PyErr_Clear();
        return bytes_join_orig((PyObject *)self, args);
    }

    /* In Py36+ we also hook an internal function that is called by this
     * function in order to propagate fstring formatting. We still want to have
     * a separate hook for join so that the events are reported differently.
     * This means that we need to go into scope when calling the original
     * function here so that we don't propagate twice.
     */
    enter_propagation_scope();
    PyObject *result = bytes_join_orig((PyObject *)self, list);
    exit_propagation_scope();

    PyObject *prop_args = PyTuple_Pack(1, list);

    if (prop_args == NULL || result == NULL)
        goto cleanup_and_exit;

    propagate_result("join", (PyObject *)self, result, prop_args, NULL);

cleanup_and_exit:
    Py_XDECREF(list);
    Py_XDECREF(prop_args);
    return result;

}

HOOK_UNARYFUNC(bytes_capitalize, "capitalize");
HOOK_UNARYFUNC(bytes_title, "title");
HOOK_FASTCALL(bytes_center, "center");
HOOK_TERNARY_FASTCALL(bytes_expandtabs, "expandtabs");
HOOK_BINARYFUNC(bytes_partition, "partition");
HOOK_FASTCALL(bytes_ljust, "ljust");
HOOK_UNARYFUNC(bytes_lower, "lower");
HOOK_FASTCALL(bytes_lstrip, "lstrip");
HOOK_FASTCALL(bytes_rjust, "rjust");
HOOK_FASTCALL(bytes_rstrip, "rstrip");
HOOK_BINARYFUNC(bytes_rpartition, "rpartition");
HOOK_TERNARY_FASTCALL(bytes_splitlines, "splitlines");
HOOK_FASTCALL(bytes_strip, "strip");
HOOK_UNARYFUNC(bytes_swapcase, "swapcase");
HOOK_TERNARY_FASTCALL(bytes_translate, "translate");
HOOK_UNARYFUNC(bytes_upper, "upper");
HOOK_BINARYFUNC(bytes_zfill, "zfill");
PyObject *bytes_new_new(PyTypeObject *type, PyObject *args, PyObject *kwds) {
    PyObject *result = bytes_new_orig(type, args, kwds);

    if (result == NULL)
        return result;

    propagate_result("CAST", NULL, result, args, kwds);

    return result;

}




int apply_bytes_patches(funchook_t *funchook) {

    ADD_METHOD_HOOK(PyBytes_Type, bytes_decode, BYTES_DECODE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_replace, BYTES_REPLACE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_split, BYTES_SPLIT_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_rsplit, BYTES_RSPLIT_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_join, BYTES_JOIN_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_capitalize, BYTES_CAPITALIZE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_title, BYTES_TITLE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_center, BYTES_CENTER_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_expandtabs, BYTES_EXPANDTABS_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_partition, BYTES_PARTITION_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_ljust, BYTES_LJUST_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_lower, BYTES_LOWER_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_lstrip, BYTES_LSTRIP_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_rjust, BYTES_RJUST_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_rstrip, BYTES_RSTRIP_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_rpartition, BYTES_RPARTITION_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_splitlines, BYTES_SPLITLINES_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_strip, BYTES_STRIP_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_swapcase, BYTES_SWAPCASE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_translate, BYTES_TRANSLATE_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_upper, BYTES_UPPER_OFFSET);
    ADD_METHOD_HOOK(PyBytes_Type, bytes_zfill, BYTES_ZFILL_OFFSET);
    ADD_NEWFUNC_HOOK(PyBytes_Type, bytes_new);

    /* Indicates success */
    return 0;
}

