"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildSecretsManagerSecret = void 0;
const aws_secretsmanager_1 = require("@aws-cdk/aws-secretsmanager");
const secretsmanager_defaults_1 = require("./secretsmanager-defaults");
const utils_1 = require("./utils");
/**
 * Method to build the default AWS Secrets Manager Secret
 *
 * @param scope
 * @param id
 * @param secretProps
 */
function buildSecretsManagerSecret(scope, id, secretProps) {
    let secret;
    if (secretProps) {
        secret = new aws_secretsmanager_1.Secret(scope, id, utils_1.overrideProps(secretsmanager_defaults_1.DefaultSecretProps, secretProps));
    }
    else {
        secret = new aws_secretsmanager_1.Secret(scope, id, secretsmanager_defaults_1.DefaultSecretProps);
    }
    // suppress warning on build
    const cfnSecret = secret.node.findChild('Resource');
    cfnSecret.cfnOptions.metadata = {
        cfn_nag: {
            rules_to_suppress: [{
                    id: 'W77',
                    reason: `We allow the use of the AWS account default key aws/secretsmanager for secret encryption.`
                }]
        }
    };
    return secret;
}
exports.buildSecretsManagerSecret = buildSecretsManagerSecret;
//# sourceMappingURL=data:application/json;base64,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