"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Kaniko = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const ecr = require("@aws-cdk/aws-ecr");
const ecs = require("@aws-cdk/aws-ecs");
const cdk = require("@aws-cdk/core");
const cdk_fargate_run_task_1 = require("cdk-fargate-run-task");
/**
 * @stability stable
 */
class Kaniko extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        this.fargateSpot = (_b = props.fargateSpot) !== null && _b !== void 0 ? _b : false;
        this.vpc = getOrCreateVpc(this);
        this.cluster = new ecs.Cluster(this, 'Cluster', {
            vpc: this.vpc,
            capacityProviders: ['FARGATE', 'FARGATE_SPOT'],
        });
        this.destinationRepository = (_c = props.destinationRepository) !== null && _c !== void 0 ? _c : this._createDestinationRepository();
        const executorImage = ecs.ContainerImage.fromAsset(path.join(__dirname, '../docker.d'));
        this.task = new ecs.FargateTaskDefinition(this, 'BuildImageTask', {
            cpu: 512,
            memoryLimitMiB: 1024,
        });
        this.task.addContainer('kaniko', {
            image: executorImage,
            command: [
                '--context', props.context,
                '--context-sub-path',
                (_d = props.contextSubPath) !== null && _d !== void 0 ? _d : './',
                '--dockerfile',
                (_e = props.dockerfile) !== null && _e !== void 0 ? _e : 'Dockerfile',
                '--destination', this.destinationRepository.repositoryUri,
                '--force',
            ],
            logging: new ecs.AwsLogDriver({ streamPrefix: 'kaniko' }),
        });
        this.destinationRepository.grantPullPush(this.task.taskRole);
        new cdk.CfnOutput(this, 'Repository', {
            value: this.destinationRepository.repositoryName,
        });
    }
    _createDestinationRepository() {
        return new ecr.Repository(this, 'Repo', {
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
    }
    /**
     * Build the image with kaniko.
     *
     * @param schedule The schedule to repeatedly build the image.
     * @stability stable
     */
    buildImage(id, schedule) {
        // run it just once
        const newRunTask = new cdk_fargate_run_task_1.RunTask(this, `BuildImage${id}`, {
            task: this.task,
            cluster: this.cluster,
            schedule,
            capacityProviderStrategy: this.fargateSpot ? [
                {
                    capacityProvider: 'FARGATE_SPOT',
                    weight: 1,
                },
            ] : undefined,
        });
        // if vpc is a new resource in this stack, run task job will add dependency on vpc created.
        if (this.node.tryFindChild('Vpc').node.children.find(c => c.cfnResourceType === 'AWS::EC2::VPC')) {
            newRunTask.node.addDependency(this.vpc);
        }
        ;
    }
}
exports.Kaniko = Kaniko;
_a = JSII_RTTI_SYMBOL_1;
Kaniko[_a] = { fqn: "cdk-kaniko.Kaniko", version: "0.2.5" };
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1'
        || process.env.CDK_USE_DEFAULT_VPC === '1' ? ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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