# -*- coding: utf-8 -*-
# Generated by Django 1.11.7 on 2017-12-02 08:45
from __future__ import unicode_literals

import django_intenum
import hearthstone.enums
from django.db import migrations, models


class Migration(migrations.Migration):

	initial = True

	dependencies = []

	operations = [
		migrations.CreateModel(
			name="Card",
			fields=[
				("card_id", models.CharField(max_length=50, primary_key=True, serialize=False)),
				("dbf_id", models.IntegerField(db_index=True, null=True, unique=True)),
				("name", models.CharField(max_length=50)),
				("description", models.TextField(blank=True)),
				("flavortext", models.TextField(blank=True)),
				("how_to_earn", models.TextField(blank=True)),
				("how_to_earn_golden", models.TextField(blank=True)),
				("artist", models.CharField(blank=True, max_length=255)),
				(
					"card_class", django_intenum.IntEnumField(default=0, enum=hearthstone.enums.CardClass)
				),
				("card_set", django_intenum.IntEnumField(default=0, enum=hearthstone.enums.CardSet)),
				("faction", django_intenum.IntEnumField(default=0, enum=hearthstone.enums.Faction)),
				("race", django_intenum.IntEnumField(default=0, enum=hearthstone.enums.Race)),
				("rarity", django_intenum.IntEnumField(default=0, enum=hearthstone.enums.Rarity)),
				("type", django_intenum.IntEnumField(default=0, enum=hearthstone.enums.CardType)),
				("collectible", models.BooleanField(default=False)),
				("battlecry", models.BooleanField(default=False)),
				("divine_shield", models.BooleanField(default=False)),
				("deathrattle", models.BooleanField(default=False)),
				("elite", models.BooleanField(default=False)),
				("evil_glow", models.BooleanField(default=False)),
				("inspire", models.BooleanField(default=False)),
				("forgetful", models.BooleanField(default=False)),
				("one_turn_effect", models.BooleanField(default=False)),
				("poisonous", models.BooleanField(default=False)),
				("ritual", models.BooleanField(default=False)),
				("secret", models.BooleanField(default=False)),
				("taunt", models.BooleanField(default=False)),
				("topdeck", models.BooleanField(default=False)),
				("atk", models.IntegerField(default=0)),
				("health", models.IntegerField(default=0)),
				("durability", models.IntegerField(default=0)),
				("cost", models.IntegerField(default=0)),
				("windfury", models.IntegerField(default=0)),
				("spare_part", models.BooleanField(default=False)),
				("overload", models.IntegerField(default=0)),
				("spell_damage", models.IntegerField(default=0)),
				("craftable", models.BooleanField(default=False)),
			],
			options={
				"db_table": "card",
			},
		),
	]
