# Generated by Django 2.0.3 on 2018-03-21 11:13

import django.db.models.deletion
import django_intenum
import hearthstone.enums
from django.db import migrations, models


class Migration(migrations.Migration):

	dependencies = [
		("cards", "0001_initial"),
	]

	operations = [
		migrations.CreateModel(
			name="CardString",
			fields=[
				("id", models.AutoField(
					auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
				)),
				("locale", django_intenum.IntEnumField(db_index=True, enum=hearthstone.enums.Locale)),
				("game_tag", django_intenum.IntEnumField(
					db_index=True, enum=hearthstone.enums.GameTag
				)),
				("value", models.TextField(blank=True)),
			],
		),
		migrations.CreateModel(
			name="CardTag",
			fields=[
				("id", models.AutoField(
					auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
				)),
				("game_tag", django_intenum.IntEnumField(
					db_index=True, enum=hearthstone.enums.GameTag
				)),
				("value", models.PositiveIntegerField()),
			],
		),
		migrations.AlterField(
			model_name="card",
			name="card_class",
			field=django_intenum.IntEnumField(default=0, enum=hearthstone.enums.CardClass),
		),
		migrations.AlterField(
			model_name="card",
			name="card_set",
			field=django_intenum.IntEnumField(default=0, enum=hearthstone.enums.CardSet),
		),
		migrations.AlterField(
			model_name="card",
			name="faction",
			field=django_intenum.IntEnumField(default=0, enum=hearthstone.enums.Faction),
		),
		migrations.AlterField(
			model_name="card",
			name="race",
			field=django_intenum.IntEnumField(default=0, enum=hearthstone.enums.Race),
		),
		migrations.AlterField(
			model_name="card",
			name="rarity",
			field=django_intenum.IntEnumField(default=0, enum=hearthstone.enums.Rarity),
		),
		migrations.AlterField(
			model_name="card",
			name="type",
			field=django_intenum.IntEnumField(default=0, enum=hearthstone.enums.CardType),
		),
		migrations.AddField(
			model_name="cardtag",
			name="card",
			field=models.ForeignKey(
				on_delete=django.db.models.deletion.CASCADE, related_name="tags",
				to="cards.Card", to_field="dbf_id", db_column="card_dbf_id"
			),
		),
		migrations.AddField(
			model_name="cardstring",
			name="card",
			field=models.ForeignKey(
				on_delete=django.db.models.deletion.CASCADE, related_name="strings",
				to="cards.Card", to_field="dbf_id", db_column="card_dbf_id"
			),
		),
	]
