# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class Lwm2mControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_lwm2m_bootstrap_security_info_using_get(self, is_bootstrap_server, **kwargs):  # noqa: E501
        """getLwm2mBootstrapSecurityInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lwm2m_bootstrap_security_info_using_get(is_bootstrap_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool is_bootstrap_server: isBootstrapServer (required)
        :return: ServerSecurityConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_lwm2m_bootstrap_security_info_using_get_with_http_info(is_bootstrap_server, **kwargs)  # noqa: E501
        else:
            (data) = self.get_lwm2m_bootstrap_security_info_using_get_with_http_info(is_bootstrap_server, **kwargs)  # noqa: E501
            return data

    def get_lwm2m_bootstrap_security_info_using_get_with_http_info(self, is_bootstrap_server, **kwargs):  # noqa: E501
        """getLwm2mBootstrapSecurityInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lwm2m_bootstrap_security_info_using_get_with_http_info(is_bootstrap_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool is_bootstrap_server: isBootstrapServer (required)
        :return: ServerSecurityConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['is_bootstrap_server']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lwm2m_bootstrap_security_info_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'is_bootstrap_server' is set
        if ('is_bootstrap_server' not in params or
                params['is_bootstrap_server'] is None):
            raise ValueError("Missing the required parameter `is_bootstrap_server` when calling `get_lwm2m_bootstrap_security_info_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'is_bootstrap_server' in params:
            path_params['isBootstrapServer'] = params['is_bootstrap_server']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/lwm2m/deviceProfile/bootstrap/{isBootstrapServer}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ServerSecurityConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_device_with_credentials_using_post(self, **kwargs):  # noqa: E501
        """saveDeviceWithCredentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_device_with_credentials_using_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: deviceWithDeviceCredentials
        :return: Device
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_device_with_credentials_using_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.save_device_with_credentials_using_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def save_device_with_credentials_using_post_with_http_info(self, **kwargs):  # noqa: E501
        """saveDeviceWithCredentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_device_with_credentials_using_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: deviceWithDeviceCredentials
        :return: Device
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_device_with_credentials_using_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/lwm2m/device-credentials', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Device',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
