# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class OtaPackageControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_ota_package_using_delete(self, ota_package_id, **kwargs):  # noqa: E501
        """deleteOtaPackage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ota_package_using_delete(ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ota_package_id: otaPackageId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ota_package_using_delete_with_http_info(ota_package_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ota_package_using_delete_with_http_info(ota_package_id, **kwargs)  # noqa: E501
            return data

    def delete_ota_package_using_delete_with_http_info(self, ota_package_id, **kwargs):  # noqa: E501
        """deleteOtaPackage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ota_package_using_delete_with_http_info(ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ota_package_id: otaPackageId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ota_package_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ota_package_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ota_package_id' is set
        if ('ota_package_id' not in params or
                params['ota_package_id'] is None):
            raise ValueError("Missing the required parameter `ota_package_id` when calling `delete_ota_package_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ota_package_id' in params:
            path_params['otaPackageId'] = params['ota_package_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/otaPackage/{otaPackageId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_ota_package_using_get(self, ota_package_id, **kwargs):  # noqa: E501
        """downloadOtaPackage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_ota_package_using_get(ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ota_package_id: otaPackageId (required)
        :return: Resource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_ota_package_using_get_with_http_info(ota_package_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_ota_package_using_get_with_http_info(ota_package_id, **kwargs)  # noqa: E501
            return data

    def download_ota_package_using_get_with_http_info(self, ota_package_id, **kwargs):  # noqa: E501
        """downloadOtaPackage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_ota_package_using_get_with_http_info(ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ota_package_id: otaPackageId (required)
        :return: Resource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ota_package_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_ota_package_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ota_package_id' is set
        if ('ota_package_id' not in params or
                params['ota_package_id'] is None):
            raise ValueError("Missing the required parameter `ota_package_id` when calling `download_ota_package_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ota_package_id' in params:
            path_params['otaPackageId'] = params['ota_package_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/otaPackage/{otaPackageId}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Resource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ota_package_by_id_using_get(self, ota_package_id, **kwargs):  # noqa: E501
        """getOtaPackageById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ota_package_by_id_using_get(ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ota_package_id: otaPackageId (required)
        :return: OtaPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ota_package_by_id_using_get_with_http_info(ota_package_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ota_package_by_id_using_get_with_http_info(ota_package_id, **kwargs)  # noqa: E501
            return data

    def get_ota_package_by_id_using_get_with_http_info(self, ota_package_id, **kwargs):  # noqa: E501
        """getOtaPackageById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ota_package_by_id_using_get_with_http_info(ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ota_package_id: otaPackageId (required)
        :return: OtaPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ota_package_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ota_package_by_id_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ota_package_id' is set
        if ('ota_package_id' not in params or
                params['ota_package_id'] is None):
            raise ValueError("Missing the required parameter `ota_package_id` when calling `get_ota_package_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ota_package_id' in params:
            path_params['otaPackageId'] = params['ota_package_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/otaPackage/{otaPackageId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OtaPackage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ota_package_info_by_id_using_get(self, ota_package_id, **kwargs):  # noqa: E501
        """getOtaPackageInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ota_package_info_by_id_using_get(ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ota_package_id: otaPackageId (required)
        :return: OtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ota_package_info_by_id_using_get_with_http_info(ota_package_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ota_package_info_by_id_using_get_with_http_info(ota_package_id, **kwargs)  # noqa: E501
            return data

    def get_ota_package_info_by_id_using_get_with_http_info(self, ota_package_id, **kwargs):  # noqa: E501
        """getOtaPackageInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ota_package_info_by_id_using_get_with_http_info(ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ota_package_id: otaPackageId (required)
        :return: OtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ota_package_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ota_package_info_by_id_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ota_package_id' is set
        if ('ota_package_id' not in params or
                params['ota_package_id'] is None):
            raise ValueError("Missing the required parameter `ota_package_id` when calling `get_ota_package_info_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ota_package_id' in params:
            path_params['otaPackageId'] = params['ota_package_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/otaPackage/info/{otaPackageId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OtaPackageInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ota_packages_using_get(self, device_profile_id, type, page_size, page, **kwargs):  # noqa: E501
        """getOtaPackages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ota_packages_using_get(device_profile_id, type, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :param str type: type (required)
        :param int page_size: pageSize (required)
        :param int page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataOtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ota_packages_using_get_with_http_info(device_profile_id, type, page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ota_packages_using_get_with_http_info(device_profile_id, type, page_size, page, **kwargs)  # noqa: E501
            return data

    def get_ota_packages_using_get_with_http_info(self, device_profile_id, type, page_size, page, **kwargs):  # noqa: E501
        """getOtaPackages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ota_packages_using_get_with_http_info(device_profile_id, type, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_profile_id: deviceProfileId (required)
        :param str type: type (required)
        :param int page_size: pageSize (required)
        :param int page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataOtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_profile_id', 'type', 'page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ota_packages_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_profile_id' is set
        if ('device_profile_id' not in params or
                params['device_profile_id'] is None):
            raise ValueError("Missing the required parameter `device_profile_id` when calling `get_ota_packages_using_get`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_ota_packages_using_get`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_ota_packages_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_ota_packages_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_profile_id' in params:
            path_params['deviceProfileId'] = params['device_profile_id']  # noqa: E501
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/otaPackages/{deviceProfileId}/{type}{?pageSize,page,textSearch,sortProperty,sortOrder}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataOtaPackageInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ota_packages_using_get1(self, page_size, page, **kwargs):  # noqa: E501
        """getOtaPackages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ota_packages_using_get1(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: pageSize (required)
        :param int page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataOtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ota_packages_using_get1_with_http_info(page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ota_packages_using_get1_with_http_info(page_size, page, **kwargs)  # noqa: E501
            return data

    def get_ota_packages_using_get1_with_http_info(self, page_size, page, **kwargs):  # noqa: E501
        """getOtaPackages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ota_packages_using_get1_with_http_info(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: pageSize (required)
        :param int page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataOtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ota_packages_using_get1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_ota_packages_using_get1`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_ota_packages_using_get1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/otaPackages{?pageSize,page,textSearch,sortProperty,sortOrder}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataOtaPackageInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_ota_package_data_using_post(self, file, checksum_algorithm, ota_package_id, **kwargs):  # noqa: E501
        """saveOtaPackageData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_ota_package_data_using_post(file, checksum_algorithm, ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str checksum_algorithm: checksumAlgorithm (required)
        :param str ota_package_id: otaPackageId (required)
        :param str checksum: checksum
        :return: OtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_ota_package_data_using_post_with_http_info(file, checksum_algorithm, ota_package_id, **kwargs)  # noqa: E501
        else:
            (data) = self.save_ota_package_data_using_post_with_http_info(file, checksum_algorithm, ota_package_id, **kwargs)  # noqa: E501
            return data

    def save_ota_package_data_using_post_with_http_info(self, file, checksum_algorithm, ota_package_id, **kwargs):  # noqa: E501
        """saveOtaPackageData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_ota_package_data_using_post_with_http_info(file, checksum_algorithm, ota_package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file: (required)
        :param str checksum_algorithm: checksumAlgorithm (required)
        :param str ota_package_id: otaPackageId (required)
        :param str checksum: checksum
        :return: OtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'checksum_algorithm', 'ota_package_id', 'checksum']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_ota_package_data_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `save_ota_package_data_using_post`")  # noqa: E501
        # verify the required parameter 'checksum_algorithm' is set
        if ('checksum_algorithm' not in params or
                params['checksum_algorithm'] is None):
            raise ValueError("Missing the required parameter `checksum_algorithm` when calling `save_ota_package_data_using_post`")  # noqa: E501
        # verify the required parameter 'ota_package_id' is set
        if ('ota_package_id' not in params or
                params['ota_package_id'] is None):
            raise ValueError("Missing the required parameter `ota_package_id` when calling `save_ota_package_data_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ota_package_id' in params:
            path_params['otaPackageId'] = params['ota_package_id']  # noqa: E501

        query_params = []
        if 'checksum' in params:
            query_params.append(('checksum', params['checksum']))  # noqa: E501
        if 'checksum_algorithm' in params:
            query_params.append(('checksumAlgorithm', params['checksum_algorithm']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/otaPackage/{otaPackageId}{?checksum,checksumAlgorithm}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OtaPackageInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_ota_package_info_using_post(self, body, **kwargs):  # noqa: E501
        """saveOtaPackageInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_ota_package_info_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SaveOtaPackageInfoRequest body: otaPackageInfo (required)
        :return: OtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_ota_package_info_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.save_ota_package_info_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def save_ota_package_info_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """saveOtaPackageInfo  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_ota_package_info_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SaveOtaPackageInfoRequest body: otaPackageInfo (required)
        :return: OtaPackageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_ota_package_info_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `save_ota_package_info_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/otaPackage', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OtaPackageInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
