# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class RuleChainControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assign_rule_chain_to_edge_using_post(self, edge_id, rule_chain_id, **kwargs):  # noqa: E501
        """assignRuleChainToEdge  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_rule_chain_to_edge_using_post(edge_id, rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_rule_chain_to_edge_using_post_with_http_info(edge_id, rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_rule_chain_to_edge_using_post_with_http_info(edge_id, rule_chain_id, **kwargs)  # noqa: E501
            return data

    def assign_rule_chain_to_edge_using_post_with_http_info(self, edge_id, rule_chain_id, **kwargs):  # noqa: E501
        """assignRuleChainToEdge  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_rule_chain_to_edge_using_post_with_http_info(edge_id, rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_rule_chain_to_edge_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params or
                params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `assign_rule_chain_to_edge_using_post`")  # noqa: E501
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `assign_rule_chain_to_edge_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']  # noqa: E501
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/edge/{edgeId}/ruleChain/{ruleChainId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_rule_chain_using_delete(self, rule_chain_id, **kwargs):  # noqa: E501
        """deleteRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule_chain_using_delete(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_rule_chain_using_delete_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_rule_chain_using_delete_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def delete_rule_chain_using_delete_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """deleteRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_rule_chain_using_delete_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_rule_chain_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `delete_rule_chain_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_rule_chains_using_get(self, limit, **kwargs):  # noqa: E501
        """exportRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_rule_chains_using_get(limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str limit: limit (required)
        :return: RuleChainData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_rule_chains_using_get_with_http_info(limit, **kwargs)  # noqa: E501
        else:
            (data) = self.export_rule_chains_using_get_with_http_info(limit, **kwargs)  # noqa: E501
            return data

    def export_rule_chains_using_get_with_http_info(self, limit, **kwargs):  # noqa: E501
        """exportRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_rule_chains_using_get_with_http_info(limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str limit: limit (required)
        :return: RuleChainData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_rule_chains_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `export_rule_chains_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChains/export{?limit}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChainData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auto_assign_to_edge_rule_chains_using_get(self, **kwargs):  # noqa: E501
        """getAutoAssignToEdgeRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_assign_to_edge_rule_chains_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[RuleChain]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auto_assign_to_edge_rule_chains_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auto_assign_to_edge_rule_chains_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auto_assign_to_edge_rule_chains_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """getAutoAssignToEdgeRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auto_assign_to_edge_rule_chains_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[RuleChain]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auto_assign_to_edge_rule_chains_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/autoAssignToEdgeRuleChains', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RuleChain]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_edge_rule_chains_using_get(self, edge_id, page_size, page, **kwargs):  # noqa: E501
        """getEdgeRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_rule_chains_using_get(edge_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataRuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_edge_rule_chains_using_get_with_http_info(edge_id, page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_edge_rule_chains_using_get_with_http_info(edge_id, page_size, page, **kwargs)  # noqa: E501
            return data

    def get_edge_rule_chains_using_get_with_http_info(self, edge_id, page_size, page, **kwargs):  # noqa: E501
        """getEdgeRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_edge_rule_chains_using_get_with_http_info(edge_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataRuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_edge_rule_chains_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params or
                params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `get_edge_rule_chains_using_get`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_edge_rule_chains_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_edge_rule_chains_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']  # noqa: E501

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/edge/{edgeId}/ruleChains{?textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataRuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_latest_rule_node_debug_input_using_get(self, rule_node_id, **kwargs):  # noqa: E501
        """getLatestRuleNodeDebugInput  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_rule_node_debug_input_using_get(rule_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_node_id: ruleNodeId (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_latest_rule_node_debug_input_using_get_with_http_info(rule_node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_latest_rule_node_debug_input_using_get_with_http_info(rule_node_id, **kwargs)  # noqa: E501
            return data

    def get_latest_rule_node_debug_input_using_get_with_http_info(self, rule_node_id, **kwargs):  # noqa: E501
        """getLatestRuleNodeDebugInput  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_latest_rule_node_debug_input_using_get_with_http_info(rule_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_node_id: ruleNodeId (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_latest_rule_node_debug_input_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_node_id' is set
        if ('rule_node_id' not in params or
                params['rule_node_id'] is None):
            raise ValueError("Missing the required parameter `rule_node_id` when calling `get_latest_rule_node_debug_input_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_node_id' in params:
            path_params['ruleNodeId'] = params['rule_node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleNode/{ruleNodeId}/debugIn', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_chain_by_id_using_get(self, rule_chain_id, **kwargs):  # noqa: E501
        """getRuleChainById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chain_by_id_using_get(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rule_chain_by_id_using_get_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_chain_by_id_using_get_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def get_rule_chain_by_id_using_get_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """getRuleChainById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chain_by_id_using_get_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rule_chain_by_id_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `get_rule_chain_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_chain_meta_data_using_get(self, rule_chain_id, **kwargs):  # noqa: E501
        """getRuleChainMetaData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chain_meta_data_using_get(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChainMetaData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rule_chain_meta_data_using_get_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_chain_meta_data_using_get_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def get_rule_chain_meta_data_using_get_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """getRuleChainMetaData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chain_meta_data_using_get_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChainMetaData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rule_chain_meta_data_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `get_rule_chain_meta_data_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChainMetaData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rule_chains_using_get(self, page_size, page, **kwargs):  # noqa: E501
        """getRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chains_using_get(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str type: type
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataRuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rule_chains_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rule_chains_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
            return data

    def get_rule_chains_using_get_with_http_info(self, page_size, page, **kwargs):  # noqa: E501
        """getRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rule_chains_using_get_with_http_info(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str type: type
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataRuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'type', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rule_chains_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_rule_chains_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_rule_chains_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChains{?type,textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataRuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_rule_chains_using_post(self, body, **kwargs):  # noqa: E501
        """importRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_rule_chains_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChainData body: ruleChainData (required)
        :param bool overwrite: overwrite
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_rule_chains_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.import_rule_chains_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def import_rule_chains_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """importRuleChains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_rule_chains_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChainData body: ruleChainData (required)
        :param bool overwrite: overwrite
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'overwrite']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_rule_chains_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `import_rule_chains_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChains/import{?overwrite}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_rule_chain_meta_data_using_post(self, body, **kwargs):  # noqa: E501
        """saveRuleChainMetaData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_meta_data_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChainMetaData body: ruleChainMetaData (required)
        :return: RuleChainMetaData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_rule_chain_meta_data_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.save_rule_chain_meta_data_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def save_rule_chain_meta_data_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """saveRuleChainMetaData  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_meta_data_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChainMetaData body: ruleChainMetaData (required)
        :return: RuleChainMetaData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_rule_chain_meta_data_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `save_rule_chain_meta_data_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/metadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChainMetaData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_rule_chain_using_post(self, body, **kwargs):  # noqa: E501
        """saveRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DefaultRuleChainCreateRequest body: request (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_rule_chain_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.save_rule_chain_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def save_rule_chain_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """saveRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DefaultRuleChainCreateRequest body: request (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_rule_chain_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `save_rule_chain_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/device/default', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_rule_chain_using_post1(self, body, **kwargs):  # noqa: E501
        """saveRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_using_post1(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChain body: ruleChain (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_rule_chain_using_post1_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.save_rule_chain_using_post1_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def save_rule_chain_using_post1_with_http_info(self, body, **kwargs):  # noqa: E501
        """saveRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_rule_chain_using_post1_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RuleChain body: ruleChain (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_rule_chain_using_post1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `save_rule_chain_using_post1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_auto_assign_to_edge_rule_chain_using_post(self, rule_chain_id, **kwargs):  # noqa: E501
        """setAutoAssignToEdgeRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_auto_assign_to_edge_rule_chain_using_post(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_auto_assign_to_edge_rule_chain_using_post_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_auto_assign_to_edge_rule_chain_using_post_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def set_auto_assign_to_edge_rule_chain_using_post_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """setAutoAssignToEdgeRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_auto_assign_to_edge_rule_chain_using_post_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_auto_assign_to_edge_rule_chain_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `set_auto_assign_to_edge_rule_chain_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}/autoAssignToEdge', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_edge_template_root_rule_chain_using_post(self, rule_chain_id, **kwargs):  # noqa: E501
        """setEdgeTemplateRootRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_edge_template_root_rule_chain_using_post(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_edge_template_root_rule_chain_using_post_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_edge_template_root_rule_chain_using_post_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def set_edge_template_root_rule_chain_using_post_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """setEdgeTemplateRootRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_edge_template_root_rule_chain_using_post_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_edge_template_root_rule_chain_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `set_edge_template_root_rule_chain_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}/edgeTemplateRoot', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_root_rule_chain_using_post1(self, rule_chain_id, **kwargs):  # noqa: E501
        """setRootRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_root_rule_chain_using_post1(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_root_rule_chain_using_post1_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_root_rule_chain_using_post1_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def set_root_rule_chain_using_post1_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """setRootRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_root_rule_chain_using_post1_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_root_rule_chain_using_post1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `set_root_rule_chain_using_post1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}/root', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def test_script_using_post(self, body, **kwargs):  # noqa: E501
        """testScript  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_script_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: inputParams (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.test_script_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.test_script_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def test_script_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """testScript  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_script_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: inputParams (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_script_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `test_script_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/testScript', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unassign_rule_chain_from_edge_using_delete(self, edge_id, rule_chain_id, **kwargs):  # noqa: E501
        """unassignRuleChainFromEdge  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unassign_rule_chain_from_edge_using_delete(edge_id, rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unassign_rule_chain_from_edge_using_delete_with_http_info(edge_id, rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unassign_rule_chain_from_edge_using_delete_with_http_info(edge_id, rule_chain_id, **kwargs)  # noqa: E501
            return data

    def unassign_rule_chain_from_edge_using_delete_with_http_info(self, edge_id, rule_chain_id, **kwargs):  # noqa: E501
        """unassignRuleChainFromEdge  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unassign_rule_chain_from_edge_using_delete_with_http_info(edge_id, rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str edge_id: edgeId (required)
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['edge_id', 'rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unassign_rule_chain_from_edge_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'edge_id' is set
        if ('edge_id' not in params or
                params['edge_id'] is None):
            raise ValueError("Missing the required parameter `edge_id` when calling `unassign_rule_chain_from_edge_using_delete`")  # noqa: E501
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `unassign_rule_chain_from_edge_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edge_id' in params:
            path_params['edgeId'] = params['edge_id']  # noqa: E501
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/edge/{edgeId}/ruleChain/{ruleChainId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unset_auto_assign_to_edge_rule_chain_using_delete(self, rule_chain_id, **kwargs):  # noqa: E501
        """unsetAutoAssignToEdgeRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unset_auto_assign_to_edge_rule_chain_using_delete(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unset_auto_assign_to_edge_rule_chain_using_delete_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unset_auto_assign_to_edge_rule_chain_using_delete_with_http_info(rule_chain_id, **kwargs)  # noqa: E501
            return data

    def unset_auto_assign_to_edge_rule_chain_using_delete_with_http_info(self, rule_chain_id, **kwargs):  # noqa: E501
        """unsetAutoAssignToEdgeRuleChain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unset_auto_assign_to_edge_rule_chain_using_delete_with_http_info(rule_chain_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str rule_chain_id: ruleChainId (required)
        :return: RuleChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_chain_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unset_auto_assign_to_edge_rule_chain_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'rule_chain_id' is set
        if ('rule_chain_id' not in params or
                params['rule_chain_id'] is None):
            raise ValueError("Missing the required parameter `rule_chain_id` when calling `unset_auto_assign_to_edge_rule_chain_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'rule_chain_id' in params:
            path_params['ruleChainId'] = params['rule_chain_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/ruleChain/{ruleChainId}/autoAssignToEdge', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RuleChain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
