# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class DeviceGroupOtaPackageControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_device_group_ota_package_using_delete(self, id, **kwargs):  # noqa: E501
        """deleteDeviceGroupOtaPackage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_group_ota_package_using_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_device_group_ota_package_using_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_device_group_ota_package_using_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_device_group_ota_package_using_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """deleteDeviceGroupOtaPackage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_group_ota_package_using_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_device_group_ota_package_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_device_group_ota_package_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceGroupOtaPackage/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_firmware_by_id_using_get(self, group_id, firmware_type, **kwargs):  # noqa: E501
        """getFirmwareById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_firmware_by_id_using_get(group_id, firmware_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: groupId (required)
        :param str firmware_type: firmwareType (required)
        :return: DeviceGroupOtaPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_firmware_by_id_using_get_with_http_info(group_id, firmware_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_firmware_by_id_using_get_with_http_info(group_id, firmware_type, **kwargs)  # noqa: E501
            return data

    def get_firmware_by_id_using_get_with_http_info(self, group_id, firmware_type, **kwargs):  # noqa: E501
        """getFirmwareById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_firmware_by_id_using_get_with_http_info(group_id, firmware_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: groupId (required)
        :param str firmware_type: firmwareType (required)
        :return: DeviceGroupOtaPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'firmware_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_firmware_by_id_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params or
                params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_firmware_by_id_using_get`")  # noqa: E501
        # verify the required parameter 'firmware_type' is set
        if ('firmware_type' not in params or
                params['firmware_type'] is None):
            raise ValueError("Missing the required parameter `firmware_type` when calling `get_firmware_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']  # noqa: E501
        if 'firmware_type' in params:
            path_params['firmwareType'] = params['firmware_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceGroupOtaPackage/{groupId}/{firmwareType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceGroupOtaPackage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_device_group_ota_package_using_post(self, body, **kwargs):  # noqa: E501
        """saveDeviceGroupOtaPackage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_device_group_ota_package_using_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeviceGroupOtaPackage body: deviceGroupOtaPackage (required)
        :return: DeviceGroupOtaPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_device_group_ota_package_using_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.save_device_group_ota_package_using_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def save_device_group_ota_package_using_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """saveDeviceGroupOtaPackage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_device_group_ota_package_using_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeviceGroupOtaPackage body: deviceGroupOtaPackage (required)
        :return: DeviceGroupOtaPackage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_device_group_ota_package_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `save_device_group_ota_package_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/deviceGroupOtaPackage', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeviceGroupOtaPackage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
