# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['click_rich_help']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0,<9.0', 'rich>=10.0,<11.0']

setup_kwargs = {
    'name': 'click-rich-help',
    'version': '0.2.0',
    'description': 'make a beautiful click app with rich',
    'long_description': '<div id="top"></div>\n\n<!-- PROJECT SHIELDS -->\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n[![MIT License][license-shield]][license-url]\n\n\n<!-- PROJECT LOGO -->\n<br />\n<div align="center">\n  <a href="https://github.com/daylinmorgan/click-rich-help">\n    <img src="https://raw.githubusercontent.com/daylinmorgan/click-rich-help/main/assets/logo.png" alt="Logo" width=400 >\n  </a>\n\n<h2 align="center">click-rich-help</h2>\n\n  <p align="center">\n    make a beautiful click app with rich\n  </p>\n</div>\n\n\n<!-- TABLE OF CONTENTS -->\n<details>\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n      <ul>\n        <li><a href="#built-with">Built With</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#installation">Installation</a></li>\n      </ul>\n    </li>\n    <li><a href="#usage">Usage</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#acknowledgments">Acknowledgments</a></li>\n  </ol>\n</details>\n\n\n\n<!-- ABOUT THE PROJECT -->\n## About The Project\n\n\n\n\nClick the on the cast below to see it in action!\n\n<a href="https://asciinema.org/a/lKXkDlwBi1pHLAbfyO6FZZp9a"> <img src="https://asciinema.org/a/lKXkDlwBi1pHLAbfyO6FZZp9a.svg" width=500> </a>\n\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n### Built With\n\n* [click](https://click.palletsprojects.com/en/8.0.x/)\n* [rich](https://rich.readthedocs.io/en/latest/)\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- GETTING STARTED -->\n## Getting Started\n\n\n### Installation\n\nwith pip:\n``` bash\npip install click-rich-help\n```\nwith conda/mamba:\n```bash\nconda install -c conda-forge click-rich-help\n```\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- USAGE EXAMPLES -->\n## Usage\n\nThe syntax for usage is not much different than [click-help-colors](https://github.com/click-contrib/click-help-colors) on which this project is based.\n\nYou apply the class to `click` groups or commands like so:\n\n```python\n@click.group(\n    cls=StyledGroup,\n    headers_style="yellow bold",\n    options_style="cyan italic",\n    metavar_style="red bold",\n)\ndef cli():\n    pass\n```\n\nNote that the general context has changed from help _colors_ to help _styles_.\nThis was intentionally changed to reflect the addition of other ANSII styles, i.e. bold, italic.\n\nThis isn\'t the only significant change though! Now there is also support for coloring metavars.\nIf no color is specified than they will default to the color of the options.\n\nIn addition any string that would usually be passed to click will be parsed by `rich` to apply the needed colors and styles.\n\nThis means you can use rich syntax in `click.option()` decorators as well as in docstrings of commands. For instance, you can have something like below.\n\n```python\nimport click\nfrom click_rich_help import StyledCommand\n\n@click.command(\n    cls=StyledCommand,\n    options_style="italic cyan",\n    headers_style="bold yellow"\n)\n@click.option(\'--count\', default=1, help=\'[red]Number[/red] of greetings.\')\n@click.option(\'--name\', prompt=\'Your name\',\n              help=\'The person to greet.\')\ndef hello(count, name):\n    """Simple program that greets [b yellow]NAME[/b yellow] for a total of [b yellow]COUNT[/b yellow] times."""\n    for x in range(count):\n        click.echo(f"Hello {name}!")\n\nif __name__ == \'__main__\':\n    hello()\n```\n\nIf you were to view the `--help` of the above command you should see the below output.\n\n![option_color](https://raw.githubusercontent.com/daylinmorgan/click-rich-help/main/assets/option_example.png)\n\n\nTo preview the included example module in your own terminal you can use two methods:\n\nW/o `click-rich-help` and w/ `asciinema`\n\n```bash\nasciinema play https://asciinema.org/a/81psoVhEc6F568fZppb6qKBVb\n```\n\nW/ `click-rich-help`  and `curl`\n\n```bash\ncurl -s https://raw.githubusercontent.com/daylinmorgan/click-rich-help/main/scripts/example.sh | bash\n```\n\nYou can also run it yourself if you have installed `click-rich-help`. Which you should!\n\n```bash\npython -m click_rich_help.example -h\n```\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n<!-- CONTRIBUTING -->\n## Contributing\n\nTo contribute please utilize `poetry` and `pre-commit`.\n\noptionally manage python installation with `conda`:\n\n```bash\nconda create -n rich_dev python=3.7 poetry\n```\n\nThen follow the below steps\n1. Fork the Project\n2. Install the package and dev dependencies w/poetry(`cd click-rich-help; poetry install`)\n2. Create your Feature Branch (`git checkout -b feat/AmazingFeature`)\n3. Commit your Changes (`git commit -m \'Add some AmazingFeature\'`)\n4. Push to the Branch (`git push origin feat/AmazingFeature`)\n5. Open a Pull Request\n\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n## Roadmap\n\n- [x] Integrated example module\n- [ ] Implement Type checking\n- [ ] Add option to color all help strings\n- [ ] CI\n\t- [ ] test\n\t- [ ] pypi\n\n<!-- CONTACT -->\n## Contact\n\nDaylin Morgan - [@tweetsbydaylin](https://twitter.com/tweetsbydaylin)\n\nProject Link: [https://github.com/daylinmorgan/click-rich-help](https://github.com/daylinmorgan/click-rich-help)\n\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- ACKNOWLEDGMENTS -->\n## Acknowledgments\n\n* [click](https://github.com/pallets/click)\n* [rich](https://github.com/willmcgugan/rich)\n* [click-help-colors](https://github.com/click-contrib/click-help-colors)\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- MARKDOWN LINKS & IMAGES -->\n<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->\n[contributors-shield]: https://img.shields.io/github/contributors/daylinmorgan/click-rich-help.svg?style=flat\n[contributors-url]: https://github.com/daylinmorgan/click-rich-help/graphs/contributors\n[forks-shield]: https://img.shields.io/github/forks/daylinmorgan/click-rich-help.svg?style=flat\n[forks-url]: https://github.com/daylinmorgan/click-rich-help/network/members\n[stars-shield]: https://img.shields.io/github/stars/daylinmorgan/click-rich-help.svg?style=flat\n[stars-url]: https://github.com/daylinmorgan/click-rich-help/stargazers\n[issues-shield]: https://img.shields.io/github/issues/daylinmorgan/click-rich-help.svg?style=flat\n[issues-url]: https://github.com/daylinmorgan/click-rich-help/issues\n[license-shield]: https://img.shields.io/github/license/daylinmorgan/click-rich-help.svg?style=flat\n[license-url]: https://github.com/daylinmorgan/click-rich-help/blob/main/LICENSE.txt\n',
    'author': 'Daylin Morgan',
    'author_email': 'daylinmorgan@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/daylinmorgan/click-rich-help',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
