import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudK8SClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_cluster#id DataIonoscloudK8SCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_cluster#name DataIonoscloudK8SCluster#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_cluster#timeouts DataIonoscloudK8SCluster#timeouts}
    */
    readonly timeouts?: DataIonoscloudK8SClusterTimeouts;
}
export interface DataIonoscloudK8SClusterConfigClusters {
}
export declare function dataIonoscloudK8SClusterConfigClustersToTerraform(struct?: DataIonoscloudK8SClusterConfigClusters): any;
export declare class DataIonoscloudK8SClusterConfigClustersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SClusterConfigClusters | undefined;
    set internalValue(value: DataIonoscloudK8SClusterConfigClusters | undefined);
    private _cluster;
    get cluster(): cdktf.StringMap;
    get name(): string;
}
export declare class DataIonoscloudK8SClusterConfigClustersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SClusterConfigClustersOutputReference;
}
export interface DataIonoscloudK8SClusterConfigContexts {
}
export declare function dataIonoscloudK8SClusterConfigContextsToTerraform(struct?: DataIonoscloudK8SClusterConfigContexts): any;
export declare class DataIonoscloudK8SClusterConfigContextsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SClusterConfigContexts | undefined;
    set internalValue(value: DataIonoscloudK8SClusterConfigContexts | undefined);
    private _context;
    get context(): cdktf.StringMap;
    get name(): string;
}
export declare class DataIonoscloudK8SClusterConfigContextsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SClusterConfigContextsOutputReference;
}
export interface DataIonoscloudK8SClusterConfigUsers {
}
export declare function dataIonoscloudK8SClusterConfigUsersToTerraform(struct?: DataIonoscloudK8SClusterConfigUsers): any;
export declare class DataIonoscloudK8SClusterConfigUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SClusterConfigUsers | undefined;
    set internalValue(value: DataIonoscloudK8SClusterConfigUsers | undefined);
    get name(): string;
    private _user;
    get user(): cdktf.StringMap;
}
export declare class DataIonoscloudK8SClusterConfigUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SClusterConfigUsersOutputReference;
}
export interface DataIonoscloudK8SClusterConfigA {
}
export declare function dataIonoscloudK8SClusterConfigAToTerraform(struct?: DataIonoscloudK8SClusterConfigA): any;
export declare class DataIonoscloudK8SClusterConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SClusterConfigA | undefined;
    set internalValue(value: DataIonoscloudK8SClusterConfigA | undefined);
    get apiVersion(): string;
    private _clusters;
    get clusters(): DataIonoscloudK8SClusterConfigClustersList;
    private _contexts;
    get contexts(): DataIonoscloudK8SClusterConfigContextsList;
    get currentContext(): string;
    get kind(): string;
    private _users;
    get users(): DataIonoscloudK8SClusterConfigUsersList;
}
export declare class DataIonoscloudK8SClusterConfigAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SClusterConfigAOutputReference;
}
export interface DataIonoscloudK8SClusterMaintenanceWindow {
}
export declare function dataIonoscloudK8SClusterMaintenanceWindowToTerraform(struct?: DataIonoscloudK8SClusterMaintenanceWindow): any;
export declare class DataIonoscloudK8SClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SClusterMaintenanceWindow | undefined;
    set internalValue(value: DataIonoscloudK8SClusterMaintenanceWindow | undefined);
    get dayOfTheWeek(): string;
    get time(): string;
}
export declare class DataIonoscloudK8SClusterMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SClusterMaintenanceWindowOutputReference;
}
export interface DataIonoscloudK8SClusterS3Buckets {
}
export declare function dataIonoscloudK8SClusterS3BucketsToTerraform(struct?: DataIonoscloudK8SClusterS3Buckets): any;
export declare class DataIonoscloudK8SClusterS3BucketsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SClusterS3Buckets | undefined;
    set internalValue(value: DataIonoscloudK8SClusterS3Buckets | undefined);
    get name(): string;
}
export declare class DataIonoscloudK8SClusterS3BucketsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SClusterS3BucketsOutputReference;
}
export interface DataIonoscloudK8SClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_cluster#create DataIonoscloudK8SCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_cluster#default DataIonoscloudK8SCluster#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_cluster#delete DataIonoscloudK8SCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_cluster#update DataIonoscloudK8SCluster#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudK8SClusterTimeoutsToTerraform(struct?: DataIonoscloudK8SClusterTimeoutsOutputReference | DataIonoscloudK8SClusterTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudK8SClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudK8SClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudK8SClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_cluster ionoscloud_k8s_cluster}
*/
export declare class DataIonoscloudK8SCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_k8s_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_cluster ionoscloud_k8s_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudK8SClusterConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudK8SClusterConfig);
    get apiSubnetAllowList(): string[];
    get availableUpgradeVersions(): string[];
    get caCrt(): string;
    private _config;
    get config(): DataIonoscloudK8SClusterConfigAList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get k8SVersion(): string;
    get kubeConfig(): string;
    private _maintenanceWindow;
    get maintenanceWindow(): DataIonoscloudK8SClusterMaintenanceWindowList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get nodePools(): string[];
    private _s3Buckets;
    get s3Buckets(): DataIonoscloudK8SClusterS3BucketsList;
    get server(): string;
    get state(): string;
    private _userTokens;
    get userTokens(): cdktf.StringMap;
    get viableNodePoolVersions(): string[];
    private _timeouts;
    get timeouts(): DataIonoscloudK8SClusterTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudK8SClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudK8SClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
