import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [amplify](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplify.html).
 *
 * @experimental
 */
export declare class Amplify extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [amplify](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplify.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Creates a new Amplify App.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toCreateApp(): this;
    /**
     * (experimental) Creates a new backend environment for an Amplify App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toCreateBackendEnvironment(): this;
    /**
     * (experimental) Creates a new Branch for an Amplify App.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toCreateBranch(): this;
    /**
     * (experimental) Create a deployment for manual deploy apps. (Apps are not connected to repository).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toCreateDeployment(): this;
    /**
     * (experimental) Create a new DomainAssociation on an App.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toCreateDomainAssociation(): this;
    /**
     * (experimental) Create a new webhook on an App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toCreateWebHook(): this;
    /**
     * (experimental) Delete an existing Amplify App by appId.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toDeleteApp(): this;
    /**
     * (experimental) Deletes a branch for an Amplify App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toDeleteBackendEnvironment(): this;
    /**
     * (experimental) Deletes a branch for an Amplify App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toDeleteBranch(): this;
    /**
     * (experimental) Deletes a DomainAssociation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toDeleteDomainAssociation(): this;
    /**
     * (experimental) Delete a job, for an Amplify branch, part of Amplify App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toDeleteJob(): this;
    /**
     * (experimental) Delete a webhook by id.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toDeleteWebHook(): this;
    /**
     * (experimental) Generate website access logs for a specific time range via a pre-signed URL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toGenerateAccessLogs(): this;
    /**
     * (experimental) Retrieves an existing Amplify App by appId.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toGetApp(): this;
    /**
     * (experimental) Retrieves artifact info that corresponds to a artifactId.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toGetArtifactUrl(): this;
    /**
     * (experimental) Retrieves a backend environment for an Amplify App.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toGetBackendEnvironment(): this;
    /**
     * (experimental) Retrieves a branch for an Amplify App.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toGetBranch(): this;
    /**
     * (experimental) Retrieves domain info that corresponds to an appId and domainName.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toGetDomainAssociation(): this;
    /**
     * (experimental) Get a job for a branch, part of an Amplify App.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toGetJob(): this;
    /**
     * (experimental) Retrieves webhook info that corresponds to a webhookId.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toGetWebHook(): this;
    /**
     * (experimental) Lists existing Amplify Apps.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toListApps(): this;
    /**
     * (experimental) List artifacts with an app, a branch, a job and an artifact type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toListArtifacts(): this;
    /**
     * (experimental) Lists backend environments for an Amplify App.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toListBackendEnvironments(): this;
    /**
     * (experimental) Lists branches for an Amplify App.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toListBranches(): this;
    /**
     * (experimental) List domains with an app.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toListDomainAssociations(): this;
    /**
     * (experimental) List Jobs for a branch, part of an Amplify App.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toListJobs(): this;
    /**
     * (experimental) List tags for an AWS Amplify Console resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) List webhooks on an App.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toListWebHooks(): this;
    /**
     * (experimental) Start a deployment for manual deploy apps. (Apps are not connected to repository).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toStartDeployment(): this;
    /**
     * (experimental) Starts a new job for a branch, part of an Amplify App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toStartJob(): this;
    /**
     * (experimental) Stop a job that is in progress, for an Amplify branch, part of Amplify App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toStopJob(): this;
    /**
     * (experimental) This action tags an AWS Amplify Console resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) This action removes a tag from an AWS Amplify Console resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Updates an existing Amplify App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toUpdateApp(): this;
    /**
     * (experimental) Updates a branch for an Amplify App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toUpdateBranch(): this;
    /**
     * (experimental) Update a DomainAssociation on an App.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toUpdateDomainAssociation(): this;
    /**
     * (experimental) Update a webhook.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @experimental
     */
    toUpdateWebHook(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type apps to the statement.
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApps(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type branches to the statement.
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @param appId - Identifier for the appId.
     * @param branchName - Identifier for the branchName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBranches(appId: string, branchName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type jobs to the statement.
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @param appId - Identifier for the appId.
     * @param branchName - Identifier for the branchName.
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onJobs(appId: string, branchName: string, jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type domains to the statement.
     *
     * https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html
     *
     * @param appId - Identifier for the appId.
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDomains(appId: string, domainName: string, account?: string, region?: string, partition?: string): this;
}
