import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [cloudshell](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudshell.html).
 *
 * @experimental
 */
export declare class Cloudshell extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [cloudshell](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudshell.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permissions to create a CloudShell environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#CreateEnvironment
     *
     * @experimental
     */
    toCreateEnvironment(): this;
    /**
     * (experimental) Grants permissions to connect to a CloudShell environment from the AWS Management Console.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#CreateSession
     *
     * @experimental
     */
    toCreateSession(): this;
    /**
     * (experimental) Grants permission to delete a CloudShell environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#DeleteEnvironment
     *
     * @experimental
     */
    toDeleteEnvironment(): this;
    /**
     * (experimental) Grants permission to read a CloudShell environment status.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#GetEnvironmentStatus
     *
     * @experimental
     */
    toGetEnvironmentStatus(): this;
    /**
     * (experimental) Grants permissions to download files from a CloudShell environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#GetFileDownloadUrls
     *
     * @experimental
     */
    toGetFileDownloadUrls(): this;
    /**
     * (experimental) Grants permissions to upload files to a CloudShell environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#GetFileUploadUrls
     *
     * @experimental
     */
    toGetFileUploadUrls(): this;
    /**
     * (experimental) Grants permissions to forward console credentials to the environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#PutCredentials
     *
     * @experimental
     */
    toPutCredentials(): this;
    /**
     * (experimental) Grants permission to start a stopped CloudShell environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#StartEnvironment
     *
     * @experimental
     */
    toStartEnvironment(): this;
    /**
     * (experimental) Grants permission to stop a running CloudShell environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#StopEnvironment
     *
     * @experimental
     */
    toStopEnvironment(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Environment to the statement.
     *
     * https://docs.aws.amazon.com/cloudshell/latest/userguide/sec-auth-with-identities.html#Environment
     *
     * @param environmentId - Identifier for the environmentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEnvironment(environmentId: string, account?: string, region?: string, partition?: string): this;
}
