import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [elasticbeanstalk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticbeanstalk.html).
 *
 * @experimental
 */
export declare class Elasticbeanstalk extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [elasticbeanstalk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticbeanstalk.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to cancel in-progress environment configuration update or application version deployment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_AbortEnvironmentUpdate.html
     *
     * @experimental
     */
    toAbortEnvironmentUpdate(): this;
    /**
     * (experimental) Grants permission to add tags to an Elastic Beanstalk resource and to update tag values.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateTagsForResource.html
     *
     * @experimental
     */
    toAddTags(): this;
    /**
     * (experimental) Grants permission to apply a scheduled managed action immediately.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ApplyEnvironmentManagedAction.html
     *
     * @experimental
     */
    toApplyEnvironmentManagedAction(): this;
    /**
     * (experimental) Grants permission to associate an operations role with an environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_AssociateEnvironmentOperationsRole.html
     *
     * @experimental
     */
    toAssociateEnvironmentOperationsRole(): this;
    /**
     * (experimental) Grants permission to check CNAME availability.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CheckDNSAvailability.html
     *
     * @experimental
     */
    toCheckDNSAvailability(): this;
    /**
     * (experimental) Grants permission to create or update a group of environments, each running a separate component of a single application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ComposeEnvironments.html
     *
     * @experimental
     */
    toComposeEnvironments(): this;
    /**
     * (experimental) Grants permission to create a new application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateApplication.html
     *
     * @experimental
     */
    toCreateApplication(): this;
    /**
     * (experimental) Grants permission to create an application version for an application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateApplicationVersion.html
     *
     * @experimental
     */
    toCreateApplicationVersion(): this;
    /**
     * (experimental) Grants permission to create a configuration template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromApplication()
     * - .ifFromApplicationVersion()
     * - .ifFromConfigurationTemplate()
     * - .ifFromEnvironment()
     * - .ifFromSolutionStack()
     * - .ifFromPlatform()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateConfigurationTemplate.html
     *
     * @experimental
     */
    toCreateConfigurationTemplate(): this;
    /**
     * (experimental) Grants permission to launch an environment for an application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromApplicationVersion()
     * - .ifFromConfigurationTemplate()
     * - .ifFromSolutionStack()
     * - .ifFromPlatform()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateEnvironment.html
     *
     * @experimental
     */
    toCreateEnvironment(): this;
    /**
     * (experimental) Grants permission to create a new version of a custom platform.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreatePlatformVersion.html
     *
     * @experimental
     */
    toCreatePlatformVersion(): this;
    /**
     * (experimental) Grants permission to create the Amazon S3 storage location for the account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateStorageLocation.html
     *
     * @experimental
     */
    toCreateStorageLocation(): this;
    /**
     * (experimental) Grants permission to delete an application along with all associated versions and configurations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeleteApplication.html
     *
     * @experimental
     */
    toDeleteApplication(): this;
    /**
     * (experimental) Grants permission to delete an application version from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeleteApplicationVersion.html
     *
     * @experimental
     */
    toDeleteApplicationVersion(): this;
    /**
     * (experimental) Grants permission to delete a configuration template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeleteConfigurationTemplate.html
     *
     * @experimental
     */
    toDeleteConfigurationTemplate(): this;
    /**
     * (experimental) Grants permission to delete the draft configuration associated with the running environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeleteEnvironmentConfiguration.html
     *
     * @experimental
     */
    toDeleteEnvironmentConfiguration(): this;
    /**
     * (experimental) Grants permission to delete a version of a custom platform.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeletePlatformVersion.html
     *
     * @experimental
     */
    toDeletePlatformVersion(): this;
    /**
     * (experimental) Grants permission to retrieve a list of account attributes, including resource quotas.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeAccountAttributes.html
     *
     * @experimental
     */
    toDescribeAccountAttributes(): this;
    /**
     * (experimental) Grants permission to retrieve a list of application versions stored in an AWS Elastic Beanstalk storage bucket.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeApplicationVersions.html
     *
     * @experimental
     */
    toDescribeApplicationVersions(): this;
    /**
     * (experimental) Grants permission to retrieve the descriptions of existing applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeApplications.html
     *
     * @experimental
     */
    toDescribeApplications(): this;
    /**
     * (experimental) Grants permission to retrieve descriptions of environment configuration options.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeConfigurationOptions.html
     *
     * @experimental
     */
    toDescribeConfigurationOptions(): this;
    /**
     * (experimental) Grants permission to retrieve a description of the settings for a configuration set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeConfigurationSettings.html
     *
     * @experimental
     */
    toDescribeConfigurationSettings(): this;
    /**
     * (experimental) Grants permission to retrieve information about the overall health of an environment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironmentHealth.html
     *
     * @experimental
     */
    toDescribeEnvironmentHealth(): this;
    /**
     * (experimental) Grants permission to retrieve a list of an environment's completed and failed managed actions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironmentManagedActionHistory.html
     *
     * @experimental
     */
    toDescribeEnvironmentManagedActionHistory(): this;
    /**
     * (experimental) Grants permission to retrieve a list of an environment's upcoming and in-progress managed actions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironmentManagedActions.html
     *
     * @experimental
     */
    toDescribeEnvironmentManagedActions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of AWS resources for an environment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironmentResources.html
     *
     * @experimental
     */
    toDescribeEnvironmentResources(): this;
    /**
     * (experimental) Grants permission to retrieve descriptions for existing environments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironments.html
     *
     * @experimental
     */
    toDescribeEnvironments(): this;
    /**
     * (experimental) Grants permission to retrieve a list of event descriptions matching a set of criteria.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEvents.html
     *
     * @experimental
     */
    toDescribeEvents(): this;
    /**
     * (experimental) Grants permission to retrieve more detailed information about the health of environment instances.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeInstancesHealth.html
     *
     * @experimental
     */
    toDescribeInstancesHealth(): this;
    /**
     * (experimental) Grants permission to retrieve a description of a platform version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribePlatformVersion.html
     *
     * @experimental
     */
    toDescribePlatformVersion(): this;
    /**
     * (experimental) Grants permission to disassociate an operations role with an environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DisassociateEnvironmentOperationsRole.html
     *
     * @experimental
     */
    toDisassociateEnvironmentOperationsRole(): this;
    /**
     * (experimental) Grants permission to retrieve a list of the available solution stack names.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html
     *
     * @experimental
     */
    toListAvailableSolutionStacks(): this;
    /**
     * (experimental) Grants permission to retrieve a list of the available platform branches.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListPlatformBranches.html
     *
     * @experimental
     */
    toListPlatformBranches(): this;
    /**
     * (experimental) Grants permission to retrieve a list of the available platforms.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListPlatformVersions.html
     *
     * @experimental
     */
    toListPlatformVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of tags of an Elastic Beanstalk resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to submit instance statistics for enhanced health.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html#health-enhanced-authz
     *
     * @experimental
     */
    toPutInstanceStatistics(): this;
    /**
     * (experimental) Grants permission to delete and recreate all of the AWS resources for an environment and to force a restart.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_RebuildEnvironment.html
     *
     * @experimental
     */
    toRebuildEnvironment(): this;
    /**
     * (experimental) Grants permission to remove tags from an Elastic Beanstalk resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateTagsForResource.html
     *
     * @experimental
     */
    toRemoveTags(): this;
    /**
     * (experimental) Grants permission to initiate a request to compile information of the deployed environment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_RequestEnvironmentInfo.html
     *
     * @experimental
     */
    toRequestEnvironmentInfo(): this;
    /**
     * (experimental) Grants permission to request an environment to restart the application container server running on each Amazon EC2 instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_RestartAppServer.html
     *
     * @experimental
     */
    toRestartAppServer(): this;
    /**
     * (experimental) Grants permission to retrieve the compiled information from a RequestEnvironmentInfo request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_RetrieveEnvironmentInfo.html
     *
     * @experimental
     */
    toRetrieveEnvironmentInfo(): this;
    /**
     * (experimental) Grants permission to swap the CNAMEs of two environments.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromEnvironment()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_SwapEnvironmentCNAMEs.html
     *
     * @experimental
     */
    toSwapEnvironmentCNAMEs(): this;
    /**
     * (experimental) Grants permission to terminate an environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_TerminateEnvironment.html
     *
     * @experimental
     */
    toTerminateEnvironment(): this;
    /**
     * (experimental) Grants permission to update an application with specified properties.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateApplication.html
     *
     * @experimental
     */
    toUpdateApplication(): this;
    /**
     * (experimental) Grants permission to update the application version lifecycle policy associated with the application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateApplicationResourceLifecycle.html
     *
     * @experimental
     */
    toUpdateApplicationResourceLifecycle(): this;
    /**
     * (experimental) Grants permission to update an application version with specified properties.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateApplicationVersion.html
     *
     * @experimental
     */
    toUpdateApplicationVersion(): this;
    /**
     * (experimental) Grants permission to update a configuration template with specified properties or configuration option values.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromApplication()
     * - .ifFromApplicationVersion()
     * - .ifFromConfigurationTemplate()
     * - .ifFromEnvironment()
     * - .ifFromSolutionStack()
     * - .ifFromPlatform()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateConfigurationTemplate.html
     *
     * @experimental
     */
    toUpdateConfigurationTemplate(): this;
    /**
     * (experimental) Grants permission to update an environment.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromApplicationVersion()
     * - .ifFromConfigurationTemplate()
     * - .ifFromSolutionStack()
     * - .ifFromPlatform()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateEnvironment.html
     *
     * @experimental
     */
    toUpdateEnvironment(): this;
    /**
     * (experimental) Grants permission to add tags to an Elastic Beanstalk resource, remove tags, and to update tag values.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateTagsForResource.html
     *
     * @experimental
     */
    toUpdateTagsForResource(): this;
    /**
     * (experimental) Grants permission to check the validity of a set of configuration settings for a configuration template or an environment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ValidateConfigurationSettings.html
     *
     * @experimental
     */
    toValidateConfigurationSettings(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type application to the statement.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApplication(applicationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type applicationversion to the statement.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param versionLabel - Identifier for the versionLabel.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApplicationversion(applicationName: string, versionLabel: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type configurationtemplate to the statement.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param templateName - Identifier for the templateName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onConfigurationtemplate(applicationName: string, templateName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type environment to the statement.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param environmentName - Identifier for the environmentName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEnvironment(applicationName: string, environmentName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type solutionstack to the statement.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param solutionStackName - Identifier for the solutionStackName.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSolutionstack(solutionStackName: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type platform to the statement.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param platformNameWithVersion - Identifier for the platformNameWithVersion.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onPlatform(platformNameWithVersion: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by an application as a dependency or a constraint on an input parameter.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toUpdateConfigurationTemplate()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifFromApplication(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by an application version as a dependency or a constraint on an input parameter.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifFromApplicationVersion(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by a configuration template as a dependency or a constraint on an input parameter.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifFromConfigurationTemplate(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by an environment as a dependency or a constraint on an input parameter.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toSwapEnvironmentCNAMEs()
     * - .toUpdateConfigurationTemplate()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifFromEnvironment(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by a platform as a dependency or a constraint on an input parameter.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifFromPlatform(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by a solution stack as a dependency or a constraint on an input parameter.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifFromSolutionStack(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the application that contains the resource that the action operates on.
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toAbortEnvironmentUpdate()
     * - .toApplyEnvironmentManagedAction()
     * - .toComposeEnvironments()
     * - .toCreateApplicationVersion()
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toDeleteApplicationVersion()
     * - .toDeleteConfigurationTemplate()
     * - .toDeleteEnvironmentConfiguration()
     * - .toDescribeApplicationVersions()
     * - .toDescribeConfigurationOptions()
     * - .toDescribeConfigurationSettings()
     * - .toDescribeEnvironmentManagedActionHistory()
     * - .toDescribeEnvironmentManagedActions()
     * - .toDescribeEnvironmentResources()
     * - .toDescribeEnvironments()
     * - .toDescribeEvents()
     * - .toRebuildEnvironment()
     * - .toRequestEnvironmentInfo()
     * - .toRestartAppServer()
     * - .toRetrieveEnvironmentInfo()
     * - .toSwapEnvironmentCNAMEs()
     * - .toTerminateEnvironment()
     * - .toUpdateApplicationVersion()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     * - .toValidateConfigurationSettings()
     *
     * Applies to resource types:
     * - applicationversion
     * - configurationtemplate
     * - environment
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifInApplication(value: string | string[], operator?: Operator | string): this;
}
