"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplacePrivate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprivatemarketplace.html).
 *
 * @experimental
 */
class AwsMarketplacePrivate extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprivatemarketplace.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'aws-marketplace';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AssociateProductsWithPrivateMarketplace",
                "CreatePrivateMarketplaceRequests",
                "DisassociateProductsFromPrivateMarketplace"
            ],
            "List": [
                "DescribePrivateMarketplaceRequests",
                "ListPrivateMarketplaceRequests"
            ]
        };
    }
    /**
     * (experimental) Grants permission to add new approved products to the Private Marketplace.
     *
     * Also allows to approve a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toAssociateProductsWithPrivateMarketplace() {
        return this.to('AssociateProductsWithPrivateMarketplace');
    }
    /**
     * (experimental) Grants permission to create a new request for a product or products to be associated with the Private Marketplace.
     *
     * This action can be performed by any account in an in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toCreatePrivateMarketplaceRequests() {
        return this.to('CreatePrivateMarketplaceRequests');
    }
    /**
     * (experimental) Grants permission to describe requests and associated products in the Private Marketplace.
     *
     * This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toDescribePrivateMarketplaceRequests() {
        return this.to('DescribePrivateMarketplaceRequests');
    }
    /**
     * (experimental) Grants permission to remove approved products from the Private Marketplace.
     *
     * Also allows to decline a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toDisassociateProductsFromPrivateMarketplace() {
        return this.to('DisassociateProductsFromPrivateMarketplace');
    }
    /**
     * (experimental) Grants permission to get a queryable list for requests and associated products in the Private Marketplace.
     *
     * This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toListPrivateMarketplaceRequests() {
        return this.to('ListPrivateMarketplaceRequests');
    }
}
exports.AwsMarketplacePrivate = AwsMarketplacePrivate;
_a = JSII_RTTI_SYMBOL_1;
AwsMarketplacePrivate[_a] = { fqn: "iam-floyd.AwsMarketplacePrivate", version: "0.248.0" };
//# sourceMappingURL=data:application/json;base64,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